/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr;

import java.util.Iterator;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseElse;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseExpressionWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSearchTable;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSearchWhenContentElement;
import org.eclipse.datatools.sqltools.sqlbuilder.model.CaseHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.util.WorkbenchUtility;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class CaseSearchPage
extends WizardPage
implements SelectionListener {
    private SQLDomainModel domainModel;
    private SQLQueryObject sqlStatement;
    private Composite tablePanel;
    private QueryValueExpression inputSQLExpression;
    private QueryValueExpression updatedSQLExpression;
    private ValueExpressionCaseSearch sqlCaseSearchWhenClause;
    private StyledText previewExpressionText;
    private CaseSearchTable caseSearchTable;
    private CaseSearchWhenContentElement elementToUpdate;
    private CaseHelper caseHelper;
    private ValueExpressionCaseElse caseElseClauseCache;
    private Button addWhenClauseButton;
    private Button addElseClauseButton;
    private boolean isComplete;

    public CaseSearchPage(SQLDomainModel domainModel, SQLQueryObject sqlStatementArg, QueryValueExpression sqlExpr) {
        super(Messages._UI_WIZARD_CASE_SEARCH_HEADING);
        this.setTitle(Messages._UI_WIZARD_CASE_SEARCH_HEADING);
        this.setDescription(Messages._UI_WIZARD_CASE_SEARCH_EXPR);
        this.setPageComplete(false);
        this.domainModel = domainModel;
        this.sqlStatement = sqlStatementArg;
        this.inputSQLExpression = sqlExpr;
        this.sqlCaseSearchWhenClause = null;
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)mainPanel, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqle0300");
        GridLayout mainPanelLayout = new GridLayout();
        mainPanel.setLayout((Layout)mainPanelLayout);
        mainPanel.setLayoutData((Object)ViewUtility.createFill());
        Label infoLabel = new Label(mainPanel, 16640);
        infoLabel.setText(Messages._UI_LABEL_BUILD_WHEN_CLAUSE);
        infoLabel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.tablePanel = new Composite(mainPanel, 0);
        GridLayout tablePanelLayout = new GridLayout();
        tablePanelLayout.marginWidth = 0;
        this.tablePanel.setLayout((Layout)tablePanelLayout);
        this.tablePanel.setLayoutData((Object)ViewUtility.createFill());
        this.caseSearchTable = new CaseSearchTable(this, this.tablePanel, this.domainModel, this.sqlStatement);
        this.caseSearchTable.getTable().setLinesVisible(true);
        this.caseSearchTable.getTable().setLayoutData((Object)ViewUtility.createFill());
        Composite buttonPanel = new Composite(mainPanel, 0);
        GridLayout buttonPanelLayout = new GridLayout();
        buttonPanelLayout.marginWidth = 0;
        buttonPanelLayout.marginHeight = 0;
        buttonPanel.setLayout((Layout)buttonPanelLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        buttonPanel.setLayoutData((Object)data);
        this.addElseClauseButton = new Button(buttonPanel, 32);
        this.addElseClauseButton.setText(Messages._UI_CHECKBOX_ADD_ELSE);
        this.addElseClauseButton.addSelectionListener((SelectionListener)this);
        this.addWhenClauseButton = new Button(buttonPanel, 8);
        this.addWhenClauseButton.setText(Messages._UI_BUTTON_ADD_WHEN);
        this.addWhenClauseButton.addSelectionListener((SelectionListener)this);
        Label previewFunctionLabel = new Label(mainPanel, 16640);
        previewFunctionLabel.setText(Messages._UI_LABEL_EXPRESSION_PREVIEW);
        this.previewExpressionText = new StyledText(mainPanel, 2632);
        this.previewExpressionText.setLayoutData((Object)ViewUtility.createFill());
        this.previewExpressionText.setBackground(mainPanel.getBackground());
        this.previewExpressionText.addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent evt) {
                evt.segments = WorkbenchUtility.getSegments(evt.lineOffset, evt.lineText);
            }
        });
        mainPanel.setTabList(new Control[]{this.tablePanel, buttonPanel, this.previewExpressionText});
        this.setControl((Control)mainPanel);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent se) {
        if (se.widget == this.addElseClauseButton) {
            if (this.addElseClauseButton.getSelection()) {
                if (this.caseElseClauseCache != null) {
                    this.caseHelper.addElseClause(this.caseElseClauseCache.getValueExpr());
                } else {
                    this.caseHelper.addElseClause(null);
                }
                this.sqlCaseSearchWhenClause = (ValueExpressionCaseSearch)this.caseHelper.getSQLCaseExpression();
            } else {
                this.caseElseClauseCache = this.sqlCaseSearchWhenClause.getCaseElse();
                this.sqlCaseSearchWhenClause.setCaseElse(null);
            }
            this.caseSearchTable.setInput(this.sqlCaseSearchWhenClause);
            this.updateFinishButton();
        } else if (se.widget == this.addWhenClauseButton) {
            int row = this.caseSearchTable.getTable().getSelectionIndex();
            Object obj = null;
            if (row >= 0) {
                obj = this.caseSearchTable.getElementAt(row);
            }
            int indexList = -1;
            if (obj instanceof CaseSearchWhenContentElement) {
                indexList = ((CaseSearchWhenContentElement)obj).getClauseNumber() + 1;
            }
            if (indexList >= 0) {
                this.caseHelper.addSearchWhenClause(null, null, indexList);
                this.sqlCaseSearchWhenClause = (ValueExpressionCaseSearch)this.caseHelper.getSQLCaseExpression();
                this.caseSearchTable.setInput(this.sqlCaseSearchWhenClause);
                if (row >= 0) {
                    this.caseSearchTable.getTable().select(row);
                }
            } else {
                this.caseHelper.addSearchWhenClause(null, null);
                this.sqlCaseSearchWhenClause = (ValueExpressionCaseSearch)this.caseHelper.getSQLCaseExpression();
                this.caseSearchTable.setInput(this.sqlCaseSearchWhenClause);
            }
            this.updateFinishButton();
        }
    }

    public QueryValueExpression getSQLExpression() {
        return this.updatedSQLExpression;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.inputSQLExpression != null) {
                if (this.inputSQLExpression instanceof ValueExpressionCaseSearch) {
                    this.caseHelper = new CaseHelper();
                    this.updatedSQLExpression = this.inputSQLExpression;
                    this.sqlCaseSearchWhenClause = (ValueExpressionCaseSearch)this.updatedSQLExpression;
                    this.caseHelper.setCaseSearchObject(this.sqlCaseSearchWhenClause);
                    if (this.sqlCaseSearchWhenClause.getCaseElse() != null) {
                        this.addElseClauseButton.setSelection(true);
                    } else {
                        this.addElseClauseButton.setSelection(false);
                    }
                    this.caseElseClauseCache = this.sqlCaseSearchWhenClause.getCaseElse();
                    this.caseSearchTable.setInput(this.sqlCaseSearchWhenClause);
                }
            } else if (this.sqlCaseSearchWhenClause == null) {
                this.caseHelper = new CaseHelper();
                this.caseHelper.addSearchWhenClause(null, null);
                this.sqlCaseSearchWhenClause = (ValueExpressionCaseSearch)this.caseHelper.getSQLCaseExpression();
                this.caseElseClauseCache = null;
                this.caseSearchTable.setInput(this.sqlCaseSearchWhenClause);
            }
            this.updateFinishButton();
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void setElementToUpdate(CaseSearchWhenContentElement element) {
        this.elementToUpdate = element;
    }

    public CaseSearchWhenContentElement getElementToUpdate() {
        return this.elementToUpdate;
    }

    public void updateFinishButton() {
        this.isComplete = true;
        Iterator e = this.sqlCaseSearchWhenClause.getSearchContentList().iterator();
        ValueExpressionCaseSearchContent aSearchWhenContent = null;
        while (e.hasNext() && this.isComplete) {
            aSearchWhenContent = (ValueExpressionCaseSearchContent)e.next();
            if (aSearchWhenContent.getValueExpr() != null) continue;
            this.isComplete = false;
            break;
        }
        if (this.sqlCaseSearchWhenClause.getCaseElse() != null && this.sqlCaseSearchWhenClause.getCaseElse().getValueExpr() == null) {
            this.isComplete = false;
        }
        this.setPageComplete(this.isComplete);
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setAllPagesComplete(this.isComplete);
        } else if (this.getWizard() instanceof CaseExpressionWizard) {
            CaseExpressionWizard wiz = (CaseExpressionWizard)this.getWizard();
            wiz.setCaseOptionsPageComplete(this.isComplete);
        }
        this.updatePreviewExpressionText();
    }

    public boolean performOk() {
        this.updatedSQLExpression = this.sqlCaseSearchWhenClause;
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        } else if (this.getWizard() instanceof CaseExpressionWizard) {
            CaseExpressionWizard wiz = (CaseExpressionWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        }
        return true;
    }

    private void updatePreviewExpressionText() {
        if (this.sqlCaseSearchWhenClause != null) {
            this.previewExpressionText.setText(this.sqlCaseSearchWhenClause.getSQL().trim());
        } else {
            this.previewExpressionText.setText("");
        }
    }

    public boolean currentPage() {
        return this.isCurrentPage();
    }
}

