/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlscrapbook.actions;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.datatools.sqltools.sqlscrapbook.actions.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenScrapbookAction
extends Action
implements IHandler,
IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private transient ListenerList listenerList = null;

    public void run(IAction action) {
        ISQLEditorConnectionInfo editorConnectionInfo = SQLFileUtil.getDefaultConnectionInfo();
        String scrap = "";
        SQLEditorStorageEditorInput editorStorageEditorInput = new SQLEditorStorageEditorInput("", scrap);
        editorStorageEditorInput.setConnectionInfo(editorConnectionInfo);
        IEditorReference[] editors = this.window.getActivePage().getEditorReferences();
        int suffix = 0;
        ArrayList<String> editorNameList = new ArrayList<String>();
        int i = 0;
        while (i < editors.length) {
            editorNameList.add(editors[i].getName());
            ++i;
        }
        while (true) {
            String name;
            if (!editorNameList.contains(name = NLS.bind((String)Messages.OpenScrapbookAction_scrapbook_title, (Object)Integer.toString(suffix)))) {
                editorStorageEditorInput.setName(name);
                try {
                    this.window.getActivePage().openEditor((IEditorInput)editorStorageEditorInput, "org.eclipse.datatools.sqltools.sqlscrapbook.SQLScrapbookEditor");
                }
                catch (PartInitException e) {
                    SqlscrapbookPlugin.log(e);
                }
                break;
            }
            ++suffix;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.window = SqlscrapbookPlugin.getActiveWorkbenchWindow();
    }

    public void dispose() {
        this.listenerList = null;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)handlerListener);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part == null) {
            return null;
        }
        this.init(part.getSite().getWorkbenchWindow());
        this.run(null);
        return null;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)handlerListener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }
}

