/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection;

import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.ConnectionInfoGroup;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConnectionInfoDialog
extends Dialog
implements Listener {
    private ConnectionInfoGroup _group = null;
    private boolean _isConnected = false;
    private boolean _mustConnect = false;
    private ISQLEditorConnectionInfo _connInfo = null;

    public ConnectionInfoDialog(Shell parentShell) {
        this(parentShell, null);
    }

    public ConnectionInfoDialog(Shell parentShell, ISQLEditorConnectionInfo connInfo) {
        super(parentShell);
        this._connInfo = connInfo;
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this._connInfo;
    }

    public boolean isConnected() {
        return this._isConnected;
    }

    public void setMustConnect(boolean mustConnect) {
        this._mustConnect = mustConnect;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), "org.eclipse.datatools.sqltools.sqleditor.attaching_profile");
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this._connInfo == null || this._connInfo.getConnectionProfile() == null) {
            Label label = new Label(composite, 0);
            label.setForeground(JFaceColors.getErrorText((Display)label.getDisplay()));
        } else {
            String profileName = this._connInfo.getConnectionProfileName();
            if (this._connInfo.getConnectionProfile() == null) {
                Label label = new Label(composite, 0);
                label.setText(NLS.bind((String)Messages.SelectProfileDialog_wrongprofile, (Object)profileName));
                label.setForeground(JFaceColors.getErrorText((Display)label.getDisplay()));
            }
        }
        this._group = new ConnectionInfoGroup(composite, this, this._connInfo, true, this._mustConnect);
        this.checkOK();
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SelectProfileDialog_title);
    }

    protected void okPressed() {
        if (!this._group.canFinish()) {
            return;
        }
        this._group.finish();
        this._isConnected = this._group.isConnected();
        this._connInfo = this._group.getConnectionInfo();
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.checkOK();
    }

    public void handleEvent(Event event) {
        if (event.widget == this._group) {
            this.checkOK();
        }
    }

    private boolean checkOK() {
        boolean enabled = this._group.canFinish();
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(enabled);
        }
        return enabled;
    }
}

