/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.plan;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.plan.IPlanOption;
import org.eclipse.datatools.sqltools.plan.IPlanService;
import org.eclipse.datatools.sqltools.plan.PlanRequest;
import org.eclipse.datatools.sqltools.sqleditor.plan.GroupPlanSupportRunnable;
import org.eclipse.jface.action.Action;

public abstract class BaseExplainAction
extends Action {
    protected PlanRequest _planRequest;
    protected Connection _conn;

    public abstract DatabaseIdentifier getDatabaseIdentifier();

    public abstract String getSQLStatements();

    public abstract Runnable getPostRun();

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        String sql = this.getSQLStatements();
        DatabaseIdentifier databaseIdentifier = this.getDatabaseIdentifier();
        if (databaseIdentifier == null || sql == null) {
            return;
        }
        IPlanOption option = null;
        IPlanService planService = SQLToolsFacade.getPlanService((DatabaseIdentifier)databaseIdentifier);
        if (planService != null) {
            option = planService.getPlanOption();
        }
        String databaseDefinitionId = ProfileUtil.getDatabaseVendorDefinitionId((String)databaseIdentifier.getProfileName()).toString();
        int planType = option.getCurrentType();
        this._planRequest = this.createPlanRequest(sql, databaseDefinitionId, planType, 1);
        GroupPlanSupportRunnable thread = this.createGroupPlanSupportRunnable(this._planRequest, databaseIdentifier);
        if (this._conn != null) {
            thread.setConnection(this._conn);
        }
        thread.setUser(true);
        thread.schedule();
        try {
            thread.join();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.handleEnd(this._conn);
    }

    protected boolean canBeEnabled() {
        DatabaseIdentifier databaseIdentifier = this.getDatabaseIdentifier();
        if (databaseIdentifier == null) {
            return false;
        }
        IPlanService planService = SQLToolsFacade.getPlanService((DatabaseIdentifier)databaseIdentifier);
        return planService != null && planService.getPlanOption() != null;
    }

    protected HashMap getVariableDeclarations() {
        return null;
    }

    protected GroupPlanSupportRunnable createGroupPlanSupportRunnable(PlanRequest request, DatabaseIdentifier databaseIdentifier) {
        return new GroupPlanSupportRunnable(request, databaseIdentifier, this.getPostRun());
    }

    protected PlanRequest createPlanRequest(String sql, String databaseDefinitionId, int planType, int mode) {
        PlanRequest request = new PlanRequest(sql, databaseDefinitionId, planType, mode);
        request.setNoexec(false);
        request.setVarDecs((Map)this.getVariableDeclarations());
        return request;
    }

    public PlanRequest getPlanRequest() {
        return this._planRequest;
    }

    protected void handleEnd(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

