/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import java.util.ArrayList;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.editor.template.GenericSQLContext;
import org.eclipse.datatools.sqltools.editor.template.GenericSQLContextType;
import org.eclipse.datatools.sqltools.editor.template.SQLTemplate;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLParserCompletionEngine;
import org.eclipse.datatools.sqltools.sqleditor.internal.templates.SQLTemplateProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SQLTemplateProposalsService {
    private static final String _LINE_SELECTION = "${line_selection}";
    private static final String _WORD_SELECTION = "${word_selection}";

    public ArrayList getProposals(SQLEditor editor, int completionPosition, String word, boolean isStatementStart, Point selection) {
        ArrayList<SQLTemplateProposal> proposals = new ArrayList<SQLTemplateProposal>();
        IDocument document = editor.getSV().getDocument();
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)editor.getConnectionInfo().getDatabaseVendorDefinitionId());
        Object contextType = config != null ? config.getSQLService().getSQLContextType() : SQLEditorPlugin.getDefault().getTemplateContextTypeRegistry().getContextType("org.eclipse.datatools.sqltools.editor.template.sql.generic");
        if (!(contextType instanceof GenericSQLContextType)) {
            return proposals;
        }
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        GenericSQLContext context = contextType.createContext(document, completionPosition - word.length(), selection.y, editor.getParsingResult());
        context.setVariable("selection", selectedText);
        Region region = new Region(completionPosition, selection.y);
        Template[] templates = SQLEditorPlugin.getDefault().getTemplateStore().getTemplates();
        if (selection.y == 0) {
            for (int i = 0; i != templates.length; ++i) {
                if (!context.canEvaluate(templates[i])) continue;
                if (word.equals("")) {
                    if (!isStatementStart) continue;
                    proposals.add(new SQLTemplateProposal(editor, templates[i], (TemplateContext)context, (IRegion)region, this.getTemplateImage(templates[i]), 0));
                    continue;
                }
                if (!SQLParserCompletionEngine.startsWithIgnoreCase(templates[i].getName(), word)) continue;
                proposals.add(new SQLTemplateProposal(editor, templates[i], (TemplateContext)context, (IRegion)region, this.getTemplateImage(templates[i]), 0));
            }
        } else {
            boolean multipleLinesSelected = this.areMultipleLinesSelected((ITextViewer)editor.getSV());
            for (int i = 0; i != templates.length; ++i) {
                Template template = templates[i];
                if (!context.canEvaluate(template) || (multipleLinesSelected || template.getPattern().indexOf(_WORD_SELECTION) == -1) && (!multipleLinesSelected || template.getPattern().indexOf(_LINE_SELECTION) == -1)) continue;
                proposals.add(new SQLTemplateProposal(editor, templates[i], (TemplateContext)context, (IRegion)region, this.getTemplateImage(templates[i]), 0));
            }
        }
        return proposals;
    }

    private Image getTemplateImage(Template template) {
        SQLTemplate sqlTemplate;
        if (template instanceof SQLTemplate && (sqlTemplate = (SQLTemplate)template).getId().startsWith("intelligence.template")) {
            return SQLEditorResources.getImage("intelligent_template");
        }
        return SQLEditorResources.getImage("template_obj");
    }

    protected boolean areMultipleLinesSelected(ITextViewer viewer) {
        if (viewer == null) {
            return false;
        }
        Point s = viewer.getSelectedRange();
        if (s.y == 0) {
            return false;
        }
        try {
            IDocument document = viewer.getDocument();
            int startLine = document.getLineOfOffset(s.x);
            int endLine = document.getLineOfOffset(s.x + s.y);
            IRegion line = document.getLineInformation(startLine);
            return startLine != endLine || s.x == line.getOffset() && s.y == line.getLength();
        }
        catch (BadLocationException x) {
            return false;
        }
    }
}

