/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class SQLDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;
    protected int fPos;
    protected int fStartPos;
    protected int fEndPos;
    protected static char[] fgBrackets = new char[]{'(', ')', '[', ']', '\'', '\'', '\"', '\"'};

    public void doubleClicked(ITextViewer viewer) {
        this.fPos = viewer.getSelectedRange().x;
        if (this.fPos < 0) {
            return;
        }
        this.fText = viewer;
        if (!this.selectBracketBlock()) {
            this.selectWord();
        }
    }

    protected boolean matchBracketsAt() {
        int bracketIndex1 = fgBrackets.length;
        int bracketIndex2 = fgBrackets.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            int i;
            IDocument doc = this.fText.getDocument();
            char prevChar = doc.getChar(this.fPos - 1);
            char nextChar = doc.getChar(this.fPos);
            for (i = 0; i < fgBrackets.length; i += 2) {
                if (prevChar != fgBrackets[i]) continue;
                this.fStartPos = this.fPos - 1;
                bracketIndex1 = i;
            }
            for (i = 1; i < fgBrackets.length; i += 2) {
                if (nextChar != fgBrackets[i]) continue;
                this.fEndPos = this.fPos;
                bracketIndex2 = i;
            }
            if (this.fStartPos > -1 && bracketIndex1 < bracketIndex2) {
                this.fEndPos = this.searchForClosingBracket(this.fStartPos, prevChar, fgBrackets[bracketIndex1 + 1], doc);
                if (this.fEndPos > -1) {
                    return true;
                }
                this.fStartPos = -1;
            } else if (this.fEndPos > -1) {
                this.fStartPos = this.searchForOpenBracket(this.fEndPos, fgBrackets[bracketIndex2 - 1], nextChar, doc);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
            }
        }
        catch (BadLocationException x) {
            // empty catch block
        }
        return false;
    }

    protected boolean matchWord() {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos;
            for (pos = this.fPos; pos >= 0 && Character.isJavaIdentifierPart(c = doc.getChar(pos)); --pos) {
            }
            this.fStartPos = pos;
            int length = doc.getLength();
            for (pos = this.fPos; pos < length && Character.isJavaIdentifierPart(c = doc.getChar(pos)); ++pos) {
            }
            this.fEndPos = pos;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected int searchForClosingBracket(int startPosition, char openBracket, char closeBracket, IDocument document) throws BadLocationException {
        int closePosition;
        int stack = 1;
        int length = document.getLength();
        for (closePosition = startPosition + 1; closePosition < length && stack > 0; ++closePosition) {
            char nextChar = document.getChar(closePosition);
            if (nextChar == openBracket && nextChar != closeBracket) {
                ++stack;
                continue;
            }
            if (nextChar != closeBracket) continue;
            --stack;
        }
        if (stack == 0) {
            return closePosition - 1;
        }
        return -1;
    }

    protected int searchForOpenBracket(int startPosition, char openBracket, char closeBracket, IDocument document) throws BadLocationException {
        int openPos;
        int stack = 1;
        for (openPos = startPosition - 1; openPos >= 0 && stack > 0; --openPos) {
            char nextChar = document.getChar(openPos);
            if (nextChar == closeBracket && nextChar != openBracket) {
                ++stack;
                continue;
            }
            if (nextChar != openBracket) continue;
            --stack;
        }
        if (stack == 0) {
            return openPos + 1;
        }
        return -1;
    }

    protected boolean selectBracketBlock() {
        if (this.matchBracketsAt()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos - this.fStartPos - 1);
            }
            return true;
        }
        return false;
    }

    protected void selectWord() {
        if (this.matchWord()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos - this.fStartPos - 1);
            }
        }
    }
}

