/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.editor;

import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLEditorOutlineContentProvider;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLSegment;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class SQLEditorContentOutlinePage
extends ContentOutlinePage {
    protected Object fInput;
    protected IDocumentProvider fDocumentProvider;
    protected SQLEditor fSQLEditor;

    public SQLEditorContentOutlinePage(IDocumentProvider provider, SQLEditor sqlEditor) {
        this.fDocumentProvider = provider;
        this.fSQLEditor = sqlEditor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new SQLEditorOutlineContentProvider(this));
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
    }

    public IDocumentProvider getDocumentProvider() {
        return this.fDocumentProvider;
    }

    public Object getInput() {
        return this.fInput;
    }

    public SQLEditor getSQLEditor() {
        return this.fSQLEditor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.fSQLEditor.resetHighlightRange();
        } else {
            SQLSegment segment = (SQLSegment)((IStructuredSelection)selection).getFirstElement();
            int start = segment.getPosition().getOffset();
            int length = segment.getPosition().getLength();
            try {
                this.fSQLEditor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException x) {
                this.fSQLEditor.resetHighlightRange();
            }
        }
    }

    public void setDocumentProvider(IDocumentProvider docProvider) {
        this.fDocumentProvider = docProvider;
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    public void setSQLEditor(SQLEditor sqlEditor) {
        this.fSQLEditor = sqlEditor;
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }
}

