/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DatabaseHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLBuilderDBProposal;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLDBProposal;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class SQLBuilderDBProposalsService {
    protected static int PROPOSAL_TYPE_INVALID = -1;
    protected static int PROPOSAL_TYPE_TABLES = 1;
    protected static int PROPOSAL_TYPE_COLUMNS = 2;
    private ISQLEditorConnectionInfo fConnInfo;
    private List fDBProposalList;
    private String fImpliedSchemaName;
    private Comparator fComparator;

    public SQLBuilderDBProposalsService(ISQLEditorConnectionInfo connInfo) {
        this(connInfo, null);
    }

    public SQLBuilderDBProposalsService(ISQLEditorConnectionInfo connInfo, String schemaName) {
        this.fConnInfo = connInfo;
        this.fImpliedSchemaName = schemaName;
        this.fDBProposalList = new ArrayList();
        this.fComparator = new SQLDBProposalComparator();
    }

    protected int determineProposalType(List tokenList) {
        int proposalType = PROPOSAL_TYPE_INVALID;
        if (tokenList.size() == 1) {
            proposalType = this.fImpliedSchemaName == null ? PROPOSAL_TYPE_TABLES : PROPOSAL_TYPE_TABLES | PROPOSAL_TYPE_COLUMNS;
        } else if (tokenList.size() == 2) {
            proposalType = PROPOSAL_TYPE_COLUMNS;
        }
        return proposalType;
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this.fConnInfo;
    }

    protected Schema getSchema(Database database, String schemaName) {
        List schemaList = DatabaseHelper.getSchemaList(database);
        Schema schema = null;
        int i = 0;
        while (i < schemaList.size()) {
            Schema thisSchema = (Schema)schemaList.get(i);
            if (thisSchema.getName().equalsIgnoreCase(schemaName)) {
                schema = thisSchema;
                break;
            }
            ++i;
        }
        return schema;
    }

    public List getDBProposals() {
        return this.fDBProposalList;
    }

    public String getSchemaName() {
        return this.fImpliedSchemaName;
    }

    protected Comparator getSQLDBProposalComparator() {
        return this.fComparator;
    }

    protected void loadSchemas() {
        this.loadSchemas(true);
    }

    protected void loadSchemas(boolean clear) {
        List dbProposalList = this.getDBProposals();
        if (clear) {
            dbProposalList.clear();
        }
        ArrayList<SQLBuilderDBProposal> schemaProposalList = new ArrayList<SQLBuilderDBProposal>();
        ISQLEditorConnectionInfo conn = this.getConnectionInfo();
        Database db = conn.getDatabase();
        List schemaList = DatabaseHelper.getSchemaList(db);
        Iterator schemaListIter = schemaList.iterator();
        while (schemaListIter.hasNext()) {
            Schema schema = (Schema)schemaListIter.next();
            schemaProposalList.add(new SQLBuilderDBProposal((EObject)schema));
        }
        Comparator c = this.getSQLDBProposalComparator();
        Collections.sort(schemaProposalList, c);
        dbProposalList.addAll(schemaProposalList);
    }

    protected void loadColumns(Table table) {
        this.loadColumns(table, true);
    }

    protected void loadColumns(Table table, boolean clear) {
        if (table != null) {
            List dbProposalList = this.getDBProposals();
            if (clear) {
                dbProposalList.clear();
            }
            EList columns = table.getColumns();
            int j = 0;
            while (j < columns.size()) {
                Column column = (Column)columns.get(j);
                dbProposalList.add(new SQLBuilderDBProposal((EObject)column));
                ++j;
            }
        }
    }

    protected void loadTables(Schema schema) {
        this.loadTables(schema, true);
    }

    protected void loadTables(Schema schema, boolean clear) {
        if (schema != null) {
            List dbProposalList = this.getDBProposals();
            if (clear) {
                dbProposalList.clear();
            }
            EList tables = schema.getTables();
            int i = 0;
            while (i < tables.size()) {
                Table table = (Table)tables.get(i);
                dbProposalList.add(new SQLBuilderDBProposal((EObject)table));
                ++i;
            }
        }
    }

    public boolean populate(List tokenList) {
        boolean populated = false;
        if (tokenList != null && tokenList.size() > 0) {
            this.loadDBProposals(tokenList);
        } else {
            this.loadSchemas();
        }
        List dbProposalsList = this.getDBProposals();
        if (dbProposalsList.size() > 0) {
            populated = true;
        }
        return populated;
    }

    protected void loadDBProposals(List tokenList) {
        Database db = this.getConnectionInfo().getDatabase();
        this.getDBProposals().clear();
        if (db != null) {
            int proposalsType = this.determineProposalType(tokenList);
            Schema schema = this.getSchema(db, (String)tokenList.get(0));
            if ((proposalsType & PROPOSAL_TYPE_TABLES) == PROPOSAL_TYPE_TABLES) {
                this.loadTables(schema, false);
            }
            if ((proposalsType & PROPOSAL_TYPE_COLUMNS) == PROPOSAL_TYPE_COLUMNS) {
                String tableToken = null;
                if (tokenList.size() == 1 && this.getSchemaName() != null) {
                    schema = this.getSchema(db, this.getSchemaName());
                    tableToken = (String)tokenList.get(0);
                } else if (tokenList.size() >= 0) {
                    tableToken = (String)tokenList.get(1);
                }
                if (tableToken != null && tableToken.trim().length() > 0) {
                    Table table = null;
                    EList tables = schema.getTables();
                    int i = 0;
                    while (i < tables.size()) {
                        table = (Table)tables.get(i);
                        if (table.getName().equalsIgnoreCase(tableToken)) {
                            this.loadColumns(table, false);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void setSchemaName(String schemaName) {
        this.fImpliedSchemaName = schemaName != null && schemaName.trim().length() > 0 ? schemaName : null;
    }

    private static class SQLDBProposalComparator
    implements Comparator {
        private SQLDBProposalComparator() {
        }

        public int compare(Object o1, Object o2) {
            SQLDBProposal c1 = (SQLDBProposal)o1;
            SQLDBProposal c2 = (SQLDBProposal)o2;
            return c1.getName().compareTo(c2.getName());
        }
    }
}

