/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.dialogs;

import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MultilineInputDialog
extends Dialog {
    private String m_title;
    private String m_columnName;
    private String m_input;
    private Text m_text;
    private static final int NUM_LINES = 20;

    public MultilineInputDialog(Shell parentShell, String title, String columnName) {
        super(parentShell);
        this.m_title = title;
        this.m_columnName = columnName;
        this.setShellStyle(133232);
        this.setBlockOnOpen(true);
    }

    public void setText(String input) {
        this.m_input = input;
    }

    public String getText() {
        return this.m_input;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String sTitle = "";
        if (this.m_title != null && this.m_title.length() > 0) {
            sTitle = this.m_title;
        }
        if (this.m_columnName != null && this.m_columnName.length() > 0) {
            sTitle = sTitle.length() > 0 ? String.valueOf(sTitle) + " - " + this.m_columnName : this.m_columnName;
        }
        shell.setText(sTitle);
    }

    protected void okPressed() {
        this.m_input = this.m_text.getText();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = ViewUtility.createComposite(parent, 1, true);
        this.m_text = ViewUtility.createWrappedMultiTextField(parent, -1, 20, true);
        this.m_text.setText(this.m_input);
        return composite;
    }
}

