/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilder;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.ChangeStatementTypeAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.ExecuteAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.OmitCurrentSchemaAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.RevertToDefaultAction;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.RevertToPreviousAction;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLSourceViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class SQLBuilderActionBarContributor
extends TextEditorActionContributor {
    public static final String CONTENT_ASSIST_ACTION_ID = "ContentAssistProposal";
    public static final String CONTENT_ASSIST_ACTION_PREFIX = "ContentAssistProposal.";
    public static final String CONTENT_TIP_ACTION_ID = "ContentTip";
    public static final String CONTENT_TIP_ACTION_PREFIX = "ContentTip.";
    public static final String RUN_SQL_ACTION_ID = "RunSQLAction";
    protected static final String RUN_SQL_ACTION_ICON_PATH = "icons/executesql.gif";
    public static final String REVERT_TO_PREVIOUS_ACTION_ID = "RevertToPreviousAction";
    public static final String REVERT_TO_DEFAULT_ACTION_ID = "RevertToDefaultAction";
    public static final String CHANGE_STATEMENT_TYPE_ACTION_ID = "ChangeStatementType";
    public static final String OMIT_CURRENT_SCHEMA_ACTION_ID = "OmitCurrentSchema";
    protected static final String RUN_MENU_ID = "org.eclipse.ui.run";
    protected static final String RUN_MENU_EXTERNAL_TOOLS_GROUP_ID = "ExternalToolsGroup";
    protected static final String RUN_MENU_RUN_SQL_ACTION_ID = "RunMenuRunSQLAction";
    protected static final String SQL_MENU_ID = "datatools.sqlbuilder.SQLMenu.ID";
    protected static final String SQL_MENU_RUN_SQL_ACTION_ID = "SQLMenuRunSQLAction";
    protected static final String SQL_MENU_REVERT_TO_PREVIOUS_ACTION_ID = "SQLMenuRevertToPreviousAction";
    protected static final String SQL_MENU_REVERT_TO_DEFAULT_ACTION_ID = "SQLMenuRevertToDefaultAction";
    protected static final String SQL_MENU_CHANGE_STATEMENT_TYPE_ACTION_ID = "SQLMenuChangeStatementTypeAction";
    protected static final String SQL_MENU_OMIT_CURRENT_SCHEMA_ACTION_ID = "SQLMenuOmitCurrentSchemaAction";
    protected static final String TOOLBAR_RUN_SQL_ACTION_ID = "ToolBarRunSQLAction";
    protected RetargetTextEditorAction fEditMenuContentAssistAction;
    protected RetargetTextEditorAction fEditMenuContentTipAction;
    protected RetargetAction fRunMenuRunSQLAction;
    protected RetargetAction fSQLMenuRunSQLAction;
    protected RetargetAction fToolBarRunSQLAction;
    protected RetargetAction fSQLMenuRevertToPreviousAction;
    protected RetargetAction fSQLMenuRevertToDefaultAction;
    protected RetargetAction fSQLMenuChangeStatementTypeAction;
    protected RetargetAction fSQLMenuOmitCurrentSchemaAction;
    private ExecuteAction fRunSQLAction;
    private RevertToPreviousAction fRevertToPreviousAction;
    private RevertToDefaultAction fRevertToDefaultAction;
    private ChangeStatementTypeAction fChangeStatementTypeAction;
    private OmitCurrentSchemaAction fOmitCurrentSchemaAction;
    private Map fActions = new HashMap(10);

    public SQLBuilderActionBarContributor() {
        ResourceBundle resourceBundle = SQLBuilderPlugin.getPlugin().getResourceBundle();
        this.fEditMenuContentAssistAction = new RetargetTextEditorAction(resourceBundle, CONTENT_ASSIST_ACTION_PREFIX);
        this.fEditMenuContentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fEditMenuContentTipAction = new RetargetTextEditorAction(resourceBundle, CONTENT_TIP_ACTION_PREFIX);
        this.fEditMenuContentTipAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        ImageDescriptor runSQLImage = ImageDescriptor.createFromFile(((Object)((Object)SQLBuilderPlugin.getPlugin())).getClass(), (String)RUN_SQL_ACTION_ICON_PATH);
        this.fRunMenuRunSQLAction = new RetargetAction(RUN_MENU_RUN_SQL_ACTION_ID, Messages.datatools_sqlbuilder_RunSQLAction_label);
        this.fRunMenuRunSQLAction.setImageDescriptor(runSQLImage);
        this.fSQLMenuRunSQLAction = new RetargetAction(SQL_MENU_RUN_SQL_ACTION_ID, Messages.datatools_sqlbuilder_RunSQLAction_label);
        this.fSQLMenuRunSQLAction.setImageDescriptor(runSQLImage);
        this.fToolBarRunSQLAction = new RetargetAction(TOOLBAR_RUN_SQL_ACTION_ID, Messages.datatools_sqlbuilder_RunSQLAction_label);
        this.fToolBarRunSQLAction.setToolTipText(Messages.datatools_sqlbuilder_RunSQLAction_tooltip);
        this.fToolBarRunSQLAction.setImageDescriptor(runSQLImage);
        this.fSQLMenuRevertToPreviousAction = new RetargetAction(SQL_MENU_REVERT_TO_PREVIOUS_ACTION_ID, Messages.datatools_sqlbuilder_RevertToPreviousAction_label);
        this.fSQLMenuRevertToDefaultAction = new RetargetAction(SQL_MENU_REVERT_TO_DEFAULT_ACTION_ID, Messages.datatools_sqlbuilder_RevertToDefaultAction_label);
        this.fSQLMenuChangeStatementTypeAction = new RetargetAction(SQL_MENU_CHANGE_STATEMENT_TYPE_ACTION_ID, Messages.datatools_sqlbuilder_ChangeStatementTypeAction_label);
        this.fSQLMenuOmitCurrentSchemaAction = new RetargetAction(SQL_MENU_OMIT_CURRENT_SCHEMA_ACTION_ID, Messages.datatools_sqlbuilder_OmitCurrentSchemaAction_label);
        this.fRunSQLAction = new ExecuteAction();
        this.fRunSQLAction.setId(RUN_SQL_ACTION_ID);
        this.setAction(RUN_SQL_ACTION_ID, (IAction)this.fRunSQLAction);
        this.fRevertToPreviousAction = new RevertToPreviousAction();
        this.fRevertToPreviousAction.setId(REVERT_TO_PREVIOUS_ACTION_ID);
        this.fRevertToPreviousAction.setShell(Display.getCurrent().getActiveShell());
        this.setAction(REVERT_TO_PREVIOUS_ACTION_ID, (IAction)this.fRevertToPreviousAction);
        this.fRevertToDefaultAction = new RevertToDefaultAction();
        this.fRevertToDefaultAction.setId(REVERT_TO_DEFAULT_ACTION_ID);
        this.setAction(REVERT_TO_DEFAULT_ACTION_ID, (IAction)this.fRevertToDefaultAction);
        this.fChangeStatementTypeAction = new ChangeStatementTypeAction();
        this.fChangeStatementTypeAction.setId(CHANGE_STATEMENT_TYPE_ACTION_ID);
        this.fChangeStatementTypeAction.setShell(Display.getCurrent().getActiveShell());
        this.setAction(CHANGE_STATEMENT_TYPE_ACTION_ID, (IAction)this.fChangeStatementTypeAction);
        this.fOmitCurrentSchemaAction = new OmitCurrentSchemaAction();
        this.fOmitCurrentSchemaAction.setId(OMIT_CURRENT_SCHEMA_ACTION_ID);
        this.fOmitCurrentSchemaAction.setShell(Display.getCurrent().getActiveShell());
        this.setAction(OMIT_CURRENT_SCHEMA_ACTION_ID, (IAction)this.fOmitCurrentSchemaAction);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        IMenuManager runMenu = menuManager.findMenuUsingPath(RUN_MENU_ID);
        if (runMenu != null) {
            IContributionItem externalToolsGroupSeperator = runMenu.findUsingPath(RUN_MENU_EXTERNAL_TOOLS_GROUP_ID);
            if (externalToolsGroupSeperator != null) {
                runMenu.insertBefore(RUN_MENU_EXTERNAL_TOOLS_GROUP_ID, (IContributionItem)new Separator());
                runMenu.insertBefore(RUN_MENU_EXTERNAL_TOOLS_GROUP_ID, (IAction)this.fRunMenuRunSQLAction);
            } else {
                runMenu.add((IContributionItem)new Separator());
                runMenu.add((IAction)this.fRunMenuRunSQLAction);
            }
        }
        MenuManager sqlMenu = new MenuManager(Messages._UI_MENU_SQLBUILDER, SQL_MENU_ID);
        menuManager.insertAfter("additions", (IContributionItem)sqlMenu);
        sqlMenu.add((IAction)this.fSQLMenuRunSQLAction);
        sqlMenu.add((IAction)this.fSQLMenuRevertToPreviousAction);
        sqlMenu.add((IAction)this.fSQLMenuRevertToDefaultAction);
        sqlMenu.add((IAction)this.fSQLMenuChangeStatementTypeAction);
        sqlMenu.add((IAction)this.fSQLMenuOmitCurrentSchemaAction);
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        super.contributeToToolBar(tbm);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fToolBarRunSQLAction);
    }

    public void dispose() {
        IWorkbenchPage workbenchPage = this.getPage();
        if (workbenchPage != null) {
            workbenchPage.removePartListener((IPartListener)this.fRunMenuRunSQLAction);
            workbenchPage.removePartListener((IPartListener)this.fSQLMenuRunSQLAction);
            workbenchPage.removePartListener((IPartListener)this.fSQLMenuRunSQLAction);
            workbenchPage.removePartListener((IPartListener)this.fSQLMenuRevertToPreviousAction);
            workbenchPage.removePartListener((IPartListener)this.fSQLMenuRevertToDefaultAction);
            workbenchPage.removePartListener((IPartListener)this.fSQLMenuChangeStatementTypeAction);
            workbenchPage.removePartListener((IPartListener)this.fSQLMenuOmitCurrentSchemaAction);
        }
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        IAction action = (IAction)this.fActions.get(actionID);
        return action;
    }

    public void init(IActionBars bars) {
        super.init(bars);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        bars.setGlobalActionHandler(RUN_MENU_RUN_SQL_ACTION_ID, (IAction)this.fRunSQLAction);
        bars.setGlobalActionHandler(SQL_MENU_RUN_SQL_ACTION_ID, (IAction)this.fRunSQLAction);
        bars.setGlobalActionHandler(TOOLBAR_RUN_SQL_ACTION_ID, (IAction)this.fRunSQLAction);
        bars.setGlobalActionHandler(SQL_MENU_REVERT_TO_PREVIOUS_ACTION_ID, (IAction)this.fRevertToPreviousAction);
        bars.setGlobalActionHandler(SQL_MENU_REVERT_TO_DEFAULT_ACTION_ID, (IAction)this.fRevertToDefaultAction);
        bars.setGlobalActionHandler(SQL_MENU_CHANGE_STATEMENT_TYPE_ACTION_ID, (IAction)this.fChangeStatementTypeAction);
        bars.setGlobalActionHandler(SQL_MENU_OMIT_CURRENT_SCHEMA_ACTION_ID, (IAction)this.fOmitCurrentSchemaAction);
        page.addPartListener((IPartListener)this.fRunMenuRunSQLAction);
        page.addPartListener((IPartListener)this.fSQLMenuRunSQLAction);
        page.addPartListener((IPartListener)this.fToolBarRunSQLAction);
        page.addPartListener((IPartListener)this.fSQLMenuRevertToPreviousAction);
        page.addPartListener((IPartListener)this.fSQLMenuRevertToDefaultAction);
        page.addPartListener((IPartListener)this.fSQLMenuChangeStatementTypeAction);
        page.addPartListener((IPartListener)this.fSQLMenuOmitCurrentSchemaAction);
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart != null) {
            this.fRunMenuRunSQLAction.partActivated(activePart);
            this.fSQLMenuRunSQLAction.partActivated(activePart);
            this.fToolBarRunSQLAction.partActivated(activePart);
            this.fSQLMenuRevertToPreviousAction.partActivated(activePart);
            this.fSQLMenuRevertToDefaultAction.partActivated(activePart);
            this.fSQLMenuChangeStatementTypeAction.partActivated(activePart);
            this.fSQLMenuOmitCurrentSchemaAction.partActivated(activePart);
        }
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            action = (IAction)this.fActions.remove(actionID);
        } else {
            this.fActions.put(actionID, action);
        }
    }

    public void setActiveEditor(IEditorPart activeEditor) {
        super.setActiveEditor(activeEditor);
        if (activeEditor instanceof SQLBuilderEditor) {
            SQLBuilderEditor sqlBuilder = (SQLBuilderEditor)activeEditor;
            sqlBuilder.setActionBarContributor(this);
            this.setActiveSQLBuilder(sqlBuilder.getSQLBuilder());
            IActionBars bars = this.getActionBars();
            if (bars != null) {
                bars.updateActionBars();
            }
        }
    }

    public void setActiveSQLBuilder(SQLBuilder sqlBuilder) {
        SQLSourceViewer sourceViewer = sqlBuilder.getSourceViewer();
        if (sourceViewer != null) {
            IAction contentAssistAction = sourceViewer.getAction(CONTENT_ASSIST_ACTION_ID);
            this.fEditMenuContentAssistAction.setAction(contentAssistAction);
            IAction contentTipAction = sourceViewer.getAction(CONTENT_TIP_ACTION_ID);
            this.fEditMenuContentTipAction.setAction(contentTipAction);
        }
        this.fRunSQLAction.setSQLBuilder(sqlBuilder);
        this.fRevertToPreviousAction.setSQLBuilder(sqlBuilder);
        this.fRevertToDefaultAction.setSQLBuilder(sqlBuilder);
        this.fChangeStatementTypeAction.setSQLBuilder(sqlBuilder);
        this.fOmitCurrentSchemaAction.setSQLBuilder(sqlBuilder);
        SQLDomainModel domainModel = sqlBuilder.getDomainModel();
        if (domainModel != null) {
            boolean enableRevert = !domainModel.isProper();
            this.fRevertToPreviousAction.setEnabled(enableRevert);
            this.fRevertToDefaultAction.setEnabled(enableRevert);
            boolean enableOmitCurrentSchema = domainModel.getDatabaseDefinition() != null ? domainModel.getDatabaseDefinition().supportsSchema() : false;
            this.fOmitCurrentSchemaAction.setEnabled(enableOmitCurrentSchema);
        }
    }
}

