/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorPageDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.ILogger;
import org.eclipse.jface.preference.IPreferenceStore;

public class EditorPageDescriptor
implements IEditorPageDescriptor {
    private String _contextHelpId;
    private IEditorDescriptor _editor;
    private String _editorId;
    private ILogger _logger = SOEUIPlugin.getLogger(null);
    private boolean _mustBeShown;
    private ISchemaObjectEditorPage _page;
    private IConfigurationElement _pageClassElement;
    private String _pageExtensionId;
    private String _pageId;
    private String _pageName;
    private boolean _showByDefault;
    private String _objectClassType;

    public EditorPageDescriptor(String editorId, String pageId, String pageName, boolean beShown, boolean showByDefault, ISchemaObjectEditorPage page, IEditorDescriptor editor, IConfigurationElement pageClassElement, String pageExtensionId, String contextHelpId, String objectClassType) {
        this._editorId = editorId;
        this._pageId = pageId;
        this._pageName = pageName;
        this._mustBeShown = beShown;
        this._showByDefault = showByDefault;
        this._page = page;
        this._editor = editor;
        this._pageClassElement = pageClassElement;
        this._pageExtensionId = pageExtensionId;
        this._contextHelpId = contextHelpId;
        this._objectClassType = objectClassType;
    }

    public String getContextHelpId() {
        return this._contextHelpId;
    }

    public IEditorDescriptor getEditor() {
        return this._editor;
    }

    public String getEditorId() {
        return this._editorId;
    }

    public ISchemaObjectEditorPage getPageClass() {
        ISchemaObjectEditorPage page = this._page;
        try {
            this._page = (ISchemaObjectEditorPage)this._pageClassElement.createExecutableExtension("Class");
        }
        catch (Exception e) {
            this._logger.error("EditorPage_error_create_class", (Throwable)e);
        }
        return page;
    }

    public String getPageExtensionId() {
        return this._pageExtensionId;
    }

    public String getPageId() {
        return this._pageId;
    }

    public String getPageName() {
        return this._pageName;
    }

    public boolean isRequired() {
        return this._mustBeShown;
    }

    public boolean isSelectedToShow() {
        if (this._mustBeShown || !this._editor.isVisibilityConfigurable()) {
            return true;
        }
        IPreferenceStore store = SOEUIPlugin.getDefault().getPreferenceStore();
        String preferenceName = "SchemaObjectEditor.visiability" + this.getEditorId() + this.getPageId();
        return store.getBoolean(preferenceName);
    }

    public boolean isVisibleByDefault() {
        return this._showByDefault;
    }

    public void setPageExtensionId(String pageExtensionId) {
        this._pageExtensionId = pageExtensionId;
    }

    public String getObjectClassType() {
        return this._objectClassType;
    }

    public boolean isVisible() {
        IPreferenceStore store = SOEUIPlugin.getDefault().getPreferenceStore();
        String key = "SchemaObjectEditor.visiability" + this.getEditorId() + this.getPageId();
        return store.getBoolean(key);
    }
}

