/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.launching.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class SaveRoutineStatusHandler
implements IStatusHandler {
    Object[] fSaves = null;
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$IConnectionProfile;

    public Object handleStatus(IStatus status, Object source) throws CoreException {
        IConnectionProfile profile = null;
        if (source != null) {
            if (source instanceof ProcIdentifier) {
                try {
                    profile = ProfileUtil.getProfile((String)((ProcIdentifier)source).getProfileName());
                }
                catch (NoSuchProfileException e) {}
            } else if (source instanceof IConnectionProfile) {
                profile = (IConnectionProfile)source;
            }
        }
        if (profile != null) {
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            final String save = store.getString(IInternalDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH);
            final int[] result = new int[]{0};
            final IConnectionProfile p = profile;
            SQLEditorPlugin.getStandardDisplay().syncExec(new Runnable(){

                public void run() {
                    result[0] = SaveRoutineStatusHandler.this.showSaveDialog(p, !save.equals("never"), save.equals("prompt"));
                }
            });
            if (result[0] == 0) {
                this.doSave();
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        boolean cancel = DebugUIPlugin.preLaunchSave();
        return cancel;
    }

    protected IEditorPart[] getScopedDirtyEditors(IConnectionProfile targetProfile) {
        ArrayList<IEditorPart> dirtyparts = new ArrayList<IEditorPart>();
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        for (int l = 0; l < windows.length; ++l) {
            IWorkbenchPage[] pages = windows[l].getPages();
            for (int i = 0; i < pages.length; ++i) {
                IEditorPart[] eparts = pages[i].getDirtyEditors();
                for (int j = 0; j < eparts.length; ++j) {
                    IConnectionProfile profile = (IConnectionProfile)eparts[j].getEditorInput().getAdapter(class$org$eclipse$datatools$connectivity$IConnectionProfile == null ? SaveRoutineStatusHandler.class$("org.eclipse.datatools.connectivity.IConnectionProfile") : class$org$eclipse$datatools$connectivity$IConnectionProfile);
                    if (profile == null || !(targetProfile.equals(profile) & !dirtyparts.contains(eparts[j]))) continue;
                    dirtyparts.add(eparts[j]);
                }
            }
        }
        return dirtyparts.toArray(new IEditorPart[dirtyparts.size()]);
    }

    protected void doSave() {
        if (this.fSaves != null) {
            for (int i = 0; i < this.fSaves.length; ++i) {
                final SaveProgressMonitor monitor = new SaveProgressMonitor();
                final IEditorPart part = (IEditorPart)this.fSaves[i];
                SQLEditorPlugin.getStandardDisplay().syncExec(new Runnable(){

                    public void run() {
                        part.doSave((IProgressMonitor)monitor);
                    }
                });
                while (!monitor.isDone() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    protected int showSaveDialog(IConnectionProfile profile, boolean save, boolean prompt) {
        if (save) {
            Object[] editors = this.getScopedDirtyEditors(profile);
            if (prompt && editors.length > 0) {
                int[] result = new int[]{0};
                ScopedResourcesSelectionDialog lsd = new ScopedResourcesSelectionDialog(DebugUIPlugin.getShell(), new AdaptableList((IAdaptable[])editors), (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), LaunchConfigurationsMessages.SaveScopeResourcesHandler_2);
                lsd.setInitialSelections(editors);
                lsd.setTitle(LaunchConfigurationsMessages.SaveScopeResourcesHandler_3);
                result[0] = lsd.open();
                if (result[0] == 1) {
                    return 1;
                }
                this.fSaves = lsd.getResult();
            } else {
                this.fSaves = editors;
            }
        }
        return 0;
    }

    class SaveProgressMonitor
    extends NullProgressMonitor {
        private boolean isDone = false;

        SaveProgressMonitor() {
        }

        public void done() {
            super.done();
            this.isDone = true;
        }

        public boolean isDone() {
            return this.isDone;
        }
    }

    class ScopedResourcesSelectionDialog
    extends ListSelectionDialog {
        private final String SETTINGS_ID;
        private final String SELECT_RESOURCES_TO_SAVE_DIALOG;
        Button fSavePref;

        public ScopedResourcesSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
            super(parentShell, input, contentProvider, labelProvider, message);
            this.SETTINGS_ID = IDebugUIConstants.PLUGIN_ID + ".SCOPED_SAVE_SELECTION_DIALOG";
            this.SELECT_RESOURCES_TO_SAVE_DIALOG = IDebugUIConstants.PLUGIN_ID + "." + "select_resources_to_save_dialog";
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ctrl = (Composite)super.createDialogArea(parent);
            this.fSavePref = new Button(ctrl, 32);
            this.fSavePref.setText(LaunchConfigurationsMessages.SaveScopeResourcesHandler_1);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ctrl, this.SELECT_RESOURCES_TO_SAVE_DIALOG);
            return ctrl;
        }

        protected void okPressed() {
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            String val = this.fSavePref.getSelection() ? "always" : "prompt";
            store.setValue(IInternalDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH, val);
            super.okPressed();
        }

        protected IDialogSettings getDialogBoundsSettings() {
            IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(this.SETTINGS_ID);
            if (section == null) {
                section = settings.addNewSection(this.SETTINGS_ID);
            }
            return section;
        }
    }
}

