/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.launching;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.LaunchUI;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.Messages;
import org.eclipse.datatools.sqltools.routineeditor.util.RoutineUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SPLaunchShortcut
implements ILaunchShortcut {
    public static ILaunchConfiguration getLaunchConfiguration(ProcIdentifier proc, String mode) throws CoreException, SQLException, NoSuchProfileException {
        ILaunchConfigurationType type = LaunchHelper.getLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidates = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            candidates = new ArrayList<ILaunchConfiguration>(configs.length);
            for (int i = 0; i < configs.length; ++i) {
                if (!SPLaunchShortcut.isSameProc(proc, configs[i])) continue;
                candidates.add(configs[i]);
            }
        }
        catch (CoreException ex) {
            RoutineEditorActivator.getDefault().log(ex);
        }
        int candidateSize = candidates.size();
        if (candidateSize == 0) {
            return SPLaunchShortcut.createConfiguration(proc, mode);
        }
        if (candidateSize == 1) {
            return SPLaunchShortcut.modifyConfiguration(proc, (ILaunchConfiguration)candidates.get(0));
        }
        ILaunchConfiguration configuration = SPLaunchShortcut.chooseConfiguration(candidates);
        if (configuration != null) {
            return SPLaunchShortcut.modifyConfiguration(proc, configuration);
        }
        return null;
    }

    private static ILaunchConfiguration chooseConfiguration(List candidates) {
        return (ILaunchConfiguration)candidates.get(0);
    }

    private static ILaunchConfiguration modifyConfiguration(ProcIdentifier proc, ILaunchConfiguration configuration) throws CoreException, SQLException, NoSuchProfileException {
        boolean iscopy = configuration.isWorkingCopy();
        boolean quoted_id = LaunchHelper.readQuotedIDConfig(configuration, proc);
        String sql = "";
        if (proc.getType() == 0 || proc.getType() == 1) {
            ParameterDescriptor[] pds = LaunchUI.getParameterDescriptors(proc);
            List valueList = LaunchHelper.readParameterList(configuration);
            List newValues = LaunchUI.configParameter(SPLaunchShortcut.getShell(), pds, valueList, false, configuration);
            if (newValues != null) {
                valueList = newValues;
                ILaunchConfigurationWorkingCopy copy = iscopy ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
                sql = RoutineUtil.constructSPUDFString(proc, LaunchHelper.readParameterList(configuration), LaunchUI.getParameterDescriptors(proc), quoted_id);
                LaunchHelper.saveSPUDF(copy, proc, valueList, sql);
                if (iscopy) {
                    return copy;
                }
                return copy.doSave();
            }
            return null;
        }
        if (proc.getType() == 2) {
            String[] pNames = new String[]{};
            Map eventTriggerParams = LaunchHelper.readEventParameter(configuration);
            if (LaunchUI.configEventParameters(SPLaunchShortcut.getShell(), pNames, eventTriggerParams, proc)) {
                ILaunchConfigurationWorkingCopy copy = iscopy ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
                sql = RoutineUtil.constructTriggerEventString(proc, LaunchHelper.readEventParameter(configuration), quoted_id);
                LaunchHelper.saveEvent(copy, proc, eventTriggerParams, sql);
                if (iscopy) {
                    return copy;
                }
                return copy.doSave();
            }
            return null;
        }
        return configuration;
    }

    private static ILaunchConfiguration createConfiguration(ProcIdentifier proc, String mode) throws CoreException, SQLException, NoSuchProfileException {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = LaunchHelper.getLaunchConfigType();
            wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(proc.getProcName()));
        }
        catch (CoreException exception) {
            RoutineEditorActivator.getDefault().log(exception);
            return null;
        }
        LaunchHelper.initializeConfiguration(wc, proc);
        if (proc.getType() == 2 || proc.getType() == 0 || proc.getType() == 1) {
            if (SPLaunchShortcut.modifyConfiguration(proc, (ILaunchConfiguration)wc) != null) {
                try {
                    return wc.doSave();
                }
                catch (CoreException exception) {
                    RoutineEditorActivator.getDefault().log(exception);
                    return null;
                }
            }
            return null;
        }
        config = wc.doSave();
        ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
        String groupId = group == null ? "" : group.getIdentifier();
        DebugUITools.openLaunchConfigurationDialog((Shell)SPLaunchShortcut.getShell(), (ILaunchConfiguration)config, (String)groupId, null);
        return null;
    }

    private static boolean isSameProc(ProcIdentifier proc, ILaunchConfiguration configuration) {
        try {
            if (!LaunchHelper.isAdHocSQL(configuration)) {
                return proc.equals(LaunchHelper.readProcIdentifier(configuration));
            }
            return false;
        }
        catch (CoreException ex) {
            return false;
        }
    }

    public static void launch(ProcIdentifier proc, String mode) throws CoreException, SQLException, NoSuchProfileException {
        ILaunchConfiguration config = SPLaunchShortcut.getLaunchConfiguration(proc, mode);
        if (config == null) {
            return;
        }
        if (proc.getType() == 3) {
            ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
            String groupId = group == null ? "" : group.getIdentifier();
            DebugUITools.openLaunchConfigurationDialog((Shell)SPLaunchShortcut.getShell(), (ILaunchConfiguration)config, (String)groupId, null);
            return;
        }
        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            ProcIdentifier proc = null;
            if (first instanceof ProcIdentifier) {
                proc = (ProcIdentifier)first;
            } else if (first instanceof Routine || first instanceof Trigger) {
                proc = SQLDevToolsUtil.getProcIdentifier((SQLObject)((SQLObject)first));
            }
            if (proc == null) {
                MessageDialog.openError((Shell)SPLaunchShortcut.getShell(), (String)Messages.SPLaunchShortcut_error, (String)Messages.SPLaunchShortcut_selectNotSP);
                return;
            }
            try {
                SPLaunchShortcut.launch(proc, mode);
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)SPLaunchShortcut.getShell(), (String)Messages.SPLaunchShortcut_error, (String)NLS.bind((String)Messages.SPLaunchShortcut_launchFailMessage, (Object[])new Object[]{ex.getMessage()}));
            }
        } else {
            MessageDialog.openError((Shell)SPLaunchShortcut.getShell(), (String)Messages.SPLaunchShortcut_error, (String)Messages.SPLaunchShortcut_selectNotSP);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof ProcEditorInput) {
            ProcEditorInput procinput = (ProcEditorInput)input;
            ProcIdentifier proc = procinput.getProcIdentifier();
            try {
                SPLaunchShortcut.launch(proc, mode);
            }
            catch (Exception ex) {
                MessageDialog.openError((Shell)SPLaunchShortcut.getShell(), (String)Messages.SPLaunchShortcut_error, (String)NLS.bind((String)Messages.SPLaunchShortcut_launchFailMessage, (Object[])new Object[]{ex.getMessage()}));
            }
        } else {
            MessageDialog.openError((Shell)SPLaunchShortcut.getShell(), (String)Messages.SPLaunchShortcut_error, (String)Messages.SPLaunchShortcut_notStoreProcedure);
        }
    }

    protected static Shell getShell() {
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (w != null) {
            return w.getShell();
        }
        return null;
    }
}

