/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.parameter;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ISqlDataValidator;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.routineeditor.parameter.IParamListener;
import org.eclipse.datatools.sqltools.routineeditor.parameter.IParamListenerManager;

public class ParameterWrapper
implements IParamListenerManager {
    ParameterDescriptor _pd;
    private boolean _isnull = true;
    private String _value = null;
    ListenerList _listeners = new ListenerList();
    private String _message = null;
    private int _status = 0;

    public ParameterWrapper(ParameterDescriptor pd) {
        this._pd = pd;
    }

    public ParameterDescriptor getParameterDescriptor() {
        return this._pd;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = this.validate(value);
        this.fireAllUpdated(this._pd, this._value);
    }

    public boolean isNull() {
        return this._isnull;
    }

    public void setNull(boolean b) {
        this._isnull = b;
    }

    public void addParamListener(IParamListener listener) {
        this._listeners.add((Object)listener);
    }

    public void removeParamListener(IParamListener listener) {
        this._listeners.remove((Object)listener);
    }

    protected void fireAllUpdated(ParameterDescriptor pd, String value) {
        Object[] listeners = this._listeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((IParamListener)listeners[i]).paramValueUpdated(pd, value);
        }
    }

    public String getMessage() {
        return this._message;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public void setMessage(String _message) {
        this._message = _message;
    }

    private String validate(String value) {
        String result = null;
        try {
            ISqlDataValidator validator = SQLToolsFacade.getConfiguration((DatabaseIdentifier)this._pd.getDatabaseIdentifier(), null).getSQLDataService().getSQLDataValidator(this._pd.getDatabaseIdentifier());
            if (validator == null) {
                return value;
            }
            this._status = validator.validate(this._pd.getTypeName(), value);
            switch (this._status) {
                case 0: {
                    result = validator.getConvertedValue();
                    this.setMessage(null);
                    break;
                }
                case 1: {
                    result = validator.getConvertedValue();
                    this.setMessage(validator.getErrorMessage());
                    break;
                }
                case 2: {
                    result = value;
                    this.setMessage(validator.getErrorMessage());
                    break;
                }
                case 3: {
                    result = value;
                    this.setMessage(validator.getErrorMessage());
                }
            }
        }
        catch (Exception e) {
            String errormes = e.getLocalizedMessage();
            errormes = errormes == null ? "" : errormes;
            int i = errormes.lastIndexOf(":");
            if (i > 0) {
                errormes = errormes.substring(i + 1, errormes.length());
            }
            this.setMessage(this.getMessage() + errormes);
        }
        return result;
    }

    public int getStatus() {
        return this._status;
    }
}

