/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.launching;

import java.text.ParseException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener1;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifierImpl;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class SQLToolsLaunchProfileListener
implements IProfileListener1 {
    public void profileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect) {
        ILaunchConfigurationType type = LaunchHelper.getLaunchConfigType();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            for (int i = 0; i < configs.length; ++i) {
                try {
                    DatabaseIdentifier databaseIdentifier = LaunchHelper.readDatabaseIdentifier(configs[i]);
                    String pName = databaseIdentifier.getProfileName();
                    if (!pName.equals(oldName)) continue;
                    ILaunchConfigurationWorkingCopy copy = configs[i].getWorkingCopy();
                    String encodedProc = configs[i].getAttribute("org.eclipse.datatools.sqltools.debug.launching.procid", "");
                    ProcIdentifier procId = ProcIdentifierImpl.decodeWithNewProfile((String)encodedProc, (String)profile.getName());
                    copy.setAttribute("org.eclipse.datatools.sqltools.debug.launching.procid", procId.encode());
                    copy.setAttribute("org.eclipse.datatools.sqltools.debug.launching.profileName", profile.getName());
                    copy.doSave();
                    continue;
                }
                catch (ParseException pe) {
                    RoutineEditorActivator.getDefault().log(pe);
                    continue;
                }
                catch (CoreException ce) {
                    // empty catch block
                }
            }
        }
        catch (CoreException ce) {
            RoutineEditorActivator.getDefault().log(ce);
        }
    }

    public void profileAdded(IConnectionProfile profile) {
    }

    public void profileDeleted(IConnectionProfile profile) {
        ILaunchConfigurationType type = LaunchHelper.getLaunchConfigType();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            for (int i = 0; i < configs.length; ++i) {
                try {
                    DatabaseIdentifier databaseIdentifier = LaunchHelper.readDatabaseIdentifier(configs[i]);
                    String pName = databaseIdentifier.getProfileName();
                    if (!pName.equals(profile.getName())) continue;
                    configs[i].delete();
                    continue;
                }
                catch (CoreException ce) {
                    // empty catch block
                }
            }
        }
        catch (CoreException ce) {
            RoutineEditorActivator.getDefault().log(ce);
        }
    }

    public void profileChanged(IConnectionProfile profile) {
    }
}

