/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.Parameter;
import org.eclipse.datatools.sqltools.result.ResultSetObject;
import org.eclipse.datatools.sqltools.result.ResultSetRow;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.model.ResultItem;
import org.eclipse.datatools.sqltools.result.internal.utils.HexHelper;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.SQLUtil;
import org.eclipse.datatools.sqltools.result.internal.utils.StatusTextProvider;

public class ColumnAlignedResultItem {
    private static Map _columnLen = new HashMap();
    public static final int PARAM_NAME = 0;
    public static final int PARAM_TYPE = 1;
    public static final int PARAM_DATA_TYPE = 2;
    public static final int PARAM_VALUE = 3;
    public static final int PARAM_VALUE_OUT = 4;
    public static final String[] PARAM_HEADING = new String[]{Messages.MultipleTabsTextSection_parameter_name, Messages.MultipleTabsTextSection_parameter_type, Messages.MultipleTabsTextSection_parameter_datatype, Messages.MultipleTabsTextSection_parameter_value, Messages.MultipleTabsTextSection_parameter_value_out};
    private static final int[] PARAM_SQL_TYPE = new int[]{12, 12, 12, 12, 12};
    private static final int[] PARAM_SIZE = new int[]{20, 20, 20, 20, 20};

    public static String getResultItemDisplayString(ResultItem item, String nullValue, boolean showHeading, boolean showRowCountMsg) {
        StringBuffer sb = new StringBuffer("");
        switch (item.getResultType()) {
            case 2: {
                sb.append((String)item.getResultObject());
                break;
            }
            case 1: {
                if (!showRowCountMsg) break;
                sb.append(StatusTextProvider.getUpdateCountText((Integer)item.getResultObject()));
                break;
            }
            case 3: {
                String headings = ColumnAlignedResultItem.getColumnHeadings((IResultSetObject)item.getResultObject(), nullValue);
                if (showHeading) {
                    sb.append(headings);
                }
                sb.append(ColumnAlignedResultItem.getDisplayData((IResultSetObject)item.getResultObject(), nullValue));
                break;
            }
            case 4: {
                sb.append((String)item.getResultObject());
                break;
            }
        }
        return sb.toString();
    }

    public static String getResultSetDisplayString(IResultSetObject rs, String nullValue, boolean showHeading, boolean showRowCountMsg) {
        ResultItem item = new ResultItem(rs);
        return ColumnAlignedResultItem.getResultItemDisplayString(item, nullValue, showHeading, showRowCountMsg);
    }

    private static String getColumnHeadings(IResultSetObject result, String nullValue) {
        _columnLen.clear();
        int columnCount = result.getColumnCount();
        StringBuffer cn = new StringBuffer(" ");
        StringBuffer cs = new StringBuffer(" ");
        for (int i = 1; i < columnCount + 1; ++i) {
            String columnName = result.getColumnName(i);
            StringBuffer nameDataSeparator = new StringBuffer();
            int columnWidth = ColumnAlignedResultItem.getMaxWidth(result, i, nullValue);
            for (int j = 0; j < columnWidth; ++j) {
                nameDataSeparator.append("-");
            }
            _columnLen.put(columnName, new Integer(columnWidth));
            cn.append(ColumnAlignedResultItem.getDisplayString(columnName, ++columnWidth, false, i == columnCount));
            cs.append(ColumnAlignedResultItem.getDisplayString(nameDataSeparator.toString(), columnWidth, false, i == columnCount));
        }
        cn.append(ColumnAlignedResultItem.getLineSeparator()).append(cs).append(ColumnAlignedResultItem.getLineSeparator());
        return cn.toString();
    }

    private static String getDisplayString(String str, int length, boolean isRightAligned, boolean lastColumn) {
        int strLength = str.length();
        StringBuffer sb = new StringBuffer();
        if (strLength < length) {
            int numOfSpaces = length - strLength;
            for (int j = 0; j < numOfSpaces; ++j) {
                sb.append(" ");
            }
        }
        if (!isRightAligned) {
            if (lastColumn) {
                return str;
            }
            return str + sb.toString();
        }
        sb.append(str);
        return sb.toString();
    }

    private static String getDisplayData(IResultSetObject result, String nullValue) {
        StringBuffer data = new StringBuffer("");
        Iterator iter = result.getDisplayRecords();
        while (iter.hasNext()) {
            IResultSetRow row = (IResultSetRow)iter.next();
            int columnCount = result.getColumnCount();
            for (int i = 1; i < columnCount + 1; ++i) {
                String outValue;
                Object columnValue = row.getData(i - 1);
                if (columnValue == null) {
                    columnValue = nullValue;
                }
                int columnWidth = (Integer)_columnLen.get(result.getColumnName(i));
                data.append(" ");
                if (columnValue instanceof byte[]) {
                    byte[] os = (byte[])columnValue;
                    outValue = HexHelper.toHexString(os);
                } else {
                    outValue = columnValue.toString();
                }
                outValue = outValue.replaceAll(ColumnAlignedResultItem.getLineSeparator(), "  ");
                outValue = outValue.replaceAll("\n", "  ");
                data.append(ColumnAlignedResultItem.getDisplayString(outValue, columnWidth, SQLUtil.isNumericType(result.getColumnSQLType(i)), i == columnCount));
            }
            data.append(ColumnAlignedResultItem.getLineSeparator());
        }
        return data.toString();
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    private static int getMaxWidth(IResultSetObject result, int index, String nullValue) {
        String columnName = result.getColumnName(index);
        int nameLength = columnName.length();
        int actualMaxSize = 0;
        Iterator iter = result.getDisplayRecords();
        while (iter.hasNext()) {
            String outValue;
            IResultSetRow row = (IResultSetRow)iter.next();
            Object columnValue = row.getData(index - 1);
            if (columnValue == null) {
                columnValue = nullValue;
            }
            if (columnValue instanceof byte[]) {
                byte[] os = (byte[])columnValue;
                outValue = HexHelper.toHexString(os);
            } else {
                outValue = columnValue.toString();
            }
            if (outValue.length() <= actualMaxSize) continue;
            actualMaxSize = outValue.length();
        }
        int columnWidth = nameLength > actualMaxSize ? nameLength : actualMaxSize;
        return columnWidth;
    }

    public static String getParametersDsipalyStr(List params, String nullValue) {
        if (params == null || params.size() == 0) {
            return "";
        }
        ArrayList<ResultSetRow> rows = new ArrayList<ResultSetRow>();
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Parameter param = (Parameter)iter.next();
            if (param == null) continue;
            ResultSetRow row = new ResultSetRow(5);
            row.setData(param.getParamName(), 0);
            row.setData(param.getParamType(), 1);
            row.setData(param.getParamDataType(), 2);
            row.setData(param.getParamValue(), 3);
            row.setData(param.getParamOutValue(), 4);
            rows.add(row);
        }
        String displayStr = "";
        try {
            ResultSetObject rs = new ResultSetObject(rows, PARAM_HEADING, PARAM_SQL_TYPE, PARAM_SIZE);
            displayStr = ColumnAlignedResultItem.getResultSetDisplayString(rs, nullValue, true, false);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return displayStr;
    }

    public static String getResultInstanceDispString(IResultInstance instance, String nullValue) {
        int count = instance.getItemCount();
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < count; ++i) {
            ResultItem item = instance.getItem(i);
            if (item.getResultType() == 4) continue;
            sb.append(ColumnAlignedResultItem.getResultItemDisplayString(item, nullValue, true, true));
        }
        ArrayList params = new ArrayList();
        if (instance.getParameters() != null) {
            Iterator paramIter = instance.getParameters().iterator();
            while (paramIter.hasNext()) {
                Object obj = paramIter.next();
                if (obj == null || !(obj instanceof Parameter)) continue;
                params.add(obj);
            }
        }
        if (params.size() > 0) {
            sb.append(Messages.SingleWindowTextSection_inout_params).append(ColumnAlignedResultItem.getLineSeparator());
        }
        sb.append(ColumnAlignedResultItem.getParametersDsipalyStr(params, nullValue));
        return sb.toString();
    }
}

