/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.export.AbstractOutputter;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.model.ResultItem;

public class HTMLOutputter
extends AbstractOutputter {
    public void output(IResultSetObject resultset, Properties options, OutputStream stream) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream, options.getProperty("encoding")));
        this.output(resultset, options, writer);
    }

    public void output(IResultSetObject resultset, Properties options, PrintWriter writer) throws IOException {
        this.outputHTMLHeader(options, writer);
        this.outputHTMLContent(resultset, options, writer);
        this.outputHTMLFooter(writer);
    }

    public void output(IResultInstance rs, Properties props, OutputStream os) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(os, props.getProperty("encoding")));
        this.output(rs, props, writer);
    }

    public void output(IResultInstance rs, Properties props, PrintWriter pw) throws IOException {
        this.outputHTMLHeader(props, pw);
        for (int i = 0; i < rs.getItemCount(); ++i) {
            ResultItem item = rs.getItem(i);
            if (item == null || !(item.getResultObject() instanceof IResultSetObject)) continue;
            IResultSetObject result = (IResultSetObject)item.getResultObject();
            this.outputHTMLContent(result, props, pw);
        }
        this.outputHTMLFooter(pw);
    }

    private void outputHTMLHeader(Properties options, PrintWriter writer) {
        String encoding = options.getProperty("encoding");
        writer.println("<html>");
        writer.println("<head><meta content=\"text/html;charset=" + encoding + "\" /></head>");
        writer.println("<body>");
    }

    private void outputHTMLFooter(PrintWriter writer) {
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
    }

    private void outputHTMLContent(IResultSetObject resultset, Properties options, PrintWriter writer) throws IOException {
        String[] columnNames = resultset.getColumnNames();
        writer.println("<table border=\"1\">");
        writer.write("<tr>");
        for (int i = 0; i < columnNames.length; ++i) {
            writer.write("<th>");
            this.writeStringData(writer, columnNames[i]);
            writer.write("</th>");
        }
        writer.println("</tr>");
        Iterator iter = resultset.getAllRecords();
        while (iter != null && iter.hasNext()) {
            IResultSetRow rowData = (IResultSetRow)iter.next();
            this.outputHTMLContentColumn(rowData.getData(), options, writer);
        }
        iter = null;
        writer.println("</table>");
    }

    private void outputHTMLContentColumn(Object[] rowdata, Properties options, PrintWriter writer) throws IOException {
        writer.write("<tr>");
        for (int j = 0; j < rowdata.length; ++j) {
            writer.write("<td>");
            if (rowdata[j] == null) {
                String nullString = ResultsViewPlugin.getDefault().getPreferenceStore().getString("org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr");
                writer.write(nullString);
            } else if (rowdata[j] instanceof byte[]) {
                this.writeBinaryData(writer, rowdata[j]);
            } else {
                this.writeStringData(writer, rowdata[j].toString());
            }
            writer.write("</td>");
        }
        writer.println("</tr>");
    }
}

