/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.viewer;

import com.ibm.icu.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

class ViewerSorterByColumn
extends ViewerSorter {
    private int _columnIndex;
    private IResultSetObject _result;
    private int _order;
    private ITableLabelProvider _labelProvider;
    private boolean _showRowCount;

    public ViewerSorterByColumn(int index, IResultSetObject result, int order, ITableLabelProvider labelProvider, boolean showRowCount) {
        this._columnIndex = index;
        this._result = result;
        this._order = order;
        this._labelProvider = labelProvider;
        this._showRowCount = showRowCount;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int type = this._result.getColumnSQLType(this._columnIndex);
        int index = this._columnIndex;
        if (!this._showRowCount) {
            index = this._columnIndex - 1;
        }
        if (type == 4 || type == 3 || type == 8 || type == 6 || type == 2 || type == 7 || type == -6 || type == 5 || type == -5) {
            block15: {
                try {
                    double value1 = Double.parseDouble(this._labelProvider.getColumnText(e1, index));
                    double value2 = Double.parseDouble(this._labelProvider.getColumnText(e2, index));
                    if (value1 > value2) {
                        return -1 * this._order;
                    }
                    if (value1 != value2) break block15;
                    return 0;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            return 1 * this._order;
        }
        if (type == 1 || type == 12 || type == -1) {
            return super.compare(viewer, (Object)this._labelProvider.getColumnText(e1, index), (Object)this._labelProvider.getColumnText(e2, index)) * this._order;
        }
        if (type == 91 || type == 93 || type == 92) {
            try {
                SimpleDateFormat dFormatter = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
                Date date1 = dFormatter.parse(this._labelProvider.getColumnText(e1, index));
                Date date2 = dFormatter.parse(this._labelProvider.getColumnText(e2, index));
                return date1.before(date2) ? 1 * this._order : -1 * this._order;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        if (type == -7 || type == 16) {
            try {
                Boolean value1 = Boolean.valueOf(this._labelProvider.getColumnText(e1, index));
                Boolean value2 = Boolean.valueOf(this._labelProvider.getColumnText(e2, index));
                if (value1.booleanValue() && !value2.booleanValue()) {
                    return 1 * this._order;
                }
                if (!value1.booleanValue() && value2.booleanValue()) {
                    return -1 * this._order;
                }
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }
}

