/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.ui.actions;

import org.eclipse.datatools.sqltools.plan.internal.IPlanInstance;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.Messages;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.RemoveAllPlansAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.ShowPlanAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.ShowPlansAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.view.PlanView;
import org.eclipse.datatools.sqltools.plan.internal.util.Images;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PlanDropDownAction
extends Action
implements IMenuCreator {
    private Menu _fMenu;
    private PlanView _planView;

    public PlanDropDownAction(PlanView planView) {
        this.setText(Messages.PlanDropDownAction_previous_plans);
        this.setToolTipText(Messages.PlanDropDownAction_show_history);
        this.setImageDescriptor(Images.DESC_SHOWPLAN);
        this.setDisabledImageDescriptor(Images.DESC_SHOWPLAN);
        this._planView = planView;
        this.setMenuCreator(this);
    }

    public void dispose() {
        this.disposeMenu();
    }

    public void disposeMenu() {
        if (this._fMenu != null) {
            this._fMenu.dispose();
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        IPlanInstance[] instances = PlanViewPlugin.getPlanManager().getAllPlanInstances();
        IPlanInstance current = this._planView.getCurrentPlan();
        this.disposeMenu();
        this._fMenu = new Menu(parent);
        for (int i = instances.length - 1; i >= 0; --i) {
            IPlanInstance instance = instances[i];
            String label = instance.getPlanRequest().getDatabaseDefinitionId() + ": " + instance.getPlanRequest().getSql();
            if (label.length() > 40) {
                label = label.substring(0, 37) + " ...";
            }
            ImageDescriptor image = null;
            int planType = instance.getPlanRequest().getPlanType();
            if (instance.getStatus() == 2) {
                image = Images.DESC_FAILED_PLAN;
            } else {
                switch (planType) {
                    case 0: {
                        image = Images.DESC_TEXT_PLAN;
                        break;
                    }
                    case 1: {
                        image = Images.DESC_GRAPHIC_PLAN;
                    }
                }
            }
            ShowPlanAction action = new ShowPlanAction(this._planView, instance, label, image, "");
            if (instances[i].equals(current)) {
                action.setChecked(true);
            }
            this.addActionToMenu(this._fMenu, action);
        }
        if (instances.length > 0) {
            new MenuItem(this._fMenu, 2);
            this.addActionToMenu(this._fMenu, new RemoveAllPlansAction());
        }
        return this._fMenu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new ShowPlansAction(this._planView).run();
    }

    public void update() {
        this.setEnabled(PlanViewPlugin.getPlanManager().getAllPlanInstances().length != 0);
    }
}

