/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import com.ibm.icu.util.StringTokenizer;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.ServerIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.internal.core.Messages;
import org.eclipse.osgi.util.NLS;

public class ProcIdentifierImpl
implements ProcIdentifier {
    private DatabaseIdentifier _database;
    private int _type;
    Map propertyMap;

    public ProcIdentifierImpl(int type, DatabaseIdentifier db, Map map) {
        this._type = type;
        this._database = db;
        if (map == null) {
            throw new IllegalArgumentException(Messages.ProcIdentifierImpl_map_cant_be_null);
        }
        this.propertyMap = map;
    }

    public int getType() {
        return this._type;
    }

    public String getProcName() {
        return (String)this.propertyMap.get("NAME");
    }

    public String getOwnerName() {
        return (String)this.propertyMap.get("OWNER");
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._database;
    }

    public String getDatabaseName() {
        return this._database.getDBname();
    }

    public String getProfileName() {
        return this._database.getProfileName();
    }

    public int getNumber() {
        try {
            String n = (String)this.propertyMap.get("NUMBER");
            return Integer.parseInt(n);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getTableName() {
        return (String)this.propertyMap.get("TABLENAME");
    }

    public String getTableOwnerName() {
        return (String)this.propertyMap.get("TABLEOWNERNAME");
    }

    public int hashCode() {
        return this.getProfileName().hashCode() + this.getProcName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcIdentifierImpl) {
            ProcIdentifierImpl p = (ProcIdentifierImpl)obj;
            boolean e = this.getDatabaseIdentifier().equals(p.getDatabaseIdentifier()) && this.getType() == p.getType() && this.propertyMap.equals(p.propertyMap);
            return e;
        }
        return false;
    }

    public boolean equalsByServer(Object obj) {
        if (obj instanceof ProcIdentifierImpl) {
            ProcIdentifierImpl p = (ProcIdentifierImpl)obj;
            boolean e = this.getDatabaseIdentifier().equals(p.getDatabaseIdentifier());
            if (!e) {
                ServerIdentifier si1 = ProfileUtil.getServerIdentifier(this.getDatabaseIdentifier());
                ServerIdentifier si2 = ProfileUtil.getServerIdentifier(p.getDatabaseIdentifier());
                e = si1.equals(si2);
            }
            e = e && this.getType() == p.getType() && this.propertyMap.equals(p.propertyMap);
            return e;
        }
        return false;
    }

    public String toString() {
        return this.encode();
    }

    public static void encodeMap(StringBuffer buffer, Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)map.get(key);
            buffer.append(key).append('=').append(value).append('/');
        }
    }

    public static Map decodeMap(String encoded) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(encoded, "/");
        while (tokenizer.hasMoreTokens()) {
            String pair = tokenizer.nextToken();
            int index = pair.indexOf(61);
            if (index == -1) continue;
            result.put(pair.substring(0, index), pair.substring(index + 1));
        }
        return result;
    }

    public String encode() {
        StringBuffer buffer = new StringBuffer();
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("PROFILE", this._database.getProfileName());
        temp.put("DBNAME", this._database.getDBname());
        temp.put("TYPE", String.valueOf(this._type));
        ProcIdentifierImpl.encodeMap(buffer, temp);
        ProcIdentifierImpl.encodeMap(buffer, this.propertyMap);
        return buffer.toString();
    }

    public static ProcIdentifier decode(String encoded) throws ParseException {
        Map map = ProcIdentifierImpl.decodeMap(encoded);
        String profile = (String)map.remove("PROFILE");
        String dbname = (String)map.remove("DBNAME");
        String typestr = (String)map.remove("TYPE");
        if (profile == null || dbname == null || typestr == null) {
            throw new ParseException(Messages.ProcIdentifierImpl_invalid_identifier_string, -1);
        }
        try {
            int type = Integer.parseInt(typestr);
            SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName(profile);
            if (config != null) {
                DBHelper h = config.getDBHelper();
                return h.getProcIdentifier(new DatabaseIdentifier(profile, dbname), type, map);
            }
            return new ProcIdentifierImpl(type, new DatabaseIdentifier(profile, dbname), map);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(Messages.ProcIdentifierImpl_invalid_identifier_string, -1);
        }
    }

    public static ProcIdentifier decodeWithNewProfile(String encoded, String profile) throws ParseException {
        Map map = ProcIdentifierImpl.decodeMap(encoded);
        map.remove("PROFILE");
        String dbname = (String)map.remove("DBNAME");
        String typestr = (String)map.remove("TYPE");
        if (profile == null || dbname == null || typestr == null) {
            throw new ParseException(Messages.ProcIdentifierImpl_invalid_identifier_string, -1);
        }
        try {
            int type = Integer.parseInt(typestr);
            SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName(profile);
            if (config != null) {
                DBHelper h = config.getDBHelper();
                String tableOwnerName = (String)map.get("TABLEOWNERNAME");
                if (tableOwnerName == null && type == 3) {
                    tableOwnerName = (String)map.get("OWNER");
                }
                return h.getProcIdentifier(new DatabaseIdentifier(profile, dbname), (String)map.get("NAME"), type, (String)map.get("TABLENAME"), (String)map.get("OWNER"), tableOwnerName);
            }
            return new ProcIdentifierImpl(type, new DatabaseIdentifier(profile, dbname), map);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(Messages.ProcIdentifierImpl_invalid_identifier_string, -1);
        }
    }

    public String getDisplayString() {
        int number = this.getNumber();
        if (number > 1) {
            return String.valueOf(this.getProcName()) + ";" + number;
        }
        return this.getProcName();
    }

    public String getLongDisplayString() {
        String s = "";
        if (this.getType() == 3 && this.getTableName() != null && this.getTableName().length() > 0) {
            String tableOwner = this.getTableOwnerName();
            if (tableOwner == null) {
                tableOwner = this.getOwnerName();
            }
            s = NLS.bind((String)Messages.ProcIdentifierImpl_trigger_long_display_string, (Object[])new Object[]{this.getProfileName(), this.getDatabaseName(), tableOwner, this.getTableName(), this.getDisplayString()});
        } else {
            s = NLS.bind((String)Messages.ProcIdentifierImpl_long_display_string, (Object[])new Object[]{this.getProfileName(), this.getDatabaseName(), this.getOwnerName(), this.getDisplayString()});
        }
        return s;
    }

    public String getCallableStringWithoutGroupNumber() {
        return this.getCallableStringWithoutGroupNumber(true);
    }

    public String getCallableString() {
        return this.getCallableString(true);
    }

    public void setProfileName(String profileName) {
        this._database.setProfileName(profileName);
    }

    public String getCallableString(boolean quoted_id) {
        String s = this.getCallableStringWithoutGroupNumber(quoted_id);
        int number = this.getNumber();
        if (number > 0) {
            return String.valueOf(s) + ";" + number;
        }
        return s;
    }

    public String getCallableStringWithoutGroupNumber(boolean quoted_id) {
        String ownerName = null;
        String procName = null;
        String db = this._database.getDBname();
        db = SQLDevToolsUtil.quoteWhenNecessary(db, new DatabaseIdentifier(this._database.getProfileName(), db));
        if (quoted_id) {
            ownerName = SQLDevToolsUtil.quoteWhenNecessary(this.getOwnerName(), this._database);
            procName = SQLDevToolsUtil.quoteWhenNecessary(this.getProcName(), this._database);
        } else {
            ownerName = this.getOwnerName();
            procName = this.getProcName();
        }
        if (db != null && db.length() > 0) {
            return String.valueOf(db) + "." + ownerName + "." + procName;
        }
        if (ownerName != null && ownerName.length() > 0) {
            return String.valueOf(ownerName) + "." + procName;
        }
        return procName;
    }
}

