/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.services;

import java.util.ArrayList;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.editor.template.GenericSQLContextType;
import org.eclipse.datatools.sqltools.internal.core.Messages;
import org.eclipse.datatools.sqltools.sql.ISQLSyntax;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParserProposalAdvisor;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLDelimiter;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLStatementElement;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sql.updater.ProceduralObjectSourceUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;

public class SQLService {
    public ISQLSyntax getSQLSyntax() {
        return null;
    }

    public GenericSQLContextType getSQLContextType() {
        return new GenericSQLContextType();
    }

    public SQLParser getSQLParser() {
        return null;
    }

    public String[] splitSQL(String sql) {
        SQLParser parser = this.getSQLParser();
        if (parser == null) {
            return new String[]{sql};
        }
        ArrayList<String> groups = new ArrayList<String>();
        try {
            Document doc = new Document(sql);
            ParserParameters parserParameters = new ParserParameters(true);
            parserParameters.setProperty((Object)"__consume_exception", (Object)Boolean.FALSE);
            ParsingResult result = parser.parse(sql, parserParameters);
            if (result.getExceptions() != null && !result.getExceptions().isEmpty()) {
                return this.splitSQLByTerminatorLine(sql, parser.getStatementTerminators());
            }
            IASTStart root = result.getRootNode();
            root.setDocument((IDocument)doc);
            String group = "";
            if (root.jjtGetNumChildren() > 0) {
                for (int i = 0; i < root.jjtGetNumChildren(); ++i) {
                    Node node = root.jjtGetChild(i);
                    if (node instanceof IASTSQLDelimiter) {
                        if (group.trim().equals("")) continue;
                        groups.add(group);
                        group = "";
                        continue;
                    }
                    group = node instanceof IASTSQLStatementElement ? group + node.getSQLText() + " " : group + node.getSQLText() + System.getProperty("line.separator");
                }
            } else {
                group = sql;
            }
            if (!group.trim().equals("")) {
                groups.add(group);
            }
        }
        catch (Exception e1) {
            EditorCorePlugin.getDefault().log(NLS.bind((String)Messages.DefaultSQLSyntax_exception_splitSQL, (Object)sql), e1);
        }
        return groups.toArray(new String[groups.size()]);
    }

    public String[] splitSQLByTerminatorLine(String sql, String[] terminators) {
        Document doc = new Document(sql);
        ArrayList<String> groups = new ArrayList<String>();
        int index = 0;
        int numberOfLines = doc.getNumberOfLines();
        try {
            String string;
            block2: for (int i = 0; i < numberOfLines; ++i) {
                IRegion r = doc.getLineInformation(i);
                String line = doc.get(r.getOffset(), r.getLength());
                for (int j = 0; j < terminators.length; ++j) {
                    if (!line.trim().equalsIgnoreCase(terminators[j])) continue;
                    String string2 = doc.get(index, r.getOffset() - index);
                    if (string2.trim().length() > 0) {
                        groups.add(string2);
                    }
                    index = r.getOffset() + doc.getLineLength(i);
                    continue block2;
                }
            }
            if (index < doc.getLength() - 1 && (string = doc.get(index, doc.getLength() - index)).trim().length() > 0) {
                groups.add(string);
            }
        }
        catch (Exception e) {
            return new String[]{sql};
        }
        return groups.toArray(new String[groups.size()]);
    }

    public ParserProposalAdvisor getParserProposalAdvisor() {
        return new ParserProposalAdvisor();
    }

    public IIdentifierValidator getIdentifierValidator() {
        return null;
    }

    public ProceduralObjectSourceUpdater getProceduralObjectSourceUpdater(SQLObject object, DatabaseDefinition dbDefinition) {
        return null;
    }
}

