/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal;

public class FormatterUtil {
    public static boolean isIndentChar(char ch) {
        return Character.isWhitespace(ch) && !FormatterUtil.isLineDelimiterChar(ch);
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public static int computeIndent(String line, int tabWidth) {
        int result = 0;
        int blanks = 0;
        int size = line.length();
        for (int i = 0; i < size; ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++result;
                blanks = 0;
                continue;
            }
            if (FormatterUtil.isIndentChar(c)) {
                if (++blanks != tabWidth) continue;
                ++result;
                blanks = 0;
                continue;
            }
            return result;
        }
        return result;
    }

    public static String removeDoubleQuotation(String string) {
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

