/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.core.DataTypeStringParser;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.IDatabaseSetting;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DataTypeProvider {
    public static final String LENGTH_FEATURE = "length";
    public static final String PRECISION_FEATURE = "precision";
    public static final String SCALE_FEATURE = "scale";
    public static final String NAME_FEATURE = "name";
    protected static final String[][] RECOMMEND_LENGTH_PRECISION_SCALE = new String[][]{{"binary", "10"}, {"char", "5"}, {"decimal", "8", "3"}, {"numeric", "8", "3"}, {"varchar", "20"}, {"float", "4"}, {"varbinary", "10"}, {"unichar", "10"}, {"univarchar", "20"}, {"nchar", "10"}, {"nvarchar", "20"}};
    public static final int ALL = 0;
    public static final int PREDEFINED = 1;
    public static final int UDT = 2;
    public static final int TABLE_COLUMN = 3;
    public static final int PARAMETER = 4;
    public static final int VARIABLE = 5;
    public static final int RETURN_VALUE = 6;
    public static final int INDEX_COLUMN = 7;
    public static final int DB_SPECIFIC_CONTEXT_BASE = 100;

    public DataType[] getAvailableDataTypes(int context, Schema schema, DatabaseIdentifier databaseIdentifier) {
        ArrayList<PredefinedDataType> predefinedTypes = new ArrayList<PredefinedDataType>();
        PredefinedDataTypeDefinition[] preTypeDefs = this.getPredefinedDataTypeDefinitions();
        DatabaseDefinition dbdef = this.getDbDefinition();
        if (preTypeDefs != null && dbdef != null) {
            for (int i = 0; i < preTypeDefs.length; ++i) {
                PredefinedDataType dType = dbdef.getPredefinedDataType(preTypeDefs[i]);
                if (dType == null) continue;
                String[] lengthPrecisionScale = this.getLengthPrecisionScale(dType.getName());
                if (lengthPrecisionScale != null) {
                    EStructuralFeature f;
                    if (lengthPrecisionScale.length > 1 && preTypeDefs[i].isLengthSupported()) {
                        f = dType.eClass().getEStructuralFeature(LENGTH_FEATURE);
                        dType.eSet(f, (Object)Integer.valueOf(lengthPrecisionScale[1]));
                    } else if (lengthPrecisionScale.length > 1 && preTypeDefs[i].isPrecisionSupported()) {
                        f = dType.eClass().getEStructuralFeature(PRECISION_FEATURE);
                        dType.eSet(f, (Object)Integer.valueOf(lengthPrecisionScale[1]));
                    }
                    if (lengthPrecisionScale.length > 2 && preTypeDefs[i].isScaleSupported()) {
                        EStructuralFeature feature = dType.eClass().getEStructuralFeature(SCALE_FEATURE);
                        dType.eSet(feature, (Object)Integer.valueOf(lengthPrecisionScale[2]));
                    }
                }
                predefinedTypes.add(dType);
            }
        }
        if (context == 1) {
            return predefinedTypes.toArray(new DataType[predefinedTypes.size()]);
        }
        ArrayList udts = new ArrayList();
        if (schema != null) {
            List schemas = null;
            if (schema.getCatalog() != null && schema.getCatalog().getSchemas() != null) {
                schemas = schema.getCatalog().getSchemas();
            }
            if (schemas == null && schema.getDatabase() != null && schema.getDatabase().getSchemas() != null) {
                schemas = schema.getDatabase().getSchemas();
            }
            if (schemas != null) {
                Iterator i = schemas.iterator();
                while (i.hasNext()) {
                    Schema s = (Schema)i.next();
                    udts.addAll(s.getUserDefinedTypes());
                }
            } else {
                udts.addAll(schema.getUserDefinedTypes());
            }
        }
        switch (context) {
            case 2: {
                return udts.toArray(new DataType[udts.size()]);
            }
            case 0: 
            case 3: {
                ArrayList<Object> all = new ArrayList<Object>();
                all.addAll(predefinedTypes);
                all.addAll(udts);
                return all.toArray(new DataType[all.size()]);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ArrayList<Object> typesWithoutLargeType = new ArrayList<Object>();
                typesWithoutLargeType.addAll(predefinedTypes);
                typesWithoutLargeType.addAll(udts);
                ArrayList<DataType> largeTypes = new ArrayList<DataType>();
                Iterator i = typesWithoutLargeType.iterator();
                while (i.hasNext()) {
                    DataType type = (DataType)i.next();
                    PrimitiveType primitiveType = null;
                    if (type instanceof PredefinedDataType) {
                        primitiveType = ((PredefinedDataType)type).getPrimitiveType();
                    } else if (type instanceof DistinctUserDefinedType) {
                        DistinctUserDefinedType udt = (DistinctUserDefinedType)type;
                        PredefinedDataType predefinedType = udt.getPredefinedRepresentation();
                        primitiveType = predefinedType.getPrimitiveType();
                    }
                    if (primitiveType == null || primitiveType != PrimitiveType.BINARY_LARGE_OBJECT_LITERAL && primitiveType != PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL && primitiveType != PrimitiveType.XML_TYPE_LITERAL && primitiveType != PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL) continue;
                    largeTypes.add(type);
                }
                typesWithoutLargeType.removeAll(largeTypes);
                return typesWithoutLargeType.toArray(new DataType[typesWithoutLargeType.size()]);
            }
        }
        return new DataType[0];
    }

    public String[] getAvailableDataTypesDisplayString(int context, Schema schema, DatabaseIdentifier databaseIdentifier) {
        DataType[] types = this.getAvailableDataTypes(context, schema, databaseIdentifier);
        if (types == null) {
            return new String[0];
        }
        ArrayList<String> dispStrings = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            String dispStr;
            if (types[i] == null || (dispStr = this.getDataTypeString(types[i], false)) == null) continue;
            if (types[i] instanceof PredefinedDataType) {
                dispStr = dispStr.toLowerCase();
            }
            if (dispStrings.contains(dispStr)) continue;
            dispStrings.add(dispStr);
        }
        Collections.sort(dispStrings, new TypeNameComparator());
        return dispStrings.toArray(new String[dispStrings.size()]);
    }

    public DataType getDataType(String typeString, Schema schema, DatabaseIdentifier databaseIdentifier) {
        return this.getDataType(typeString, schema, 0, databaseIdentifier);
    }

    public DataType getDataType(String typeString, Schema schema, int context, DatabaseIdentifier databaseIdentifier) {
        if (typeString == null) {
            return null;
        }
        DataTypeStringParser parser = this.getDataTypeStringParser();
        DatabaseDefinition dbdef = this.getDbDefinition();
        if (parser == null || dbdef == null) {
            return null;
        }
        String[] typeInfo = parser.parseDatatype(typeString);
        if (typeInfo == null || typeInfo.length == 0 || typeInfo[0] == null) {
            return null;
        }
        DataType[] validTypes = this.getAvailableDataTypes(context, schema, databaseIdentifier);
        if (validTypes == null || validTypes.length == 0) {
            return null;
        }
        for (int i = 0; i < validTypes.length; ++i) {
            if (validTypes[i] instanceof PredefinedDataType) {
                PredefinedDataTypeDefinition typeDefinition = dbdef.getPredefinedDataTypeDefinition(typeInfo[0]);
                PredefinedDataTypeDefinition typeDef = this.getPredefinedDataTypeDefinition((PredefinedDataType)validTypes[i]);
                if (typeDefinition == null || typeDefinition != typeDef) {
                    continue;
                }
            } else if ((!this.isDataTypeCaseSensitive(databaseIdentifier) || !typeInfo[0].equals(validTypes[i].getName())) && (this.isDataTypeCaseSensitive(databaseIdentifier) || !typeInfo[0].equalsIgnoreCase(validTypes[i].getName()))) continue;
            if (validTypes[i] instanceof PredefinedDataType) {
                EStructuralFeature feature;
                PredefinedDataType predefinedType = (PredefinedDataType)validTypes[i];
                PredefinedDataTypeDefinition typeDefinition = this.getPredefinedDataTypeDefinition(predefinedType);
                if (typeDefinition == null) continue;
                PredefinedDataType type = dbdef.getPredefinedDataType(typeInfo[0]);
                if (typeInfo.length > 1 && typeDefinition.isLengthSupported()) {
                    feature = type.eClass().getEStructuralFeature(LENGTH_FEATURE);
                    type.eSet(feature, (Object)new Integer(typeInfo[1]));
                } else if (typeInfo.length > 1 && typeDefinition.isPrecisionSupported()) {
                    feature = type.eClass().getEStructuralFeature(PRECISION_FEATURE);
                    type.eSet(feature, (Object)new Integer(typeInfo[1]));
                }
                if (typeInfo.length > 2 && typeDefinition.isScaleSupported()) {
                    feature = type.eClass().getEStructuralFeature(SCALE_FEATURE);
                    type.eSet(feature, (Object)new Integer(typeInfo[2]));
                }
                return type;
            }
            if (!(validTypes[i] instanceof UserDefinedType)) continue;
            return validTypes[i];
        }
        return null;
    }

    public String getDataTypeString(DataType dataType, boolean qualified) {
        if (dataType == null) {
            return "";
        }
        if (dataType instanceof PredefinedDataType) {
            if (this.getDbDefinition() == null) {
                return dataType.getName();
            }
            return this.getDbDefinition().getPredefinedDataTypeFormattedName((PredefinedDataType)dataType);
        }
        if (dataType instanceof UserDefinedType) {
            UserDefinedType udt = (UserDefinedType)dataType;
            if (qualified && udt.getSchema() != null && udt.getSchema().getName() != null) {
                return udt.getSchema().getName() + "." + dataType.getName();
            }
            return dataType.getName();
        }
        return dataType.getName();
    }

    public PredefinedDataTypeDefinition[] getPredefinedDataTypeDefinitions() {
        DatabaseDefinition dbdef = this.getDbDefinition();
        if (dbdef == null) {
            return new PredefinedDataTypeDefinition[0];
        }
        ArrayList typeDefs = new ArrayList();
        Iterator iter = dbdef.getPredefinedDataTypes();
        while (iter.hasNext()) {
            typeDefs.add(iter.next());
        }
        return typeDefs.toArray(new PredefinedDataTypeDefinition[typeDefs.size()]);
    }

    public String[] getPredefinedDataTypeNames() {
        ArrayList<String> dispStrs = new ArrayList<String>();
        PredefinedDataTypeDefinition[] defs = this.getPredefinedDataTypeDefinitions();
        if (defs == null) {
            return null;
        }
        for (int i = 0; i < defs.length; ++i) {
            String name;
            if (defs[i] == null || (name = (String)defs[i].getName().get(0)) == null || name.trim().length() == 0 || dispStrs.contains(name.toLowerCase())) continue;
            dispStrs.add(name.toLowerCase());
        }
        return dispStrs.toArray(new String[dispStrs.size()]);
    }

    protected DatabaseDefinition getDbDefinition() {
        return null;
    }

    protected String[] getLengthPrecisionScale(String typeName) {
        for (int i = 0; i < RECOMMEND_LENGTH_PRECISION_SCALE.length; ++i) {
            if (!RECOMMEND_LENGTH_PRECISION_SCALE[i][0].equalsIgnoreCase(typeName)) continue;
            return RECOMMEND_LENGTH_PRECISION_SCALE[i];
        }
        return null;
    }

    protected boolean isDataTypeCaseSensitive(DatabaseIdentifier databaseIdentifier) {
        if (this.getDbDefinition() == null || databaseIdentifier == null) {
            return false;
        }
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfiguration(databaseIdentifier, new DatabaseVendorDefinitionId(this.getDbDefinition().getProduct(), this.getDbDefinition().getVersion()));
        if (config == null) {
            return false;
        }
        IDatabaseSetting setting = config.getDatabaseSetting(databaseIdentifier);
        if (setting == null) {
            return false;
        }
        try {
            Object obj = setting.getProperty("P_CASE_SENSITIVE");
            if (obj == null || !(obj instanceof Boolean)) {
                return false;
            }
            return (Boolean)obj;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected DataTypeStringParser getDataTypeStringParser() {
        return new DataTypeStringParser();
    }

    protected PredefinedDataTypeDefinition getPredefinedDataTypeDefinition(PredefinedDataType dataType) {
        if (dataType == null || dataType.getName() == null) {
            return null;
        }
        PredefinedDataTypeDefinition[] defs = this.getPredefinedDataTypeDefinitions();
        for (int i = 0; i < defs.length; ++i) {
            if (defs[i] == null || defs[i].getName() == null || !DataTypeProvider.matchName((List)defs[i].getName(), dataType.getName(), false)) continue;
            return defs[i];
        }
        return null;
    }

    protected static boolean matchName(List names, String name, boolean caseSensitive) {
        if (names == null || names.size() == 0 || name == null) {
            return false;
        }
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String n = (String)i.next();
            if (n == null) continue;
            if (caseSensitive && n.equals(name)) {
                return true;
            }
            if (caseSensitive || !n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    class TypeNameComparator
    implements Comparator {
        TypeNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            if (!(o1 instanceof String) || !(o2 instanceof String)) {
                return 0;
            }
            String s1 = ((String)o1).toLowerCase();
            String s2 = ((String)o2).toLowerCase();
            return s1.compareTo(s2);
        }
    }
}

