/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.profile;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.IProfileListener1;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.profile.ConnectProfile;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.profile.SQLToolsProfileListenersManager;
import org.eclipse.datatools.sqltools.editor.core.connection.SQLToolsConnectListenersManager;

public class SQLToolsProfileProxyListener
implements IProfileListener1,
IManagedConnectionListener {
    private ArrayList _profiles = new ArrayList();
    SQLToolsProfileListenersManager _dmpProfileManager = SQLToolsProfileListenersManager.getInstance();
    SQLToolsConnectListenersManager _dmpConnectManager = SQLToolsConnectListenersManager.getInstance();
    private static SQLToolsProfileProxyListener INSTANCE = null;

    private SQLToolsProfileProxyListener() {
    }

    public static synchronized SQLToolsProfileProxyListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SQLToolsProfileProxyListener();
        }
        return INSTANCE;
    }

    public void init(IConnectionProfile[] profiles) {
        for (int i = 0; i < profiles.length; ++i) {
            this._profiles.add(new ConnectProfile(profiles[i]));
            IManagedConnection mc = profiles[i].getManagedConnection((class$org$eclipse$datatools$connectivity$sqm$core$connection$ConnectionInfo == null ? SQLToolsProfileProxyListener.class$("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo") : class$org$eclipse$datatools$connectivity$sqm$core$connection$ConnectionInfo).getName());
            if (mc == null) continue;
            mc.addConnectionListener((IManagedConnectionListener)this);
        }
    }

    public void profileAdded(IConnectionProfile profile) {
        if (!ProfileUtil.isSupportedProfile(profile)) {
            return;
        }
        this._profiles.add(new ConnectProfile(profile));
        IManagedConnection mc = profile.getManagedConnection(ConnectionInfo.class.getName());
        if (mc != null) {
            mc.addConnectionListener((IManagedConnectionListener)this);
        }
        this._dmpProfileManager.fireProfileAdded(profile);
    }

    public void profileDeleted(IConnectionProfile profile) {
        if (!ProfileUtil.isSupportedProfile(profile)) {
            return;
        }
        IControlConnection[] controlConnections = EditorCorePlugin.getControlConnectionManager().getControlConnections(profile.getName());
        if (controlConnections != null) {
            for (int i = 0; i < controlConnections.length; ++i) {
                controlConnections[i].disconnect(true);
            }
        }
        this._profiles.remove(new ConnectProfile(profile));
        IManagedConnection mc = profile.getManagedConnection(ConnectionInfo.class.getName());
        mc.removeConnectionListener((IManagedConnectionListener)this);
        this._dmpProfileManager.fireProfileDeleted(profile);
    }

    public void profileChanged(IConnectionProfile profile) {
    }

    public void profileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect) {
        if (!ProfileUtil.isSupportedProfile(profile)) {
            return;
        }
        ConnectProfile oldProfile = this.findOldProfile(profile);
        if (oldProfile == null) {
            return;
        }
        ConnectProfile dmpConnectProfile = new ConnectProfile(profile);
        boolean onlyNameChanged = oldProfile.isOnlyNameChanged(dmpConnectProfile);
        oldName = oldProfile.getName();
        IControlConnection[] controlCons = EditorCorePlugin.getControlConnectionManager().getControlConnections(oldName);
        if (controlCons != null) {
            for (int n = 0; n < controlCons.length; ++n) {
                if (onlyNameChanged) {
                    controlCons[n].profileRenamed(profile.getName());
                    continue;
                }
                controlCons[n].disconnect(true);
            }
        }
        this._dmpProfileManager.fireProfileChanged(profile, oldName, oldDesc, oldAutoConnect, onlyNameChanged, oldProfile);
    }

    private ConnectProfile findOldProfile(IConnectionProfile profile) {
        ProfileManager pManager = ProfileManager.getInstance();
        IConnectionProfile[] profiles = pManager.getProfiles();
        Iterator pIter = this._profiles.iterator();
        ConnectProfile oldProfile = null;
        while (pIter.hasNext()) {
            ConnectProfile p = (ConnectProfile)pIter.next();
            boolean isFound = false;
            for (int i = 0; i < profiles.length; ++i) {
                if (!p.equals(new ConnectProfile(profiles[i]))) continue;
                isFound = true;
                break;
            }
            if (isFound) continue;
            oldProfile = p;
            break;
        }
        if (oldProfile == null) {
            return null;
        }
        this._profiles.remove(oldProfile);
        this._profiles.add(new ConnectProfile(profile));
        return oldProfile;
    }

    public boolean okToClose(ConnectEvent event) {
        boolean okToClose = this._dmpConnectManager.fireOkToClose(event);
        return okToClose;
    }

    public void opened(ConnectEvent event) {
        IConnectionProfile profile = event.getConnectionProfile();
        String dbName = ProfileUtil.getProfileDatabaseName(profile.getName());
        DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(profile.getName(), dbName);
        try {
            if (databaseIdentifier.getDBname() != null && !databaseIdentifier.getDBname().trim().equals("")) {
                EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier);
            }
            try {
                this._dmpConnectManager.fireProfileConnected(event);
            }
            catch (Exception e) {}
        }
        catch (Exception ce) {
            EditorCorePlugin.getDefault().log(ce);
        }
    }

    public void closed(ConnectEvent event) {
        try {
            this._dmpConnectManager.fireCloseConnection(event);
        }
        catch (Exception e) {
            EditorCorePlugin.getDefault().log(e);
        }
        IConnectionProfile profile = event.getConnectionProfile();
        if (EditorCorePlugin.getDefault() == null) {
            return;
        }
        EditorCorePlugin.getControlConnectionManager().fireDispose(profile.getName());
        IControlConnection[] cs = EditorCorePlugin.getControlConnectionManager().getControlConnections(profile.getName());
        if (cs != null && cs.length > 0) {
            for (int i = 0; i < cs.length; ++i) {
                cs[i].disconnect(true);
            }
        }
    }

    public void aboutToClose(ConnectEvent event) {
        try {
            this._dmpConnectManager.fireAboutToClose(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void modified(ConnectEvent event) {
    }
}

