/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.model;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugElement;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugTarget;
import org.eclipse.datatools.sqltools.debugger.model.SPThread;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public abstract class SPStackFrame
extends SPDebugElement
implements IStackFrame,
IStep {
    private SPThread _thread;
    private int _lineNumber;
    private int _charStart = -1;
    private int _charEnd = -1;
    private ProcIdentifier _procId;
    private boolean _needRefreshVariables = true;
    private boolean _needRefreshTables = true;
    private Map _localVariables = null;
    private int _depth;
    private String _paramStr;

    public SPStackFrame(SPDebugTarget target, SPThread thread, int depth) {
        super(target);
        this._thread = thread;
        this._depth = depth;
    }

    public IThread getThread() {
        return this._thread;
    }

    public int getLineNumber() throws DebugException {
        return this._lineNumber;
    }

    public void setLineNumber(int line) {
        this._lineNumber = line;
    }

    public int getCharStart() throws DebugException {
        return this._charStart;
    }

    public void setCharStart(int cs) {
        this._charStart = cs;
    }

    public int getCharEnd() throws DebugException {
        return this._charEnd;
    }

    public void setCharEnd(int ce) {
        this._charEnd = ce;
    }

    public ProcIdentifier getProcIdentifier() {
        return this._procId;
    }

    public void setProcIdentifier(ProcIdentifier id) {
        this._procId = id;
    }

    public void setDepth(int depthNew) {
        this._depth = depthNew;
    }

    public int getDepth() {
        return this._depth;
    }

    public abstract Connection getConnection();

    protected abstract Map updateLocalVariables(Map var1) throws DebugException;

    public void internalSetRefreshVariable() {
        this._needRefreshVariables = true;
    }

    public void internalSetRefreshTables(boolean referesh) {
        this._needRefreshTables = referesh;
    }

    public boolean isNeedRefreshTables() {
        return this._needRefreshTables;
    }

    protected void refreshLocalVariables() throws DebugException {
        if (this._localVariables == null) {
            this._localVariables = new HashMap();
            this._needRefreshVariables = true;
        }
        if (this._needRefreshVariables) {
            this._localVariables = this.updateLocalVariables(this._localVariables);
            this._needRefreshVariables = false;
        }
    }

    public IVariable[] getVariables() throws DebugException {
        this.refreshLocalVariables();
        return this._localVariables.values().toArray(new IVariable[this._localVariables.size()]);
    }

    public boolean hasVariables() throws DebugException {
        this.refreshLocalVariables();
        return !this._localVariables.isEmpty();
    }

    public String getName() throws DebugException {
        return this.getProcIdentifier().getProcName();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        try {
            return this.exists() && this.isTopStackFrame() && this.getThread().canStepInto();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepOver() {
        try {
            return this.exists() && this.getThread().canStepOver() && this.isTopStackFrame();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepReturn() {
        try {
            if (!(this.exists() && this.getThread().canStepReturn() && this.isTopStackFrame())) {
                return false;
            }
            return !((Object)((Object)this)).equals(((SPThread)this.getThread()).getBottomStackFrame());
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        this.internalSetRefreshTables(true);
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.getThread().stepOver();
        }
    }

    protected boolean isTopStackFrame() throws DebugException {
        IStackFrame frame = this.getThread().getTopStackFrame();
        return frame != null && frame.equals((Object)this);
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.getThread().stepReturn();
        }
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    protected boolean exists() throws DebugException {
        return this.isSuspended() && ((SPThread)this.getThread()).getStackFramesAsList().indexOf((Object)this) != -1;
    }

    public boolean canTerminate() {
        boolean exists = false;
        try {
            exists = this.exists();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return exists && this.getThread().canTerminate() || this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.getThread().canTerminate()) {
            this.getThread().terminate();
        } else {
            this.getDebugTarget().terminate();
        }
    }

    public abstract int getDebuggeeSpid();

    public void setParamStr(String str) {
        this._paramStr = str;
    }

    public String getParamStr() {
        return this._paramStr;
    }
}

