/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.core;

import java.sql.Connection;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.core.ColumnDataAccessorExtension;
import org.eclipse.datatools.sqltools.data.internal.core.Messages;
import org.eclipse.datatools.sqltools.data.internal.core.common.DefaultColumnDataAccessor;
import org.eclipse.datatools.sqltools.data.internal.core.common.IColumnDataAccessor;
import org.osgi.framework.BundleContext;

public class DataCorePlugin
extends Plugin {
    private static DataCorePlugin plugin;
    private ResourceBundle resourceBundle;
    private static final String SQ = "'";
    private static final String SQ2 = "`";
    private static final String DQ = "\"";
    public static final String ID = "org.eclipse.datatools.sqltools.data.core";
    protected Vector columnDataAccessors;

    public DataCorePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.datatools.sqltools.data.internal.core");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this.listColumnDataAccessors();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static DataCorePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = DataCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void writeLog(int severity, int code, String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        this.getLog().log((IStatus)new Status(severity, this.getBundle().getSymbolicName(), code, message, exception));
    }

    public static String getQualifiedTableName(Table table) {
        Database db = table.getSchema().getCatalog() != null ? table.getSchema().getCatalog().getDatabase() : table.getSchema().getDatabase();
        return String.valueOf(DataCorePlugin.quoteIdentifier(db, table.getSchema().getName())) + "." + DataCorePlugin.quoteIdentifier(db, table.getName());
    }

    public static String getQualifiedUDTName(UserDefinedType udt) {
        Database db = udt.getSchema().getCatalog() != null ? udt.getSchema().getCatalog().getDatabase() : udt.getSchema().getDatabase();
        return String.valueOf(DataCorePlugin.quoteIdentifier(db, udt.getSchema().getName())) + "." + DataCorePlugin.quoteIdentifier(db, udt.getName());
    }

    public static String quoteIdentifier(Database db, String s) {
        String delim = DQ;
        DatabaseDefinitionRegistry dbDefRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        DatabaseDefinition dbDef = dbDefRegistry.getDefinition(db);
        delim = dbDef.getIdentifierQuoteString();
        if (!SQ.equals(delim) && !delim.equals(SQ2)) {
            delim = DQ;
        }
        return String.valueOf(delim) + DataCorePlugin.doubleStringDelim(s, delim) + delim;
    }

    public static String quoteIdentifier(Connection conn, String s) {
        try {
            String delim = conn.getMetaData().getIdentifierQuoteString().trim();
            return String.valueOf(delim) + DataCorePlugin.doubleStringDelim(s, delim) + delim;
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (message == null) {
                message = "";
            }
            DataCorePlugin.getDefault().writeLog(4, 0, message, ex);
            return s;
        }
    }

    public static String doubleStringDelim(String s, String delim) {
        if (delim == null || delim.length() == 0) {
            return s;
        }
        int i = s.indexOf(delim);
        if (i != -1) {
            StringBuffer sb = new StringBuffer(s);
            while (i != -1) {
                sb = sb.insert(i, delim);
                int j = i + 2 * delim.length();
                i = sb.toString().indexOf(delim, j);
            }
            return sb.toString();
        }
        return s;
    }

    protected void listColumnDataAccessors() {
        this.columnDataAccessors = new Vector();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.datatools.sqltools.data.core.columnDataAccessors");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                this.columnDataAccessors.add(new ColumnDataAccessorExtension(elements[j]));
                ++j;
            }
            ++i;
        }
    }

    public IColumnDataAccessor newColumnDataAccessor(Column sqlCol) throws Exception {
        IColumnDataAccessor acc;
        DataType type = sqlCol.getDataType();
        if (type == null) {
            String columnName = sqlCol.getName();
            String message = Messages.getString("DataCorePlugin.Unsupported", new Object[]{columnName});
            Status status = new Status(4, ID, 1, message, null);
            throw new CoreException((IStatus)status);
        }
        try {
            Database db = sqlCol.getTable().getSchema().getCatalog() != null ? sqlCol.getTable().getSchema().getCatalog().getDatabase() : sqlCol.getTable().getSchema().getDatabase();
            String vendor = db.getVendor();
            String version = db.getVersion();
            String dataType = sqlCol.getDataType().getName();
            ColumnDataAccessorExtension element = null;
            Iterator it = this.columnDataAccessors.iterator();
            while (it.hasNext()) {
                ColumnDataAccessorExtension curElement = (ColumnDataAccessorExtension)it.next();
                if (!curElement.matches(vendor, version, dataType) || element != null && curElement.getScore() <= element.getScore()) continue;
                element = curElement;
                curElement.getScore();
            }
            acc = element != null ? element.createInstance() : new DefaultColumnDataAccessor();
        }
        catch (CoreException ex) {
            this.writeLog(4, 0, ex.getMessage(), ex);
            acc = new DefaultColumnDataAccessor();
        }
        acc.initialize(sqlCol);
        return acc;
    }
}

