/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.resource;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.sqltools.common.ui.resource.CreateFolderAction;
import org.eclipse.datatools.sqltools.common.ui.resource.CreateProjectAction;
import org.eclipse.datatools.sqltools.common.ui.resource.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.misc.ContainerContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class ContainerSelectionGroup
extends Composite {
    private Listener _listener;
    private boolean _allowNewContainerName = true;
    private boolean _showClosedProjects = true;
    private IContainer _selectedContainer;
    private Text _containerNameField;
    TreeViewer _treeViewer;
    private Menu _treeMenu;
    private MenuItem _menuItem;
    private Button _btnCreateProject;
    private static final String DEFAULT_MSG_NEW_ALLOWED = IDEWorkbenchMessages.ContainerGroup_message;
    private static final String DEFAULT_MSG_SELECT_ONLY = IDEWorkbenchMessages.ContainerGroup_selectFolder;
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;

    public ContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName) {
        this(parent, listener, allowNewContainerName, null);
    }

    public ContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message) {
        this(parent, listener, allowNewContainerName, message, true);
    }

    public ContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, boolean showClosedProjects) {
        this(parent, listener, allowNewContainerName, message, showClosedProjects, 300);
    }

    public ContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, boolean showClosedProjects, int heightHint) {
        super(parent, 0);
        this._listener = listener;
        this._allowNewContainerName = allowNewContainerName;
        this._showClosedProjects = showClosedProjects;
        if (message != null) {
            this.createContents(message, heightHint);
        } else if (allowNewContainerName) {
            this.createContents(DEFAULT_MSG_NEW_ALLOWED, heightHint);
        } else {
            this.createContents(DEFAULT_MSG_SELECT_ONLY, heightHint);
        }
    }

    public void containerSelectionChanged(IContainer container) {
        this._selectedContainer = container;
        if (this._allowNewContainerName) {
            if (container == null) {
                this._containerNameField.setText("");
            } else {
                this._containerNameField.setText(container.getFullPath().makeRelative().toString());
            }
        }
        if (this._listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this._listener.handleEvent(changeEvent);
        }
    }

    public void createContents(String message) {
        this.createContents(message, 300);
    }

    public void createContents(String message, int heightHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 64);
        label.setText(message);
        label.setFont(this.getFont());
        if (this._allowNewContainerName) {
            Composite _cmps = new Composite((Composite)this, 0);
            _cmps.setLayoutData((Object)new GridData(784));
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 0;
            _cmps.setLayout((Layout)gridLayout);
            this._containerNameField = new Text(_cmps, 2052);
            GridData gridData = new GridData(768);
            this._containerNameField.setLayoutData((Object)gridData);
            this._containerNameField.addListener(24, this._listener);
            this._containerNameField.setFont(this.getFont());
            this._btnCreateProject = new Button(_cmps, 0);
            this._btnCreateProject.setLayoutData((Object)new GridData(128));
            this._btnCreateProject.setText(Messages.ContainerSelectionGroup_createProjectAction_label);
            this._btnCreateProject.addSelectionListener((SelectionListener)new btnCreateProjectSelectionListener());
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    protected void createTreeViewer(int heightHint) {
        DrillDownComposite drillDown = new DrillDownComposite((Composite)this, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 320;
        spec.heightHint = heightHint;
        drillDown.setLayoutData((Object)spec);
        this._treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this._treeViewer);
        ContainerContentProvider cp = new ContainerContentProvider();
        cp.showClosedProjects(this._showClosedProjects);
        this._treeViewer.setContentProvider((IContentProvider)cp);
        this._treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this._treeViewer.setSorter(new ViewerSorter());
        this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ContainerSelectionGroup.this.containerSelectionChanged((IContainer)selection.getFirstElement());
            }
        });
        this._treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (ContainerSelectionGroup.this._treeViewer.getExpandedState(item)) {
                        ContainerSelectionGroup.this._treeViewer.collapseToLevel(item, 1);
                    } else {
                        ContainerSelectionGroup.this._treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this._treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        MenuManager mgr = new MenuManager();
        mgr.add((IAction)new CreateProjectAction(this._treeViewer));
        CreateFolderAction createFolderAction = new CreateFolderAction(this._treeViewer);
        this._treeViewer.addSelectionChangedListener((ISelectionChangedListener)createFolderAction);
        mgr.add((IAction)createFolderAction);
        Menu menu = mgr.createContextMenu((Control)this._treeViewer.getTree());
        this._treeViewer.getTree().setMenu(menu);
        this._treeViewer.getTree().setFocus();
    }

    public IPath getContainerFullPath() {
        if (this._allowNewContainerName) {
            String pathName = this._containerNameField.getText();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            return new Path(pathName).makeAbsolute();
        }
        if (this._selectedContainer == null) {
            return null;
        }
        return this._selectedContainer.getFullPath();
    }

    public void setInitialFocus() {
        if (this._allowNewContainerName) {
            this._containerNameField.setFocus();
        } else {
            this._treeViewer.getTree().setFocus();
        }
        this._treeViewer.getTree().setFocus();
    }

    public void setSelectedContainer(IContainer container) {
        this._selectedContainer = container;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        for (IContainer parent = container.getParent(); parent != null; parent = parent.getParent()) {
            itemsToExpand.add(0, parent);
        }
        this._treeViewer.setExpandedElements(itemsToExpand.toArray());
        this._treeViewer.setSelection((ISelection)new StructuredSelection((Object)container), true);
    }

    protected void do_menuItem_widgetSelected() {
    }

    protected void do_btnCreateProject_widgetSelected() {
        CreateProjectAction action = new CreateProjectAction(this._treeViewer);
        action.run();
    }

    private class MenuItemSelectionListener
    extends SelectionAdapter {
        private MenuItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ContainerSelectionGroup.this.do_menuItem_widgetSelected();
        }
    }

    private class btnCreateProjectSelectionListener
    extends SelectionAdapter {
        private btnCreateProjectSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ContainerSelectionGroup.this.do_btnCreateProject_widgetSelected();
        }
    }
}

