/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.preferences;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.common.ui.internal.Activator;
import org.eclipse.datatools.sqltools.common.ui.internal.Messages;
import org.eclipse.datatools.sqltools.common.ui.preferences.IDataServerLaunchPreferenceSection;
import org.eclipse.datatools.sqltools.common.ui.preferences.IDataServerPreferenceSection;
import org.eclipse.datatools.sqltools.common.ui.preferences.PreferencesRegistry;
import org.eclipse.datatools.sqltools.common.ui.util.SWTUtils;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractDBPreferenceFieldPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private TabFolder _folder;
    private Map _sections = new HashMap();
    private boolean _useFieldEditor = false;

    public AbstractDBPreferenceFieldPage() {
        this(false);
    }

    public AbstractDBPreferenceFieldPage(boolean useFieldEditor) {
        super(1);
        this._useFieldEditor = useFieldEditor;
    }

    public AbstractDBPreferenceFieldPage(int style) {
        super(style);
    }

    public AbstractDBPreferenceFieldPage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
    }

    public AbstractDBPreferenceFieldPage(String title, int style) {
        super(title, style);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        Iterator iter = this._sections.values().iterator();
        while (iter.hasNext()) {
            IDataServerPreferenceSection accessor = (IDataServerPreferenceSection)iter.next();
            accessor.saveToPreferenceStore(this.getPreferenceStore());
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new TabFolderContainerLayout());
        GridData gridData = new GridData(1808);
        comp.setLayoutData((Object)gridData);
        if (this._useFieldEditor) {
            super.createContents(comp);
        }
        this._folder = null;
        Map sections = PreferencesRegistry.INSTANCE.getPageSections(this.getPreferencePageId());
        Iterator iter = sections.keySet().iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            String name = id;
            if (name == null) {
                Activator.getDefault().log(NLS.bind((String)Messages.AbstractDBPreferenceFieldPage_nodb, (Object[])new Object[]{id}));
                continue;
            }
            IDataServerPreferenceSection section = (IDataServerPreferenceSection)sections.get(id);
            if (section == null) continue;
            if (this._folder == null) {
                this._folder = new TabFolder(comp, 0);
                GridData gd = new GridData(1808);
                this._folder.setLayoutData((Object)gd);
                this._folder.setLayout((Layout)new GridLayout());
            }
            TabItem tabItem = new TabItem(this._folder, 0);
            section.createSectionComposite((Composite)this._folder);
            tabItem.setControl((Control)section.getSectionComposite());
            tabItem.setText(name);
            if (section instanceof IDataServerLaunchPreferenceSection) {
                ((IDataServerLaunchPreferenceSection)section).setMode(2);
            }
            this._sections.put(name, section);
        }
        if (this._folder != null) {
            this._folder.layout();
        }
        comp.pack();
        this.initializeValues();
        SWTUtils.listenModify(comp, this, null);
        return comp;
    }

    protected void initializeValues() {
        Iterator iter = this._sections.values().iterator();
        while (iter.hasNext()) {
            IDataServerPreferenceSection accessor = (IDataServerPreferenceSection)iter.next();
            accessor.loadFromPreferenceStore(this.getPreferenceStore());
        }
    }

    protected void performDefaults() {
        if (this._folder == null) {
            return;
        }
        TabItem currentItem = this._folder.getItem(this._folder.getSelectionIndex());
        IDataServerPreferenceSection accessor = (IDataServerPreferenceSection)this._sections.get(currentItem.getText());
        accessor.loadDefaultPreference(this.getPreferenceStore());
        super.performDefaults();
    }

    protected void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    protected IStatus findMostSevere() {
        int i;
        IStatus[] statuses = this.getSevereFirstStatus();
        if (statuses == null || statuses.length == 0) {
            return new Status(0, "org.eclipse.datatools.sqltools.common.ui", 0, "", null);
        }
        for (i = 0; i < statuses.length; ++i) {
            if (statuses[i] == null || !statuses[i].matches(4)) continue;
            return statuses[i];
        }
        for (i = 0; i < statuses.length; ++i) {
            if (statuses[i] == null || !statuses[i].matches(1)) continue;
            return statuses[i];
        }
        for (i = 0; i < statuses.length; ++i) {
            if (statuses[i] == null || !statuses[i].matches(2)) continue;
            return statuses[i];
        }
        return new Status(0, "org.eclipse.datatools.sqltools.common.ui", 0, "", null);
    }

    public void handleEvent(Event event) {
        IStatus status = this.findMostSevere();
        this.applyToStatusLine(status);
        this.setValid(status.getSeverity() != 4 && status.getSeverity() != 1);
    }

    protected IStatus[] getSevereFirstStatus() {
        IStatus[] status = new IStatus[this._sections.size()];
        Iterator iter = this._sections.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            IDataServerPreferenceSection section = (IDataServerPreferenceSection)iter.next();
            status[i++] = section.getStatus();
        }
        return status;
    }

    protected void createFieldEditors() {
    }

    public abstract String getPreferencePageId();

    private class TabFolderContainerLayout
    extends Layout {
        Point preferredSize = null;

        private TabFolderContainerLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = 0;
            int y = 0;
            Control[] children = composite.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Point size = children[i].computeSize(-1, -1, flushCache);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
            }
            Point minSize = this.getMinSize();
            x = Math.max(x, minSize.x);
            y = Math.max(y, minSize.y);
            x = wHint != -1 ? Math.max(x, wHint) : Math.min(x, this.getMaxSize().x);
            y = hHint != -1 ? Math.max(y, hHint) : Math.min(y, this.getMaxSize().y);
            this.preferredSize = new Point(x, y);
            return this.preferredSize;
        }

        private Point getMinSize() {
            return new Point(200, 200);
        }

        private Point getMaxSize() {
            return new Point(500, 400);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].setBounds(rect);
            }
        }
    }
}

