/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.deltaddl;

import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.enablement.ase.ISybaseASEDdlConstants;
import org.eclipse.datatools.enablement.ase.SybaseASESQLUtil;
import org.eclipse.datatools.enablement.ase.ddl.SybaseASEDdlBuilder;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEColumn;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASERule;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilder;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.AbstractDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASEColumnDeltaDdlGenProvider
extends AbstractDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
ISybaseASEDdlConstants {
    public void analyze(SQLObject element, Map changeMap, Map modificationRecords) {
        super.analyze(element, changeMap, modificationRecords);
        List records = (List)modificationRecords.get(element);
        if (records == null) {
            return;
        }
        boolean isGenExpChanged = false;
        boolean isMatChanged = false;
        int matChangedRcIndex = -1;
        int i = records.size() - 1;
        while (i >= 0) {
            SybaseDeltaDdlGeneration.FeatureChangeRecord record = (SybaseDeltaDdlGeneration.FeatureChangeRecord)records.get(i);
            EStructuralFeature f = record.feature;
            if (f == SQLTablesPackage.eINSTANCE.getColumn_GenerateExpression()) {
                isGenExpChanged = true;
            }
            if (f == SybaseasesqlmodelPackage.eINSTANCE.getSybaseASEColumn_Materialized()) {
                isMatChanged = true;
                matChangedRcIndex = i;
            }
            --i;
        }
        if (isGenExpChanged && isMatChanged) {
            records.remove(matChangedRcIndex);
        }
    }

    protected void getModificationResult(SQLObject e, EStructuralFeature f, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        SybaseDdlBuilder builder = SybaseASEDdlBuilder.getInstance();
        SybaseASEColumn column = (SybaseASEColumn)e;
        if (f.getFeatureID() == 1) {
            if (!oldValue.toString().equals(newValue.toString())) {
                String tableName = column.getTable().getName();
                tableName = SQLDevToolsUtil.quoteWhenNecessary((String)tableName, (DatabaseIdentifier)((DatabaseIdentifier)this.getParameter()));
                String columnOldName = SQLUtil.quote((String)(String.valueOf(tableName) + "." + oldValue), (String)"'");
                String columnNewName = newValue.toString();
                columnNewName = SQLDevToolsUtil.quoteWhenNecessary((String)columnNewName, (DatabaseIdentifier)((DatabaseIdentifier)this.getParameter()));
                StringBuffer sb = new StringBuffer(256);
                sb.append("EXEC").append(" ").append("sp_rename").append(" ").append(columnOldName).append(",").append(" ").append(columnNewName);
                Schema creator = column.getTable().getSchema();
                String setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
                if (!setUserStr.equals("")) {
                    script.addAlterTableRenameColumnStatements(setUserStr);
                }
                script.addAlterTableRenameColumnStatements(sb.toString());
                String setUserDbo = SybaseASESQLUtil.getSetUserDBOStatement(creator);
                if (!setUserDbo.equals("")) {
                    script.addAlterTableRenameColumnStatements(setUserDbo);
                }
            }
        } else if (f.getFeatureID() == 13) {
            if (((Boolean)newValue).booleanValue() != ((Boolean)oldValue).booleanValue()) {
                String nullClause;
                StringBuffer stmt = new StringBuffer();
                String string = nullClause = column.isNullable() ? "NULL" : "NOT NULL";
                if (!column.isComputedColumn()) {
                    stmt.append("ALTER").append(" ").append("TABLE").append(" ").append(builder.getName((ENamedElement)column.getTable(), quoteIdentifiers, qualifyNames)).append(NEWLINE).append(" ").append("MODIFY").append(" ").append(this.getColumnName((Column)column, quoteIdentifiers)).append(" ").append(this.getDataTypeString((TypedElement)column, column.getTable().getSchema())).append(" ").append(nullClause);
                    script.addAlterTableColumnStatements(stmt.toString());
                } else {
                    stmt.append("ALTER").append(" ").append("TABLE").append(" ").append(builder.getName((ENamedElement)column.getTable(), quoteIdentifiers, qualifyNames)).append(NEWLINE).append(" ").append("MODIFY").append(" ").append(this.getColumnName((Column)column, quoteIdentifiers)).append(" ").append(nullClause);
                    script.addAlterTableColumnStatements(stmt.toString());
                }
            }
        } else if (f.getFeatureID() == 7 || f.getFeatureID() == 8) {
            String nullClause;
            StringBuffer stmt = new StringBuffer();
            String string = nullClause = column.isNullable() ? "NULL" : "NOT NULL";
            if (!this.isFloatTypeDDLNeeded((DataType)oldValue, (DataType)newValue)) {
                return;
            }
            stmt.append("ALTER").append(" ").append("TABLE").append(" ").append(builder.getName((ENamedElement)column.getTable(), quoteIdentifiers, qualifyNames)).append(NEWLINE).append(" ").append("MODIFY").append(" ").append(this.getColumnName((Column)column, quoteIdentifiers)).append(" ").append(this.getDataTypeString((TypedElement)column, column.getTable().getSchema())).append(" ").append(nullClause);
            script.addAlterTableModifyColumnTypeStatements(stmt.toString());
        } else if (f.getFeatureID() == 14) {
            StringBuffer stmt = null;
            stmt = new StringBuffer();
            stmt.append("ALTER").append(" ").append("TABLE").append(" ").append(builder.getName((ENamedElement)column.getTable(), quoteIdentifiers, qualifyNames)).append(NEWLINE).append(" ").append("REPLACE").append(" ").append(this.getColumnName((Column)column, quoteIdentifiers)).append(" ").append("DEFAULT").append(" ").append(newValue);
            script.addAlterTableColumnStatements(stmt.toString());
        } else if (f.getFeatureID() == 18) {
            StringBuffer unBindStmt = new StringBuffer();
            unBindStmt.append("EXEC").append(" ").append("sp_unbindefault").append(" ").append(SQLUtil.quote((String)(String.valueOf(column.getTable().getName()) + "." + column.getName()), (String)"'"));
            if (newValue == null) {
                script.addAlterTableColumnStatements(unBindStmt.toString());
            } else if (oldValue == null) {
                StringBuffer bindStmt = new StringBuffer();
                bindStmt.append("EXEC").append(" ").append("sp_bindefault").append(" ").append(SQLUtil.quote((String)SybaseASEDdlBuilder.getInstance().getName((ENamedElement)column.getBoundDefault(), false, true), (String)"'")).append(",").append(SQLUtil.quote((String)(String.valueOf(column.getTable().getName()) + "." + column.getName()), (String)"'"));
                script.addAlterTableColumnStatements(bindStmt.toString());
            } else {
                StringBuffer bindStmt = new StringBuffer();
                bindStmt.append("EXEC").append(" ").append("sp_bindefault").append(" ").append(SQLUtil.quote((String)SybaseASEDdlBuilder.getInstance().getName((ENamedElement)column.getBoundDefault(), false, true), (String)"'")).append(",").append(SQLUtil.quote((String)(String.valueOf(column.getTable().getName()) + "." + column.getName()), (String)"'"));
                script.addAlterTableColumnStatements(unBindStmt.toString());
                script.addAlterTableColumnStatements(bindStmt.toString());
            }
        } else if (f.getFeatureID() == 11) {
            String matClause = column.isMaterialized() ? "MATERIALIZED" : "NOT MATERIALIZED";
            StringBuffer stmt = new StringBuffer();
            stmt.append("ALTER").append(" ").append("TABLE").append(" ").append(builder.getName((ENamedElement)column.getTable(), quoteIdentifiers, qualifyNames)).append(NEWLINE).append(" ").append("MODIFY").append(" ").append(this.getColumnName((Column)column, quoteIdentifiers)).append(" ").append("AS").append(" ").append(((ValueExpression)newValue).getSQL()).append(" ").append(matClause);
            script.addAlterTableColumnStatements(stmt.toString());
        } else if (f.getFeatureID() == 20) {
            StringBuffer stmt = new StringBuffer();
            String matClause = column.isMaterialized() ? "MATERIALIZED" : "NOT MATERIALIZED";
            stmt.append("ALTER").append(" ").append("TABLE").append(" ").append(builder.getName((ENamedElement)column.getTable(), quoteIdentifiers, qualifyNames)).append(NEWLINE).append(" ").append("MODIFY").append(" ").append(this.getColumnName((Column)column, quoteIdentifiers)).append(" ").append(matClause);
            script.addAlterTableColumnStatements(stmt.toString());
        } else if (f.getFeatureID() == 19) {
            StringBuffer unBindStmt = new StringBuffer();
            unBindStmt.append("EXEC").append(" ").append("sp_unbindrule").append(" ").append(SQLUtil.quote((String)(String.valueOf(column.getTable().getName()) + "." + column.getName()), (String)"'")).append(",").append("NULL").append(",").append("'").append("all").append("'");
            if (newValue != null) {
                StringBuffer bindStmt = new StringBuffer();
                bindStmt.append("EXEC").append(" ").append("sp_bindrule").append(" ").append(SQLUtil.quote((String)SybaseASEDdlBuilder.getInstance().getName((ENamedElement)((SybaseASERule)newValue), false, true), (String)"'")).append(",").append(SQLUtil.quote((String)(String.valueOf(column.getTable().getName()) + "." + column.getName()), (String)"'"));
                if (oldValue == null) {
                    script.addAlterOtherStatements(bindStmt.toString());
                } else {
                    script.addAlterTableColumnStatements(unBindStmt.toString());
                    script.addAlterTableColumnStatements(bindStmt.toString());
                }
            } else {
                script.addAlterTableColumnStatements(unBindStmt.toString());
            }
        }
    }

    protected void addCreateStatement(SybaseDdlScript script, String statement) {
        script.addAlterTableColumnStatements(statement);
    }

    protected void addDropStatement(SybaseDdlScript script, String statement) {
        script.addAlterTableDropColumnStatements(statement);
    }

    private String getColumnName(Column column, boolean quoted_id) {
        if (quoted_id) {
            return "\"" + column.getName() + "\"";
        }
        return column.getName();
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema) {
        SQLDataType containedType = typedElement.getContainedType();
        if (containedType != null) {
            EObject root;
            if (containedType instanceof PredefinedDataType && (root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)typedElement)) instanceof Database) {
                DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
                return def.getPredefinedDataTypeFormattedName((PredefinedDataType)containedType);
            }
        } else {
            UserDefinedType referencedType = typedElement.getReferencedType();
            if (referencedType != null) {
                String udtName = referencedType.getSchema() != schema ? this.getName(referencedType, false, false) : referencedType.getName();
                udtName = SQLUtil.quote((String)udtName, (String)"\"");
                return udtName;
            }
        }
        return null;
    }

    private boolean isFloatTypeDDLNeeded(DataType oldValue, DataType newValue) {
        if (oldValue == null || newValue == null) {
            return true;
        }
        if (oldValue.getName().equalsIgnoreCase("float") && newValue.getName().equalsIgnoreCase("float")) {
            EStructuralFeature feature = oldValue.eClass().getEStructuralFeature("precision");
            Integer oldValueLength = (Integer)oldValue.eGet(feature);
            feature = newValue.eClass().getEStructuralFeature("precision");
            Integer newValueLength = (Integer)newValue.eGet(feature);
            if (oldValueLength < 16 && newValueLength < 16 || oldValueLength >= 16 && newValueLength >= 16) {
                return false;
            }
        }
        return true;
    }
}

