/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseEvent;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ASADDLGeneratorWrapper;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.CustomizedCopier;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.PrivilegesUtil;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseAuthorizedObject;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseBaseTable;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasePrivilege;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseRoutine;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasesqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.impl.SQLSchemaFactoryImpl;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugModelUtil;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ddl.DDLGeneratorWrapper;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ddl.IDDLProvider;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.AbstractSchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectImmutableModel;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ProceduralObjectEditModel
extends AbstractSchemaObjectEditModel {
    protected static final String LINE = System.getProperty("line.separator");
    protected ChangeDescription[] _privilegeChangeSummary;
    private String _terminator = ";";
    private ProcIdentifier _procIdentifier;
    private boolean _reservePrivileges = false;
    ChangeDescription[] _authIDsChangeDescription;
    ChangeRecorder[] _authIDsChangeRecoreder;

    public ProceduralObjectEditModel(ISchemaObjectImmutableModel model, DatabaseIdentifier databaseIdentifier) {
        super(model, databaseIdentifier);
        this._procIdentifier = SQLDevToolsUtil.getProcIdentifier((DatabaseIdentifier)databaseIdentifier, (SQLObject)this.getMainSQLObject());
        this._dGeneratorWrapper = new ASADDLGeneratorWrapper(this._dIdentifier);
    }

    protected EcoreUtil.Copier createCopier() {
        return new CustomizedCopier();
    }

    protected void createAndAttachNecessaryTempObjects() {
        SQLObject mainObject = this.getSchemaObjectImmutableModel().getMainSQLObject();
        if (mainObject instanceof SybaseRoutine) {
            Schema schema = SQLSchemaFactoryImpl.eINSTANCE.createSchema();
            Schema oldSchema = ((Routine)mainObject).getSchema();
            schema.setName(oldSchema.getName());
            ((Routine)this.getCopier().get((Object)mainObject)).setSchema(schema);
            Catalog catalog = SQLSchemaFactoryImpl.eINSTANCE.createCatalog();
            Catalog oldCatalog = oldSchema.getCatalog();
            Database db = SQLSchemaFactoryImpl.eINSTANCE.createDatabase();
            Database oldDb = oldCatalog.getDatabase();
            catalog.setName(oldCatalog.getName());
            schema.setCatalog(catalog);
            db.setName(oldDb.getName());
            db.setVendor(oldDb.getVendor());
            db.setVersion(oldDb.getVersion());
            catalog.setDatabase(db);
            EList privileges = ((SybaseAuthorizedObject)this._mainObject).getPrivileges();
            for (SybasePrivilege p : privileges) {
                AuthorizationIdentifier grantee = p.getGrantee();
                grantee.getReceivedPrivilege().add((Object)p);
            }
        } else if (mainObject instanceof Trigger) {
            Schema schema = SQLSchemaFactoryImpl.eINSTANCE.createSchema();
            Schema oldSchema = ((Trigger)mainObject).getSchema();
            schema.setName(oldSchema.getName());
            ((Trigger)this.getCopier().get((Object)mainObject)).setSchema(schema);
            Catalog catalog = SQLSchemaFactoryImpl.eINSTANCE.createCatalog();
            Catalog oldCatalog = oldSchema.getCatalog();
            Database db = SQLSchemaFactoryImpl.eINSTANCE.createDatabase();
            Database oldDb = oldCatalog.getDatabase();
            catalog.setName(oldCatalog.getName());
            schema.setCatalog(catalog);
            db.setName(oldDb.getName());
            db.setVendor(oldDb.getVendor());
            db.setVersion(oldDb.getVersion());
            catalog.setDatabase(db);
            Table oldTable = ((Trigger)mainObject).getSubjectTable();
            SybaseBaseTable table = SybasesqlmodelFactory.eINSTANCE.createSybaseBaseTable();
            table.setName(oldTable.getName());
            Schema oldTableSchema = oldTable.getSchema();
            if (oldTableSchema != null && oldTableSchema != oldSchema) {
                Schema tableSchema = SQLSchemaFactoryImpl.eINSTANCE.createSchema();
                tableSchema.setName(oldTableSchema.getName());
                tableSchema.setCatalog(catalog);
                table.setSchema(tableSchema);
            } else {
                table.setSchema(schema);
            }
            ((Trigger)this._mainObject).setSubjectTable((Table)table);
        } else if (mainObject instanceof SybaseASABaseEvent) {
            SybaseASABaseEvent event = (SybaseASABaseEvent)mainObject;
            Schema schema = SQLSchemaFactoryImpl.eINSTANCE.createSchema();
            Schema oldSchema = event.getEventCreator();
            schema.setName(oldSchema.getName());
            ((SybaseASABaseEvent)this.getCopier().get((Object)mainObject)).setEventCreator(schema);
            Catalog catalog = SQLSchemaFactoryImpl.eINSTANCE.createCatalog();
            Catalog oldCatalog = oldSchema.getCatalog();
            catalog.setName(oldCatalog.getName());
            schema.setCatalog(catalog);
            Database db = SQLSchemaFactoryImpl.eINSTANCE.createDatabase();
            Database oldDb = oldCatalog.getDatabase();
            db.setName(oldDb.getName());
            db.setVendor(oldDb.getVendor());
            db.setVersion(oldDb.getVersion());
            catalog.setDatabase(db);
            ((SybaseASABaseEvent)this.getCopier().get((Object)mainObject)).setDatabase(db);
        }
    }

    protected String getSQLDelimiter() {
        return this._terminator;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IDDLProvider.class)) {
            return new IDDLProvider(){

                public String getDDL() {
                    ASADDLGeneratorWrapper wrapper = new ASADDLGeneratorWrapper(ProceduralObjectEditModel.this._dIdentifier);
                    String[] ddl = null;
                    if (wrapper != null) {
                        ArrayList<SQLObject> objects = new ArrayList<SQLObject>();
                        objects.add(ProceduralObjectEditModel.this._mainObject);
                        Collection authIds = (Collection)ProceduralObjectEditModel.this._additionalObjects.get("authids");
                        if (authIds != null) {
                            for (AuthorizationIdentifier authId : authIds) {
                                List privs = PrivilegesUtil.getReceivedSQLObjectPrivileges(authId, ProceduralObjectEditModel.this._mainObject);
                                objects.addAll(privs);
                            }
                        }
                        if ((ddl = wrapper.getCreateStatementsDDL(objects.toArray(new SQLObject[objects.size()]))) != null) {
                            StringBuffer sb = new StringBuffer();
                            int i = 0;
                            while (i < ddl.length) {
                                sb.append(ddl[i]).append(LINE).append(ProceduralObjectEditModel.this.getSQLDelimiter()).append(LINE);
                                ++i;
                            }
                            return sb.toString();
                        }
                    }
                    return "";
                }
            };
        }
        return null;
    }

    public void startLogging() {
        super.startLogging();
        Collection authIds = (Collection)this._additionalObjects.get("authids");
        if (authIds != null) {
            this._authIDsChangeDescription = new ChangeDescription[authIds.size()];
            this._authIDsChangeRecoreder = new ChangeRecorder[authIds.size()];
            Object[] authIdObjects = authIds.toArray();
            int i = 0;
            while (i < authIds.size()) {
                this._resource.getContents().add((Object)((EObject)authIdObjects[i]));
                this._authIDsChangeDescription[i] = ChangeFactory.eINSTANCE.createChangeDescription();
                this._authIDsChangeRecoreder[i] = new ChangeRecorder();
                this._authIDsChangeRecoreder[i].beginRecording(this._authIDsChangeDescription[i], Collections.singletonList(authIdObjects[i]));
                ++i;
            }
        }
    }

    public void stopLogging() {
        super.stopLogging();
        int i = 0;
        while (this._authIDsChangeDescription != null && i < this._authIDsChangeDescription.length) {
            this._authIDsChangeDescription[i] = this._authIDsChangeRecoreder[i].endRecording();
            ++i;
        }
    }

    public String getDeltaDDL() {
        String mainDDL = super.getDeltaDDL();
        StringBuffer sb = new StringBuffer(mainDDL);
        String mainDDL1 = mainDDL;
        if (mainDDL != null) {
            mainDDL1 = mainDDL.trim().toUpperCase();
        }
        if (mainDDL != null && mainDDL.length() > 0 && (mainDDL1.startsWith("DROP") || this._reservePrivileges)) {
            DDLGeneratorWrapper wrapper = new DDLGeneratorWrapper(this._dIdentifier);
            String[] ddl = null;
            if (wrapper != null) {
                ArrayList objects = new ArrayList();
                Collection authIds = (Collection)this._additionalObjects.get("authids");
                if (authIds != null) {
                    for (AuthorizationIdentifier authId : authIds) {
                        List privs = PrivilegesUtil.getReceivedSQLObjectPrivileges(authId, this._mainObject);
                        objects.addAll(privs);
                    }
                }
                if ((ddl = wrapper.getCreateStatementsDDL(objects.toArray(new SQLObject[objects.size()]))) != null) {
                    int i = 0;
                    while (i < ddl.length) {
                        sb.append(ddl[i]).append(LINE).append(this.getSQLDelimiter()).append(LINE);
                        ++i;
                    }
                }
            }
        } else {
            sb.append(this.getPrivilegeDeltaDDL());
        }
        return sb.toString();
    }

    protected String getDeltaDDL(Object[] eObjects, ChangeDescription[] changeDescription) {
        if (eObjects.length != changeDescription.length) {
            return null;
        }
        if (this._dGeneratorWrapper == null) {
            this._dGeneratorWrapper = new ASADDLGeneratorWrapper(this._dIdentifier);
        }
        String currentUser = ProfileUtil.getProfileUserName((DatabaseIdentifier)this._dIdentifier, (boolean)false);
        StringBuffer sb = new StringBuffer("");
        if (changeDescription != null) {
            int index = 0;
            while (index < changeDescription.length) {
                if (eObjects[index] instanceof EObject) {
                    String targetUser = ModelUtil.getSchemaName((EObject)((EObject)eObjects[index]));
                    this._dGeneratorWrapper.setGenSetUser(currentUser != null && !currentUser.equals(targetUser));
                    String[] deltaDDL = this._dGeneratorWrapper.generateDeltaDDL((EObject)eObjects[index], changeDescription[index], null);
                    if (deltaDDL != null) {
                        sb.append(super.formatDeltaDDL(deltaDDL));
                    }
                }
                ++index;
            }
        }
        return sb.toString();
    }

    private String getPrivilegeDeltaDDL() {
        Collection authIds = (Collection)this._additionalObjects.get("authids");
        if (authIds == null) {
            return "";
        }
        Object[] authIdObjects = authIds.toArray();
        int i = 0;
        while (this._authIDsChangeRecoreder != null && i < this._authIDsChangeRecoreder.length) {
            this._authIDsChangeRecoreder[i].summarize();
            ++i;
        }
        return this.getDeltaDDL(authIdObjects, this._authIDsChangeDescription);
    }

    public ProcIdentifier getProcIdentifier() {
        return this._procIdentifier;
    }

    public int refreshFromDB() {
        ProcIdentifier oldProc = this._procIdentifier;
        super.refreshFromDB();
        if (this.getMainSQLObject() == null) {
            return 1;
        }
        this._procIdentifier = SQLDevToolsUtil.getProcIdentifier((DatabaseIdentifier)this._dIdentifier, (SQLObject)this.getMainSQLObject());
        if (!oldProc.equals(this._procIdentifier)) {
            SPDebugModelUtil.changeAllBreakpointForSP((ProcIdentifier)oldProc, (ProcIdentifier)this._procIdentifier);
            LaunchHelper.renameAllConfigurations((ProcIdentifier)oldProc, (ProcIdentifier)this._procIdentifier);
        }
        return 0;
    }

    public boolean isReservePrivileges() {
        return this._reservePrivileges;
    }

    public void setReservePrivileges(boolean reservePrivileges) {
        this._reservePrivileges = reservePrivileges;
    }
}

