/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.ui;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParser;
import org.eclipse.datatools.enablement.oda.xml.util.XMLPath;
import org.eclipse.datatools.enablement.oda.xml.util.XMLSourceFromPath;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;

final class XMLFileSchemaTreePopulator
implements ISaxParserConsumer {
    private static final String FORWARD_SLASH = "/";
    private static final String EMPTY_STRING = "";
    private static final String ROOT_LITERAL = "ROOT";
    private int rowCount = 0;
    private ATreeNode root = new ATreeNode();
    private SaxParser sp;
    private int numberOfElementsAccessiable;
    Thread spThread;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.ui.XMLFileSchemaTreePopulator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    XMLFileSchemaTreePopulator(int numberOfElementsAccessiable) {
        this.root.setValue(ROOT_LITERAL);
        this.numberOfElementsAccessiable = numberOfElementsAccessiable == 0 ? Integer.MAX_VALUE : numberOfElementsAccessiable;
    }

    public void manipulateData(XMLPath path, String value) {
        if (this.isAttribute(path.getPathString())) {
            try {
                this.insertNode(path.getPathString().replaceAll("\\Q[\\E\\d+\\Q]\\E", EMPTY_STRING).trim());
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        }
    }

    public void startElement(XMLPath path) {
        String treamedPath = path.getPathString().replaceAll("\\Q[\\E\\d+\\Q]\\E", EMPTY_STRING).trim();
        try {
            this.insertNode(treamedPath);
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        ++this.rowCount;
        if (this.rowCount >= this.numberOfElementsAccessiable) {
            if (!$assertionsDisabled && this.sp == null) {
                throw new AssertionError();
            }
            this.sp.stopParsing();
        }
    }

    public void endElement(XMLPath path) {
        String treamedPath = path.getPathString().replaceAll("\\Q[\\E\\d+\\Q]\\E", EMPTY_STRING).trim();
        try {
            this.insertNode(treamedPath);
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        if (this.rowCount >= this.numberOfElementsAccessiable) {
            if (!$assertionsDisabled && this.sp == null) {
                throw new AssertionError();
            }
            this.sp.stopParsing();
        }
    }

    private boolean isAttribute(String path) {
        return path.matches(".*\\Q@\\E.*");
    }

    public ATreeNode getSchemaTree(String xmlFileName, String xmlEncoding) {
        try {
            XMLSourceFromPath xmlSource = new XMLSourceFromPath(xmlFileName, xmlEncoding);
            this.sp = new SaxParser(xmlSource, this, false);
            this.spThread = new Thread(this.sp);
            this.spThread.start();
            try {
                this.spThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (OdaException e1) {
            e1.printStackTrace();
        }
        if (this.sp == null || this.sp.exceptionOccurred()) {
            return null;
        }
        return this.root;
    }

    public ATreeNode getSchemaTree(String xmlFileName) {
        return this.getSchemaTree(xmlFileName, null);
    }

    private void insertNode(String treatedPath) throws OdaException {
        boolean isAttribute = this.isAttribute(treatedPath);
        String[] path = treatedPath.replaceFirst(FORWARD_SLASH, EMPTY_STRING).split(FORWARD_SLASH);
        if (isAttribute) {
            String[] temp = path[path.length - 1].split("\\Q@\\E");
            if (!$assertionsDisabled && temp.length != 2) {
                throw new AssertionError();
            }
            path[path.length - 1] = temp[1];
        }
        ATreeNode parentNode = this.root;
        int i = 0;
        while (i < path.length) {
            ATreeNode matchedNode = null;
            int j = 0;
            while (j < parentNode.getChildren().length) {
                if (((ATreeNode)parentNode.getChildren()[j]).getValue().equals(path[i])) {
                    matchedNode = (ATreeNode)parentNode.getChildren()[j];
                    break;
                }
                ++j;
            }
            if (matchedNode != null) {
                parentNode = matchedNode;
            } else {
                matchedNode = new ATreeNode();
                if (i == path.length - 1 && isAttribute) {
                    matchedNode.setType(2);
                } else {
                    matchedNode.setType(1);
                }
                matchedNode.setValue(path[i]);
                matchedNode.setParent(parentNode);
                parentNode = matchedNode;
            }
            ++i;
        }
    }

    public void finish() {
    }
}

