/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.impl.DataSetMetaData;
import org.eclipse.datatools.enablement.oda.xml.impl.Query;
import org.eclipse.datatools.enablement.oda.xml.util.IXMLSource;
import org.eclipse.datatools.enablement.oda.xml.util.XMLSourceFromInputStream;
import org.eclipse.datatools.enablement.oda.xml.util.XMLSourceFromPath;

public class Connection
implements IConnection {
    private static final String TRUE_LITERAL = "true";
    private IXMLSource xmlSource;
    private boolean isOpen;
    private Map appContext;
    Properties connProperties;

    public void open(Properties connProperties) throws OdaException {
        String schemaFile;
        if (this.isOpen) {
            return;
        }
        this.connProperties = connProperties;
        String encoding = connProperties == null ? null : (String)connProperties.get("ENCODINGLIST");
        String string = schemaFile = connProperties == null ? null : (String)connProperties.get("SCHEMAFILELIST");
        if (schemaFile != null && schemaFile.length() > 0) {
            InputStream is = new XMLSourceFromPath(schemaFile, encoding).openInputStream();
            try {
                is.close();
            }
            catch (IOException iOException) {}
        } else if (this.appContext == null || !(this.appContext.get("org.eclipse.datatools.enablement.oda.xml.inputStream") instanceof InputStream)) {
            String xmlFile = connProperties == null ? null : (String)connProperties.get("FILELIST");
            InputStream is = new XMLSourceFromPath(xmlFile, encoding).openInputStream();
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        this.isOpen = true;
    }

    public void close() throws OdaException {
        this.isOpen = false;
        if (this.xmlSource != null) {
            this.xmlSource.release();
        }
        this.appContext = null;
    }

    public boolean isOpen() throws OdaException {
        return this.isOpen;
    }

    public void setAppContext(Object context) throws OdaException {
        String legacyCloseInputStreamKey;
        if (!(context instanceof Map)) {
            throw new OdaException(Messages.getString("Connection.InvalidAppContext"));
        }
        this.appContext = (Map)context;
        String legacyInputStreamKey = "org.eclipse.birt.report.data.oda.xml.inputStream";
        if (this.appContext.get(legacyInputStreamKey) != null) {
            this.appContext.put("org.eclipse.datatools.enablement.oda.xml.inputStream", this.appContext.get(legacyInputStreamKey));
            this.appContext.remove(legacyInputStreamKey);
        }
        if (this.appContext.get(legacyCloseInputStreamKey = "org.eclipse.birt.report.data.oda.xml.closeInputStream") != null) {
            this.appContext.put("org.eclipse.datatools.enablement.oda.xml.closeInputStream", this.appContext.get(legacyCloseInputStreamKey));
            this.appContext.remove(legacyCloseInputStreamKey);
        }
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        return new Query(this);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IXMLSource getXMLSource() throws OdaException {
        if (this.xmlSource == null) {
            this.initXMLSource();
        }
        return this.xmlSource;
    }

    private void initXMLSource() throws OdaException {
        String file;
        String encoding = this.connProperties == null ? null : (String)this.connProperties.get("ENCODINGLIST");
        String string = file = this.connProperties == null ? null : (String)this.connProperties.get("FILELIST");
        if (this.appContext != null && this.appContext.get("org.eclipse.datatools.enablement.oda.xml.inputStream") instanceof InputStream) {
            boolean closeOriginalInputStream = false;
            Object closeInputStream = this.appContext.get("org.eclipse.datatools.enablement.oda.xml.closeInputStream");
            if (TRUE_LITERAL.equalsIgnoreCase(closeInputStream == null ? null : closeInputStream.toString())) {
                closeOriginalInputStream = true;
            }
            this.xmlSource = new XMLSourceFromInputStream((InputStream)this.appContext.get("org.eclipse.datatools.enablement.oda.xml.inputStream"), encoding, closeOriginalInputStream);
        } else {
            this.xmlSource = new XMLSourceFromPath(file, encoding);
        }
    }
}

