/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.MappingPathElementTree;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParser;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserNestedQueryHelper;
import org.eclipse.datatools.enablement.oda.xml.util.XMLCreatorContent;
import org.eclipse.datatools.enablement.oda.xml.util.XMLDataInputStreamCreator;

public class SaxParserConsumer
implements ISaxParserConsumer {
    private static final int INVALID_COLUMN_INDEX = -1;
    private SaxParser sp;
    private Thread spThread;
    private int cachedResultSetRowNo;
    private int currentAvailableMaxLineNo;
    private String[] namesOfNestedColumns;
    private String[] namesOfColumns;
    private Map nameIndexMap;
    private String tableName;
    private MappingPathElementTree mappingPathElementTree;
    private RelationInformation relationInfo;
    private int cachedTimes;
    private String[][] cachedResultSet;
    private int currentRowNo;
    private SaxParserNestedQueryHelper spNestedQueryHelper;
    private List cachedRootRows;
    private Map cachedTempRows;
    private List cachedOrderedTempRowRoots;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public SaxParserConsumer(RelationInformation rinfo, XMLCreatorContent content, String tName) throws OdaException {
        block10: {
            super();
            this.cachedResultSetRowNo = 0;
            this.currentAvailableMaxLineNo = -1;
            this.tableName = tName;
            this.relationInfo = rinfo;
            this.currentRowNo = 0;
            this.cachedTempRows = new HashMap<K, V>();
            this.cachedRootRows = new ArrayList<E>();
            this.cachedOrderedTempRowRoots = new ArrayList<E>();
            this.cachedResultSet = new String[10000][this.relationInfo.getTableRealColumnNames(this.tableName).length];
            this.namesOfNestedColumns = this.relationInfo.getTableNestedXMLColumnNames(this.tableName);
            this.namesOfColumns = this.relationInfo.getTableRealColumnNames(this.tableName);
            this.nameIndexMap = new HashMap<K, V>();
            i = 0;
            while (i < this.namesOfColumns.length) {
                this.nameIndexMap.put(this.namesOfColumns[i], new Integer(i));
                ++i;
            }
            this.mappingPathElementTree = this.relationInfo.getTableMappingPathElementTree(this.tableName);
            xdis = XMLDataInputStreamCreator.getCreator(content).createXMLDataInputStream();
            if (this.namesOfNestedColumns.length <= 0) break block10;
            this.spNestedQueryHelper = new SaxParserNestedQueryHelper(this, rinfo, xdis, tName);
            try {
                var5_6 = this;
                synchronized (var5_6) {
                    this.wait();
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl29 : MonitorExitStatement: MONITOREXIT : var5_6
                    if (true) ** GOTO lbl41
                }
                do {
                    var5_6 = this;
                    synchronized (var5_6) {
                        this.wait(5L);
                    }
lbl41:
                    // 2 sources

                } while (!this.spNestedQueryHelper.isPrepared());
            }
            catch (InterruptedException e) {
                throw new OdaException(e.getLocalizedMessage());
            }
        }
        this.sp = new SaxParser(xdis, this, rinfo.containsNamespace());
        this.spThread = new Thread(this.sp);
        this.spThread.start();
    }

    public void manipulateData(String path, String value) {
        if (this.cachedRootRows.size() > 0) {
            int n = 0;
            while (n < this.cachedRootRows.size()) {
                String currentRoot = this.cachedRootRows.get(n).toString();
                String[] os = n == 0 ? this.cachedResultSet[this.cachedResultSetRowNo] : (String[])this.cachedTempRows.get(currentRoot);
                this.populateValueToResultArray(path, value, currentRoot, os);
                ++n;
            }
        }
    }

    private void populateValueToResultArray(String path, String value, String tablePath, String[] os) {
        if (!path.startsWith(tablePath)) {
            return;
        }
        if (this.mappingPathElementTree != null) {
            int[] indexes = this.mappingPathElementTree.getMatchedButNotNestedColumnIndexs(path, tablePath);
            int i = 0;
            while (i < indexes.length) {
                int index = indexes[i];
                if (this.namesOfColumns[index].startsWith("-$TEMP_XML_COLUMN$-")) {
                    os[index] = value;
                } else if (this.namesOfColumns[index].startsWith("-$TEMP_XML_COLUMN_ROOT$-")) {
                    if (os[index] == null) {
                        os[index] = value;
                    }
                } else if (os[index] == null && this.isCurrentColumnValid(this.namesOfColumns[index])) {
                    os[index] = value;
                }
                ++i;
            }
        }
    }

    public void detectNewRow(String path, boolean start) {
        boolean isTablePath = false;
        if (start) {
            if (this.mappingPathElementTree != null) {
                isTablePath = this.mappingPathElementTree.matchesTablePath(path);
            }
        } else {
            isTablePath = new HashSet(this.cachedRootRows).contains(path);
        }
        if (isTablePath) {
            if (start) {
                if (this.cachedRootRows.size() > 0) {
                    this.cachedOrderedTempRowRoots.add(path);
                    this.cachedTempRows.put(path, new String[this.namesOfColumns.length]);
                }
                this.cachedRootRows.add(path);
                return;
            }
            this.populateNestedXMLDataMappingColumns(path);
            this.cachedRootRows.remove(path);
            if (this.cachedRootRows.size() > 0) {
                return;
            }
            if (this.isCurrentRowValid()) {
                ++this.cachedResultSetRowNo;
                ++this.currentAvailableMaxLineNo;
                if (this.cachedResultSetRowNo > 9999) {
                    this.sp.setStart(false);
                    this.cachedResultSetRowNo = 0;
                }
            } else {
                Arrays.fill(this.cachedResultSet[this.cachedResultSetRowNo], null);
            }
            if (this.cachedOrderedTempRowRoots.size() > 0) {
                int i = 0;
                i = 0;
                while (i < this.cachedOrderedTempRowRoots.size()) {
                    String[] result = (String[])this.cachedTempRows.get(this.cachedOrderedTempRowRoots.get(i));
                    this.cachedTempRows.remove(this.cachedOrderedTempRowRoots.get(i));
                    this.cachedResultSet[this.cachedResultSetRowNo] = result;
                    if (this.isCurrentRowValid()) {
                        ++this.cachedResultSetRowNo;
                        ++this.currentAvailableMaxLineNo;
                        if (this.cachedResultSetRowNo > 9999) {
                            this.sp.setStart(false);
                            this.cachedResultSetRowNo = 0;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private void populateNestedXMLDataMappingColumns(String currentRootPath) {
        if (this.cachedRootRows.size() > 1) {
            String currentRoot = this.cachedRootRows.get(this.cachedRootRows.size() - 1).toString();
            String[] os = (String[])this.cachedTempRows.get(currentRoot);
            int i = 0;
            while (i < this.namesOfNestedColumns.length) {
                int j = this.getColumnIndex(this.namesOfNestedColumns[i]);
                if (j != -1) {
                    os[j] = this.spNestedQueryHelper.getNestedColumnValue(currentRootPath, j);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.namesOfNestedColumns.length) {
                int j = this.getColumnIndex(this.namesOfNestedColumns[i]);
                if (j != -1) {
                    this.cachedResultSet[this.cachedResultSetRowNo][j] = this.spNestedQueryHelper.getNestedColumnValue(currentRootPath, j);
                }
                ++i;
            }
        }
    }

    private int getColumnIndex(String columnName) {
        Object index = this.nameIndexMap.get(columnName);
        if (index == null) {
            return -1;
        }
        return (Integer)index;
    }

    private boolean isCurrentRowValid() {
        if (this.relationInfo.getTableFilter(this.tableName) == null || this.relationInfo.getTableFilter(this.tableName).isEmpty()) {
            return true;
        }
        Iterator itr = this.relationInfo.getTableFilter(this.tableName).keySet().iterator();
        while (itr.hasNext()) {
            String columnName = (String)itr.next();
            if (!this.isCurrentColumnValueNotMatchFilterValue(columnName)) continue;
            return false;
        }
        return true;
    }

    private boolean isCurrentColumnValid(String columnName) {
        HashMap filters = this.relationInfo.getTableColumnFilter(this.tableName, columnName);
        if (filters == null) {
            return true;
        }
        Iterator it = filters.keySet().iterator();
        while (it.hasNext()) {
            Object filterColumnName = it.next();
            Object value = filters.get(filterColumnName);
            if (this.isTwoValueMatch(value, this.cachedResultSet[this.cachedResultSetRowNo][this.getColumnIndex(filterColumnName.toString())])) continue;
            return false;
        }
        return true;
    }

    private boolean isTwoValueMatch(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 != null && value2 == null) {
            return false;
        }
        if (value1 == null && value2 != null) {
            return false;
        }
        return value1.equals(value2);
    }

    private boolean isCurrentColumnValueNotMatchFilterValue(String columnName) {
        int index = this.getColumnIndex(columnName);
        return !this.isTwoValueMatch(this.relationInfo.getTableFilter(this.tableName).get(columnName), this.cachedResultSet[this.cachedResultSetRowNo][index]);
    }

    public synchronized void wakeup() {
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws OdaException {
        while (this.sp.isAlive() && !this.sp.isSuspended()) {
            try {
                SaxParserConsumer saxParserConsumer = this;
                synchronized (saxParserConsumer) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new OdaException(e.getLocalizedMessage());
            }
        }
        if (this.currentRowNo > this.currentAvailableMaxLineNo) {
            if (this.sp.isAlive()) {
                this.resumeThread();
                return this.next();
            }
            return false;
        }
        ++this.currentRowNo;
        return true;
    }

    private void resumeThread() throws OdaException {
        if (this.sp.isSuspended()) {
            ++this.cachedTimes;
            this.cachedResultSetRowNo = 0;
            this.cachedResultSet = new String[10000][this.relationInfo.getTableRealColumnNames(this.tableName).length];
            this.sp.setStart(true);
        }
    }

    public void close() {
        if (this.sp != null) {
            this.sp.stopParsing();
        }
    }

    public String[][] getResultSet() {
        return this.cachedResultSet;
    }

    public int getRowPosition() {
        return this.currentRowNo - this.cachedTimes * 10000 - 1;
    }

    public int getCurrentRowNo() {
        return this.currentRowNo;
    }
}

