/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.IInputXMLDataSource;
import org.eclipse.datatools.enablement.oda.xml.util.URLInputStream;

public class XMLDataInputStream
extends InputStream {
    private IInputXMLDataSource inputDataSource;
    private String encoding;
    private static final String TEMPFILENAME = "tempXMLData";

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected XMLDataInputStream(URL url) throws OdaException {
        this.inputDataSource = new URLInputStream(url);
    }

    protected XMLDataInputStream(URL url, String encoding) throws OdaException {
        this.inputDataSource = new URLInputStream(url);
        this.encoding = encoding;
    }

    protected XMLDataInputStream(IInputXMLDataSource url, String encoding) throws OdaException {
        this.inputDataSource = url;
        this.encoding = encoding;
    }

    public XMLDataInputStream(InputStream is) throws OdaException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            int abyte;
            File file = this.createFileWithUniqueName();
            FileOutputStream fos = new FileOutputStream(file);
            while ((abyte = bis.read()) != -1) {
                fos.write(abyte);
            }
            fos.close();
            this.inputDataSource = new URLInputStream(file.toURL());
        }
        catch (IOException e) {
            throw new OdaException(e.getLocalizedMessage());
        }
    }

    private File createFileWithUniqueName() throws IOException {
        File file = File.createTempFile(TEMPFILENAME, null);
        file.deleteOnExit();
        return file;
    }

    public void init() throws IOException {
        this.inputDataSource.init();
    }

    public int read() throws IOException {
        return this.inputDataSource.read();
    }

    public void close() throws IOException {
        this.inputDataSource.close();
        super.close();
    }
}

