/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

public class SaxParserUtil {
    private static final String TEMPCOLUMNNAMEPREFIX = "-$TEMP_XML_COLUMN$-";

    public static boolean isSamePath(String path, String generatedPath) {
        String[] generatedPaths;
        String[] paths;
        if (path.equals(generatedPath)) {
            return true;
        }
        boolean isAbsolute = true;
        if (path.startsWith("//")) {
            path = path.replaceFirst("//", "/");
            isAbsolute = false;
        }
        if ((paths = path.replaceFirst("/", "").split("/")).length > (generatedPaths = generatedPath.replaceFirst("/", "").split("/")).length) {
            return false;
        }
        if (isAbsolute && paths.length != generatedPaths.length) {
            return false;
        }
        int i = 0;
        while (i < paths.length) {
            String temp1 = paths[paths.length - i - 1];
            String temp2 = generatedPaths[generatedPaths.length - i - 1];
            if (!SaxParserUtil.isXPathFragEqual(temp1, temp2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isXPathFragEqual(String definedPath, String generatedPath) {
        if (definedPath.startsWith("*") || definedPath.startsWith("[@")) {
            String pattern = definedPath.replaceFirst("\\Q*\\E", "");
            return pattern.length() != 0 ? generatedPath.endsWith(pattern) : !generatedPath.matches(".*\\Q[@\\E.*\\Q]\\E.*");
        }
        if (!generatedPath.matches(".*\\Q[\\E\\d+\\Q]\\E.*") || definedPath.matches(".*\\Q[\\E\\d+\\Q]\\E.*")) {
            return generatedPath.equals(definedPath);
        }
        if (definedPath.matches(".*\\Q[*]\\E.*")) {
            return definedPath.replaceFirst("\\Q[*]\\E", "").equals(generatedPath.replaceFirst("\\Q[\\E\\d+\\Q]\\E", ""));
        }
        return generatedPath.replaceFirst("\\Q[\\E\\d+\\Q]\\E", "").equals(definedPath);
    }

    public static String processParentAxis(String path) {
        String prefix = "";
        if (path.startsWith("//")) {
            path = path.replaceFirst("//", "");
            prefix = "//";
        } else if (path.startsWith("/")) {
            path = path.replaceFirst("/", "");
            prefix = "/";
        }
        String[] temp = path.split("/");
        int i = 0;
        while (i < temp.length) {
            if (temp[i].equals("..")) {
                temp[i] = null;
                int j = i - 1;
                while (j >= 0) {
                    if (temp[j] != null) {
                        temp[j] = null;
                        break;
                    }
                    --j;
                }
            }
            ++i;
        }
        path = prefix;
        i = 0;
        while (i < temp.length) {
            if (temp[i] != null) {
                path = i == 0 ? String.valueOf(path) + temp[i] : String.valueOf(path) + (temp[i].startsWith("[") ? "" : "/") + temp[i];
            }
            ++i;
        }
        if (path.startsWith("///")) {
            path = path.replaceFirst("\\Q/\\E", "");
        }
        return path;
    }

    static String createTempColumnName(int index) {
        return TEMPCOLUMNNAMEPREFIX + index;
    }

    static boolean isTempColumn(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith(TEMPCOLUMNNAMEPREFIX);
    }
}

