/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.impl.DataSetMetaData;
import org.eclipse.datatools.enablement.oda.xml.impl.Query;
import org.eclipse.datatools.enablement.oda.xml.util.XMLDataInputStreamCreator;

public class Connection
implements IConnection {
    private XMLDataInputStreamCreator is;
    private boolean isOpen;
    private Map appContext;

    public void open(Properties connProperties) throws OdaException {
        if (this.isOpen) {
            return;
        }
        String file = (String)connProperties.get("FILELIST");
        if (this.appContext != null && this.appContext.get("org.eclipse.datatools.enablement.oda.xml.inputStream") != null && this.appContext.get("org.eclipse.datatools.enablement.oda.xml.inputStream") instanceof InputStream) {
            this.is = XMLDataInputStreamCreator.getCreator((InputStream)this.appContext.get("org.eclipse.datatools.enablement.oda.xml.inputStream"));
        } else if (file != null) {
            this.is = XMLDataInputStreamCreator.getCreator(file);
        } else {
            throw new OdaException(Messages.getString("Connection.PropertiesMissing"));
        }
        this.isOpen = true;
    }

    public void close() throws OdaException {
        this.isOpen = false;
        try {
            Object closeInputStream;
            if (this.appContext != null && this.appContext.get("org.eclipse.datatools.enablement.oda.xml.inputStream") != null && (closeInputStream = this.appContext.get("org.eclipse.datatools.enablement.oda.xml.closeInputStream")) != null && closeInputStream.toString().equalsIgnoreCase("true")) {
                this.closeInputStreamFromAppContext();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.appContext = null;
    }

    private void closeInputStreamFromAppContext() throws IOException {
        ((InputStream)this.appContext.get("org.eclipse.datatools.enablement.oda.xml.inputStream")).close();
    }

    public boolean isOpen() throws OdaException {
        return this.isOpen;
    }

    public void setAppContext(Object context) throws OdaException {
        String legacyCloseInputStreamKey;
        if (!(context instanceof Map)) {
            throw new OdaException(Messages.getString("Connection.InvalidAppContext"));
        }
        this.appContext = (Map)context;
        String legacyInputStreamKey = "org.eclipse.birt.report.data.oda.xml.inputStream";
        if (this.appContext.get(legacyInputStreamKey) != null) {
            this.appContext.put("org.eclipse.datatools.enablement.oda.xml.inputStream", this.appContext.get(legacyInputStreamKey));
            this.appContext.remove(legacyInputStreamKey);
        }
        if (this.appContext.get(legacyCloseInputStreamKey = "org.eclipse.birt.report.data.oda.xml.closeInputStream") != null) {
            this.appContext.put("org.eclipse.datatools.enablement.oda.xml.closeInputStream", this.appContext.get(legacyCloseInputStreamKey));
            this.appContext.remove(legacyCloseInputStreamKey);
        }
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        return new Query(this.is);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws OdaException {
        throw new UnsupportedOperationException();
    }
}

