/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.ExceptionHandler;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreeNodeData;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreeNodeDataUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreePopulationUtil;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XPathPopulationUtil;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class XMLTreeViewer {
    private Button btnSingleAdd;
    private Button btnMultiAdd;
    private TreeViewer treeViewer;
    private Composite btnComposite;

    XMLTreeViewer(Composite parent, boolean supportMultiSelection) {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(47, -5);
        data.bottom = new FormAttachment(100, -5);
        Group treeGroup = new Group(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        treeGroup.setLayout((Layout)layout);
        treeGroup.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer((Composite)treeGroup, 268438274);
        data = new FormData();
        data.left = new FormAttachment((Control)treeGroup, 5);
        data.bottom = new FormAttachment(50);
        data.width = 28;
        this.btnComposite = new Composite(parent, 0);
        this.btnComposite.setLayoutData((Object)data);
        FillLayout btnLayout = new FillLayout(512);
        btnLayout.spacing = 5;
        this.btnComposite.setLayout((Layout)btnLayout);
        this.btnSingleAdd = new Button(this.btnComposite, 0);
        this.btnSingleAdd.setText(">");
        this.btnSingleAdd.setEnabled(false);
        this.btnMultiAdd = new Button(this.btnComposite, 0);
        this.btnMultiAdd.setText(">>");
        this.btnMultiAdd.setToolTipText(Messages.getString("ColumnMappingPage.AddAllButton.tooltip"));
        this.btnMultiAdd.setEnabled(true);
        if (!supportMultiSelection) {
            this.btnMultiAdd.setVisible(false);
        }
        treeGroup.setText(Messages.getString("xPathChoosePage.messages.xmlStructure"));
    }

    void populateTree(ATreeNode treeNode, String xPathExpression, boolean includeAttr, boolean needExpand) throws OdaException {
        final String xPathExpr = xPathExpression;
        final boolean includeAttribute = includeAttr;
        this.treeViewer.getTree().addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem currentItem = (TreeItem)event.item;
                if (((TreeNodeData)currentItem.getData()).hasBeenExpandedOnce()) {
                    return;
                }
                ((TreeNodeData)currentItem.getData()).setHasBeenExpandedOnce();
                currentItem.removeAll();
                try {
                    if (((TreeNodeData)currentItem.getData()).getTreeNode().getChildren() != null && ((TreeNodeData)currentItem.getData()).getTreeNode().getChildren().length > 0) {
                        TreePopulationUtil.populateTreeItems(currentItem, ((TreeNodeData)currentItem.getData()).getTreeNode().getChildren(), xPathExpr, includeAttribute);
                    }
                }
                catch (OdaException e) {
                    ExceptionHandler.showException(null, Messages.getString("error.label"), e.getMessage(), e);
                }
            }
        });
        Object[] childs = treeNode.getChildren();
        if (needExpand) {
            this.populateTreeItems(this.treeViewer.getTree(), childs, 0, xPathExpression, includeAttribute);
        } else {
            TreePopulationUtil.populateTreeItems(this.treeViewer.getTree(), childs, xPathExpr, includeAttribute);
        }
    }

    Button getSingleButton() {
        return this.btnSingleAdd;
    }

    Button getMultiButton() {
        return this.btnMultiAdd;
    }

    Tree getTree() {
        return this.treeViewer.getTree();
    }

    Composite getBtnComposite() {
        return this.btnComposite;
    }

    private void populateTreeItems(Object tree, Object[] node, int level, String xPathExpression, boolean includeAttribute) throws OdaException {
        ATreeNode treeNode;
        ++level;
        TreeNodeData[] children = new TreeNodeData[node.length];
        TreeItem[] treeItems = new TreeItem[node.length];
        boolean findXPathNode = false;
        int i = 0;
        while (i < children.length) {
            block17: {
                treeNode = (ATreeNode)node[i];
                children[i] = new TreeNodeData(treeNode);
                int type = treeNode.getType();
                switch (type) {
                    case 2: {
                        if (includeAttribute) {
                            treeItems[i] = tree instanceof Tree ? new TreeItem((Tree)tree, 0) : new TreeItem((TreeItem)tree, 0);
                            treeItems[i].setData((Object)children[i]);
                            treeItems[i].setImage(TreeNodeDataUtil.getColumnImage());
                            treeItems[i].setText("@" + treeNode.getValue().toString());
                            break;
                        }
                        break block17;
                    }
                    case 1: {
                        treeItems[i] = tree instanceof Tree ? new TreeItem((Tree)tree, 0) : new TreeItem((TreeItem)tree, 0);
                        treeItems[i].setData((Object)children[i]);
                        if (treeNode.getParent() != null && "ROOT".equals(treeNode.getParent().getValue())) {
                            treeItems[i].setImage(TreeNodeDataUtil.getSourceFileImage());
                        } else if (treeNode.getChildren() == null || treeNode.getChildren().length == 0) {
                            treeItems[i].setImage(TreeNodeDataUtil.getColumnImage());
                        } else {
                            treeItems[i].setImage(TreeNodeDataUtil.getXmlElementImage());
                        }
                        treeItems[i].setText(treeNode.getValue().toString());
                        break;
                    }
                    default: {
                        treeItems[i] = tree instanceof Tree ? new TreeItem((Tree)tree, 0) : new TreeItem((TreeItem)tree, 0);
                        treeItems[i].setData((Object)children[i]);
                        treeItems[i].setText(treeNode.getValue().toString());
                    }
                }
                ATreeNode aTreeNode = ((TreeNodeData)treeItems[i].getData()).getTreeNode();
                String populateString = XPathPopulationUtil.populateColumnPath((String)TreePopulationUtil.getRootPathWithOutFilter(xPathExpression), (String)TreePopulationUtil.generateXpathFromATreeNode(aTreeNode));
                if (populateString != null && populateString.equals("")) {
                    FontData fontData = new FontData("", 8, 1);
                    treeItems[i].setFont(new Font(null, fontData));
                    this.treeViewer.getTree().setSelection(new TreeItem[]{treeItems[i]});
                    this.treeViewer.getTree().setFocus();
                    this.treeViewer.getTree().setSelection(treeItems[i]);
                    children[i].setXPathStatus(true);
                    findXPathNode = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            treeNode = children[i].getTreeNode();
            if (treeNode.getChildren() != null && treeNode.getChildren().length > 0) {
                if (level > (xPathExpression == null || xPathExpression.split("/").length < 5 ? 5 : xPathExpression.split("/").length)) {
                    new TreeItem(treeItems[i], 0);
                } else {
                    children[i].setHasBeenExpandedOnce();
                    if (!findXPathNode || children[i].getXPathStatus()) {
                        this.populateTreeItems(treeItems[i], treeNode.getChildren(), level, xPathExpression, includeAttribute);
                    } else {
                        TreePopulationUtil.populateTreeItems(treeItems[i], treeNode.getChildren(), xPathExpression, includeAttribute);
                    }
                }
            }
            ++i;
        }
    }
}

