/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.xml.impl.DataTypes;
import org.eclipse.datatools.enablement.oda.xml.ui.UiPlugin;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.ExceptionHandler;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingDialog;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingElement;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingTableViewer;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.DataSetDesignPopulator;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.DataTypeUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreeNodeData;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLDataPreviewDialog;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLInformationHolder;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLTreeViewer;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.SchemaPopulationUtil;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XPathPopulationUtil;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class ColumnMappingPage
extends DataSetWizardPage
implements ITableLabelProvider {
    private static final String RIGHT_SQUARE_BRACKET = "]";
    private static final String LEFT_SQUARE_BRACKET = "[";
    private static final String LEFT_CURLY_BRACKET = "{";
    private static final String RIGHT_CURLY_BRACKET = "}";
    private static final String LEFT_SHARP_ANGLED_BRACKET = "<";
    private static final String RIGHT_SHARP_ANGLED_BRACKET = ">";
    private static final String COMMA = ",";
    private static final String SEMICOLON = ";";
    private static final String UNDERSCORE = "_";
    private static final String EMPTY_STRING = "";
    private static final String DOUBLE_QUOTE = "\"";
    private XMLTreeViewer availableXmlTree;
    private Button btnPreview;
    private ColumnMappingTableViewer columnMappingTable;
    private Group tableViewerGroup;
    private ATreeNode treeNode;
    private String tableName;
    private String xsdFileName;
    private String xmlFileName;
    private String xmlEncoding;
    private Map columnMap;
    private List columnMappingList = new ArrayList();
    private String selectedTreeItemText;
    private static String COLUMN_NAME = Messages.getString("dataset.editor.columnName");
    private static String XPATH_NAME = Messages.getString("dataset.editor.xpathexpression");
    private static String TYPE_NAME = Messages.getString("dataset.editor.datatype");
    private static String DEFAULT_PAGE_NAME = Messages.getString("xPathChoosePage.messages.xmlColumnMapping");
    private static String DEFAULT_PAGE_Message = Messages.getString("wizard.title.defineColumnMapping");
    private static String PATH_SEPERATOR = "/";
    private static String ATTRIBUTE_MARK = "@";
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString("datatypes.dateTime"), Messages.getString("datatypes.decimal"), Messages.getString("datatypes.float"), Messages.getString("datatypes.integer"), Messages.getString("datatypes.date"), Messages.getString("datatypes.time"), Messages.getString("datatypes.string"), Messages.getString("datatypes.boolean")};
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public ColumnMappingPage() {
        this(Messages.getString("wizard.title.newDataSet"));
        Arrays.sort(dataTypeDisplayNames);
    }

    public ColumnMappingPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        DEFAULT_PAGE_Message = Messages.getString("wizard.title.defineColumnMapping");
        this.setMessage(DEFAULT_PAGE_Message);
        this.columnMap = new HashMap();
        this.columnMappingList = new ArrayList();
        this.setPageComplete(false);
        Arrays.sort(dataTypeDisplayNames);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        if (XMLInformationHolder.hasDestroyed()) {
            XMLInformationHolder.start(this.getInitializationDesign());
        }
        this.initializeControl();
        if (this.selectedTreeItemText != null) {
            this.populateXMLTree();
        }
        XMLRelationInfoUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_XML_ColumnMapping_ID");
    }

    private void initializeControl() {
        this.xsdFileName = XMLInformationHolder.getPropertyValue("SCHEMAFILELIST");
        this.xmlFileName = XMLInformationHolder.getPropertyValue("FILELIST");
        this.xmlEncoding = XMLInformationHolder.getPropertyValue("ENCODINGLIST");
        String queryText = XMLInformationHolder.getPropertyValue("RELATIONINFORMATION");
        this.tableName = XMLRelationInfoUtil.getTableName(queryText);
        if (this.tableName != null && this.tableName.trim().length() > 0) {
            this.selectedTreeItemText = XMLRelationInfoUtil.getXPathExpression(queryText, this.tableName);
            RelationInformation info = null;
            try {
                info = new RelationInformation(queryText);
            }
            catch (OdaException e) {
                this.setMessage(Messages.getString("error.columnMapping.createPage"), 3);
                logger.log(Level.INFO, e.getMessage(), e);
            }
            this.columnMap = new HashMap();
            this.columnMappingList = this.columnMappingTable.refresh(info, this.tableName, this.columnMap);
            this.refreshColumnMappingViewer();
        } else {
            this.selectedTreeItemText = XMLInformationHolder.getPropertyValue("XPATHTEXT");
            this.tableName = XMLRelationInfoUtil.getUniqueName(null);
            XMLInformationHolder.setPropertyValue("TABLENAME", this.tableName);
        }
        this.setPageProperties();
    }

    public void refresh() {
        this.selectedTreeItemText = XMLInformationHolder.getPropertyValue("XPATHTEXT");
        this.xsdFileName = XMLInformationHolder.getPropertyValue("SCHEMAFILELIST");
        this.xmlFileName = XMLInformationHolder.getPropertyValue("FILELIST");
        this.xmlEncoding = XMLInformationHolder.getPropertyValue("ENCODINGLIST");
        if (this.selectedTreeItemText != null) {
            this.populateXMLTree();
        }
        this.setPageProperties();
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        DEFAULT_PAGE_Message = Messages.getString("xPathChoosePage.messages.xmlColumnMapping");
        if (XMLInformationHolder.hasDestroyed()) {
            XMLInformationHolder.start(dataSetDesign);
        }
        this.setMessage(DEFAULT_PAGE_Message);
        this.refresh();
    }

    public Control createPageControl(Composite parent) {
        DEFAULT_PAGE_Message = Messages.getString("wizard.title.defineColumnMapping");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createPageComposite(composite);
        this.setPageProperties();
        return composite;
    }

    private void createPageComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        int height = parent.getShell().getDisplay().getBounds().height;
        gridData.heightHint = height * 4 / 10;
        composite.setLayoutData((Object)gridData);
        this.createLeftGroup(composite);
        this.availableXmlTree.getSingleButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selectedMultiItems = ColumnMappingPage.this.availableXmlTree.getTree().getSelection();
                if (selectedMultiItems == null) {
                    ColumnMappingPage.this.setMessage(Messages.getString("error.columnMapping.SelectedTreeItem.notNull"), 3);
                    ColumnMappingPage.this.availableXmlTree.getSingleButton().setEnabled(false);
                    ColumnMappingPage.this.availableXmlTree.getMultiButton().setEnabled(false);
                    return;
                }
                int i = 0;
                while (i < selectedMultiItems.length) {
                    TreeItem selectedItem = selectedMultiItems[i];
                    ATreeNode treeNode = ((TreeNodeData)selectedItem.getData()).getTreeNode();
                    String pathStr = ColumnMappingPage.this.createXPath(treeNode);
                    ColumnMappingElement columnElement = null;
                    if (selectedMultiItems.length > 1) {
                        columnElement = ColumnMappingPage.this.createSingleElement(treeNode, pathStr);
                    } else {
                        String name = (String)treeNode.getValue();
                        int type = -1;
                        try {
                            type = DataTypes.getType((String)treeNode.getDataType());
                        }
                        catch (OdaException odaException) {
                            type = 12;
                        }
                        ColumnMappingDialog columnDialog = new ColumnMappingDialog(ColumnMappingPage.this.getShell(), DEFAULT_PAGE_NAME, name, pathStr, type, true);
                        if (columnDialog.open() == 0) {
                            columnElement = columnDialog.getColumnMapping();
                        }
                    }
                    if (columnElement != null) {
                        ColumnMappingPage.this.updateColumnMappingElement(columnElement);
                    }
                    ++i;
                }
                selectedMultiItems = null;
                ColumnMappingPage.this.availableXmlTree.getSingleButton().setEnabled(false);
            }
        });
        this.availableXmlTree.getMultiButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selectedMultiItems = ColumnMappingPage.this.availableXmlTree.getTree().getSelection();
                if (selectedMultiItems == null || selectedMultiItems.length == 0) {
                    selectedMultiItems = ColumnMappingPage.this.availableXmlTree.getTree().getItems();
                }
                HashSet selectedNodes = new HashSet();
                if (selectedMultiItems.length == 1) {
                    if (!ColumnMappingPage.this.handleSelectedItem(selectedMultiItems[0], selectedNodes)) {
                        ColumnMappingPage.this.setMessage(Messages.getString("error.columnMapping.columnElement.create"), 3);
                    }
                } else {
                    int i = 0;
                    while (i < selectedMultiItems.length) {
                        TreeItem selectedItem = selectedMultiItems[i];
                        if (!ColumnMappingPage.this.handleSelectedItem(selectedItem, selectedNodes)) {
                            ColumnMappingPage.this.setMessage(Messages.getString("error.columnMapping.columnElement.create"), 3);
                            break;
                        }
                        ++i;
                    }
                }
                ColumnMappingPage.this.availableXmlTree.getTree().setSelection(ColumnMappingPage.this.availableXmlTree.getTree().getItem(0));
                ColumnMappingPage.this.availableXmlTree.getSingleButton().setEnabled(false);
            }
        });
        this.createRightGroup(composite);
    }

    private void createPreviewButton(Composite parent) {
        this.btnPreview = new Button(parent, 8);
        this.btnPreview.setText(Messages.getString("menu.button.preview"));
        this.btnPreview.setToolTipText(Messages.getString("ColumnMappingTable.previewButton.tooltip"));
        this.btnPreview.addSelectionListener((SelectionListener)this.getPreviewButtonAdapter());
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000008;
        this.btnPreview.setLayoutData((Object)gd);
    }

    protected SelectionAdapter getPreviewButtonAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLDataPreviewDialog previewDialog = new XMLDataPreviewDialog(ColumnMappingPage.this.getShell());
                if (previewDialog.open() == 12) {
                    previewDialog.close();
                }
            }
        };
    }

    private void createRightGroup(Composite composite) {
        this.tableViewerGroup = new Group(composite, 0);
        this.tableViewerGroup.setText(Messages.getString("xPathChoosePage.messages.xmlColumnMapping"));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        this.tableViewerGroup.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment((Control)this.availableXmlTree.getBtnComposite(), 5);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.tableViewerGroup.setLayoutData((Object)data);
        this.tableViewerGroup.setEnabled(true);
        this.createTableViewerGroup((Composite)this.tableViewerGroup);
        this.createPreviewButton((Composite)this.tableViewerGroup);
    }

    private void createTableViewerGroup(Composite composite2) {
        this.columnMappingTable = new ColumnMappingTableViewer(composite2, true, true, true);
        this.columnMappingTable.getControl().setLayoutData((Object)new GridData(1808));
        this.columnMappingTable.getViewer().getTable().setHeaderVisible(true);
        this.columnMappingTable.getViewer().getTable().setLinesVisible(true);
        TableColumn column = new TableColumn(this.columnMappingTable.getViewer().getTable(), 16384);
        column.setText(COLUMN_NAME);
        column.setWidth(100);
        column = new TableColumn(this.columnMappingTable.getViewer().getTable(), 16384);
        column.setText(XPATH_NAME);
        column.setWidth(100);
        column = new TableColumn(this.columnMappingTable.getViewer().getTable(), 16384);
        column.setText(TYPE_NAME);
        column.setWidth(60);
        this.columnMappingTable.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ArrayList) {
                    ArrayList inputList = new ArrayList(10);
                    inputList.addAll(ColumnMappingPage.this.columnMappingList);
                    return inputList.toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.columnMappingTable.getViewer().setLabelProvider((IBaseLabelProvider)this);
        this.columnMappingTable.getViewer().setInput((Object)this.columnMappingList);
        this.refreshColumnMappingViewer();
        this.setupEditors();
        this.addListenersAndToolTip();
    }

    private void addChildrenElements(ATreeNode aTreeNode, HashSet selectedNodes) {
        try {
            if (aTreeNode.getType() == 2 || aTreeNode.getType() == 1 && (aTreeNode.getChildren() == null || aTreeNode.getChildren().length == 0)) {
                if (selectedNodes != null && !selectedNodes.contains(aTreeNode)) {
                    String pathStr = this.createXPath(aTreeNode);
                    this.updateColumnMappingElement(this.createSingleElement(aTreeNode, pathStr));
                    selectedNodes.add(aTreeNode);
                }
            } else {
                Object[] children = aTreeNode.getChildren();
                if (children != null) {
                    int i = 0;
                    while (i < children.length) {
                        this.addChildrenElements((ATreeNode)children[i], selectedNodes);
                        ++i;
                    }
                }
            }
        }
        catch (OdaException e) {
            logger.log(Level.INFO, e.getMessage(), e);
            this.setMessage(Messages.getString("error.columnMapping.ATreeNode.getChildren"), 3);
        }
    }

    private boolean isUniqueName(String columnName, ColumnMappingElement actualElement) {
        boolean success = true;
        if (this.columnMap != null) {
            if (this.columnMap.containsKey(columnName) && this.columnMap.get(columnName) != null) {
                success = false;
            } else {
                this.setDetailsMessage(DEFAULT_PAGE_Message, 0);
            }
        } else {
            this.setDetailsMessage(DEFAULT_PAGE_Message, 0);
            this.columnMap = new HashMap();
            this.columnMappingList = new ArrayList();
        }
        return success;
    }

    private String createXPath(ATreeNode aTreeNode) {
        if (aTreeNode == null) {
            return null;
        }
        String columnPath = this.generateXpathFromATreeNode(aTreeNode);
        return XPathPopulationUtil.populateColumnPath((String)this.getRootPathWithOutFilter(), (String)columnPath);
    }

    private String getRootPathWithOutFilter() {
        return this.selectedTreeItemText.replaceAll("\\Q[\\E.*\\Q]\\E", EMPTY_STRING);
    }

    private String generateXpathFromATreeNode(ATreeNode aTreeNode) {
        String columnPath = (String)aTreeNode.getValue();
        if (aTreeNode.getType() == 2) {
            columnPath = String.valueOf(ATTRIBUTE_MARK) + columnPath;
        }
        ATreeNode parent = aTreeNode.getParent();
        while (parent != null) {
            if (parent.getType() == 1 && columnPath != null && columnPath.trim().length() > 0) {
                columnPath = parent.getValue() + PATH_SEPERATOR + columnPath;
            } else if (parent.getType() == 2) {
                columnPath = String.valueOf(columnPath) + PATH_SEPERATOR + ATTRIBUTE_MARK + parent.getValue();
            }
            parent = parent.getParent();
        }
        if (!columnPath.startsWith(PATH_SEPERATOR)) {
            columnPath = String.valueOf(PATH_SEPERATOR) + columnPath;
        }
        return columnPath;
    }

    private void createLeftGroup(Composite composite2) {
        this.availableXmlTree = new XMLTreeViewer(composite2, true);
        this.availableXmlTree.getSingleButton().setToolTipText(Messages.getString("ColumnMappingPage.AddSingleButton.tooltip"));
        this.availableXmlTree.getMultiButton().setToolTipText(Messages.getString("ColumnMappingPage.AddAllButton.tooltip"));
        this.availableXmlTree.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selectedMultiItems = ColumnMappingPage.this.availableXmlTree.getTree().getSelection();
                if (selectedMultiItems.length > 1) {
                    int i = 0;
                    while (i < selectedMultiItems.length) {
                        if (selectedMultiItems[i].getGrayed()) {
                            ColumnMappingPage.this.availableXmlTree.getTree().setRedraw(false);
                            ColumnMappingPage.this.availableXmlTree.getTree().deselectAll();
                            ColumnMappingPage.this.availableXmlTree.getTree().setRedraw(true);
                            ColumnMappingPage.this.availableXmlTree.getTree().redraw();
                        }
                        ++i;
                    }
                    ColumnMappingPage.this.setMessage(DEFAULT_PAGE_Message);
                    ColumnMappingPage.this.availableXmlTree.getMultiButton().setEnabled(true);
                    ColumnMappingPage.this.availableXmlTree.getSingleButton().setEnabled(true);
                } else if (selectedMultiItems.length == 1) {
                    TreeItem selectedItem = selectedMultiItems[0];
                    selectedMultiItems = null;
                    if (selectedItem.getGrayed()) {
                        ColumnMappingPage.this.availableXmlTree.getTree().setRedraw(false);
                        ColumnMappingPage.this.availableXmlTree.getTree().deselectAll();
                        ColumnMappingPage.this.availableXmlTree.getTree().setRedraw(true);
                        ColumnMappingPage.this.availableXmlTree.getTree().redraw();
                    }
                    if (selectedItem != null) {
                        ColumnMappingPage.this.setMessage(DEFAULT_PAGE_Message);
                        ColumnMappingPage.this.availableXmlTree.getSingleButton().setEnabled(true);
                        ColumnMappingPage.this.availableXmlTree.getMultiButton().setEnabled(true);
                    } else {
                        ColumnMappingPage.this.availableXmlTree.getSingleButton().setEnabled(false);
                        ColumnMappingPage.this.availableXmlTree.getMultiButton().setEnabled(false);
                    }
                } else {
                    ColumnMappingPage.this.availableXmlTree.getSingleButton().setEnabled(false);
                    ColumnMappingPage.this.availableXmlTree.getMultiButton().setEnabled(true);
                }
                ColumnMappingPage.this.enableAllTableSideButtons(false);
            }
        });
    }

    private void addListenersAndToolTip() {
        this.columnMappingTable.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    ColumnMappingPage.this.removeSelectedItems();
                    ColumnMappingPage.this.setPageProperties();
                }
            }
        });
        this.columnMappingTable.getViewer().getTable().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (ColumnMappingPage.this.columnMappingTable.getViewer().getTable().getSelectionCount() == 1) {
                    ColumnMappingPage.this.enableAllTableSideButtons(true);
                    ColumnMappingPage.this.resetUpDownButton();
                } else {
                    ColumnMappingPage.this.enableAllTableSideButtons(false);
                    if (ColumnMappingPage.this.columnMappingTable.getViewer().getTable().getSelectionCount() > 1) {
                        ColumnMappingPage.this.columnMappingTable.getRemoveButton().setEnabled(true);
                    }
                }
            }
        });
        this.columnMappingTable.getEditButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.doEdit();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columnMappingTable.getEditButton().setToolTipText(Messages.getString("ColumnMappingTable.editButton.tooltip"));
        this.columnMappingTable.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.removeSelectedItems();
                ColumnMappingPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columnMappingTable.getRemoveButton().setToolTipText(Messages.getString("ColumnMappingTable.removeButton.tooltip"));
        this.columnMappingTable.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.removeSelectedItems();
                ColumnMappingPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columnMappingTable.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.removeAllItem();
                ColumnMappingPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.columnMappingTable.getAddButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.manuallyAddOneColumn();
                ColumnMappingPage.this.columnMappingTable.getViewer().getTable().setSelection(-1);
                ColumnMappingPage.this.enableAllTableSideButtons(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columnMappingTable.getUpButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.upMoveSelectedItem();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columnMappingTable.getUpButton().setToolTipText(Messages.getString("ColumnMappingTable.upButton.tooltip"));
        this.columnMappingTable.getDownButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColumnMappingPage.this.downMoveSelectedItem();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columnMappingTable.getDownButton().setToolTipText(Messages.getString("ColumnMappingTable.downButton.tooltip"));
    }

    private void manuallyAddOneColumn() {
        ColumnMappingElement columnElement;
        ColumnMappingDialog columnDialog = new ColumnMappingDialog(this.getShell(), DEFAULT_PAGE_NAME, null, null, -1, false);
        if (columnDialog.open() == 0 && (columnElement = columnDialog.getColumnMapping()) != null) {
            this.updateColumnMappingElement(columnElement);
        }
    }

    private void enableAllTableSideButtons(boolean enabled) {
        this.columnMappingTable.getEditButton().setEnabled(enabled);
        this.columnMappingTable.getRemoveButton().setEnabled(enabled);
        this.columnMappingTable.getUpButton().setEnabled(enabled);
        this.columnMappingTable.getDownButton().setEnabled(enabled);
    }

    private void doEdit() {
        int index = this.columnMappingTable.getViewer().getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        ColumnMappingElement columnMappingElement = (ColumnMappingElement)this.columnMappingTable.getViewer().getTable().getItem(index).getData();
        String originColumnName = columnMappingElement.getColumnName();
        try {
            ColumnMappingDialog columnDialog = new ColumnMappingDialog(this.getShell(), DEFAULT_PAGE_NAME, columnMappingElement.getColumnName(), columnMappingElement.getXPath(), DataTypes.getType((String)columnMappingElement.getTypeStandardString()), false);
            if (columnDialog.open() == 0) {
                this.columnMap.remove(columnMappingElement.getColumnName());
                ColumnMappingElement columnElement = columnDialog.getColumnMapping();
                String editedColumnName = columnElement.getColumnName();
                if (!originColumnName.equalsIgnoreCase(editedColumnName)) {
                    int appendix = 0;
                    if (!this.isUniqueName(editedColumnName, columnElement)) {
                        ++appendix;
                    }
                    if (appendix > 0) {
                        editedColumnName = String.valueOf(editedColumnName) + UNDERSCORE + appendix;
                    }
                    columnElement.setColumnName(editedColumnName);
                }
                columnMappingElement.setColumnName(editedColumnName);
                columnMappingElement.setType(columnElement.getType());
                columnMappingElement.setXPath(columnElement.getXPath());
                this.columnMap.put(editedColumnName, columnMappingElement);
                if (this.columnMappingList.size() > index) {
                    this.columnMappingList.set(index, columnMappingElement);
                }
                this.setXMLInformationHolderProps();
                this.refreshColumnMappingViewer();
                this.setPageProperties();
                this.refreshXMLConnection();
            }
        }
        catch (OdaException e1) {
            logger.log(Level.INFO, e1.getMessage(), e1);
            this.setMessage(Messages.getString("error.columnMapping.columnElement.edit"), 3);
        }
    }

    private void resetUpDownButton() {
        if (this.columnMappingTable.getViewer().getTable().getItemCount() == 1) {
            this.columnMappingTable.getUpButton().setEnabled(false);
            this.columnMappingTable.getDownButton().setEnabled(false);
        } else if (this.columnMappingTable.getViewer().getTable().getSelectionIndex() == 0) {
            this.columnMappingTable.getUpButton().setEnabled(false);
            this.columnMappingTable.getDownButton().setEnabled(true);
        } else if (this.columnMappingTable.getViewer().getTable().getSelectionIndex() == this.columnMappingTable.getViewer().getTable().getItemCount() - 1) {
            this.columnMappingTable.getDownButton().setEnabled(false);
            this.columnMappingTable.getUpButton().setEnabled(true);
        }
    }

    private void removeSelectedItems() {
        int[] indices = this.columnMappingTable.getViewer().getTable().getSelectionIndices();
        int i = 0;
        while (i < indices.length) {
            this.removeSingleColumnItem(indices[i] - i);
            ++i;
        }
        this.refreshColumnMappingViewer();
    }

    private void removeSingleColumnItem(int index) {
        Object element = this.columnMappingTable.getViewer().getTable().getItem(index).getData();
        String elementName = EMPTY_STRING;
        if (element instanceof ColumnMappingElement) {
            ColumnMappingElement entry = (ColumnMappingElement)element;
            elementName = entry.getColumnName();
            this.columnMappingTable.getViewer().getTable().remove(index);
            this.columnMap.remove(elementName);
            this.columnMappingList.remove(index);
            String str = XMLRelationInfoUtil.replaceInfo(this.tableName, this.saveQueryString(), XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", str);
        }
    }

    private void removeAllItem() {
        int count = this.columnMappingTable.getViewer().getTable().getItemCount();
        int index = 0;
        while (index < count) {
            this.removeSingleColumnItem(0);
            ++index;
        }
        String str = XMLRelationInfoUtil.replaceInfo(this.tableName, EMPTY_STRING, XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
        XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", str);
        this.refreshColumnMappingViewer();
    }

    private void upMoveSelectedItem() {
        int count = this.columnMappingTable.getViewer().getTable().getItemCount();
        int index = this.columnMappingTable.getViewer().getTable().getSelectionIndex();
        if (index > 0 && index < count) {
            Object obj = this.columnMappingList.get(index);
            this.columnMappingList.set(index, this.columnMappingList.get(index - 1));
            this.columnMappingList.set(index - 1, obj);
            String str = XMLRelationInfoUtil.replaceInfo(this.tableName, this.saveQueryString(), XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", str);
            this.refreshColumnMappingViewer();
            this.resetUpDownButton();
        }
    }

    private void downMoveSelectedItem() {
        int count = this.columnMappingTable.getViewer().getTable().getItemCount();
        int index = this.columnMappingTable.getViewer().getTable().getSelectionIndex();
        if (index > -1 && index <= count - 2) {
            Object obj = this.columnMappingList.get(index);
            this.columnMappingList.set(index, this.columnMappingList.get(index + 1));
            this.columnMappingList.set(index + 1, obj);
            String str = XMLRelationInfoUtil.replaceInfo(this.tableName, this.saveQueryString(), XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", str);
            this.refreshColumnMappingViewer();
            this.resetUpDownButton();
        }
    }

    private void populateXMLTree() {
        if (!(this.xsdFileName != null && this.xsdFileName.trim().length() != 0 || this.xmlFileName != null && this.xmlFileName.trim().length() != 0)) {
            return;
        }
        try {
            this.treeNode = null;
            this.availableXmlTree.getTree().removeAll();
            int numberOfElement = 0;
            Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
            if (preferences.contains("user_max_num_of_element_passed")) {
                numberOfElement = preferences.getInt("user_max_num_of_element_passed");
            } else {
                numberOfElement = 100000;
                preferences.setValue("user_max_num_of_element_passed", numberOfElement);
            }
            this.treeNode = SchemaPopulationUtil.getSchemaTree((String)this.xsdFileName, (String)this.xmlFileName, (String)this.xmlEncoding, (int)numberOfElement);
            this.availableXmlTree.populateTree(this.treeNode, this.selectedTreeItemText, true);
            TreeItem[] selectedMultiItems = this.availableXmlTree.getTree().getSelection();
            if (selectedMultiItems == null || selectedMultiItems.length == 0) {
                this.availableXmlTree.getSingleButton().setEnabled(false);
                this.availableXmlTree.getMultiButton().setEnabled(false);
                this.setMessage(Messages.getString("error.columnMapping.tableMappingXPathNotExist"), 3);
            } else {
                this.availableXmlTree.getSingleButton().setEnabled(true);
                this.availableXmlTree.getMultiButton().setEnabled(true);
                this.setMessage(DEFAULT_PAGE_Message);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage(), e);
            this.setMessage(Messages.getString("error.columnMapping.createPage"), 3);
        }
    }

    private void setupEditors() {
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.columnMappingTable.getViewer().getTable(), 0), new TextCellEditor((Composite)this.columnMappingTable.getViewer().getTable(), 0), new ComboBoxCellEditor((Composite)this.columnMappingTable.getViewer().getTable(), dataTypeDisplayNames, 8)};
        this.columnMappingTable.getViewer().setCellEditors(editors);
        this.columnMappingTable.getViewer().setColumnProperties(new String[]{COLUMN_NAME, XPATH_NAME, TYPE_NAME});
        this.columnMappingTable.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ColumnMappingPage.this.doEdit();
                ColumnMappingPage.this.resetUpDownButton();
            }
        });
    }

    private void refreshXMLConnection() {
        String str = XMLRelationInfoUtil.replaceInfo(this.tableName, this.saveQueryString(), XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
        if (str != null) {
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", str);
        }
    }

    public boolean performOk() {
        return this.isValid();
    }

    private boolean isValid() {
        String queryText = XMLInformationHolder.getPropertyValue("RELATIONINFORMATION");
        return queryText != null && queryText.trim().length() != 0;
    }

    private void setDetailsMessage(String message, int type) {
        this.setMessage(message, type);
    }

    private String saveQueryString() {
        if (!this.columnMappingList.isEmpty()) {
            String tablePath = LEFT_SQUARE_BRACKET + this.selectedTreeItemText + RIGHT_SQUARE_BRACKET;
            String queryString = String.valueOf(this.tableName) + "#:#" + tablePath + "#:#";
            String rowStr = EMPTY_STRING;
            Iterator rowObj = this.columnMappingList.iterator();
            while (rowObj.hasNext()) {
                ColumnMappingElement element = (ColumnMappingElement)rowObj.next();
                rowStr = LEFT_CURLY_BRACKET + element.getColumnName() + SEMICOLON + element.getTypeStandardString() + SEMICOLON + element.getXPath() + RIGHT_CURLY_BRACKET;
                if (rowObj.hasNext()) {
                    rowStr = String.valueOf(rowStr) + COMMA;
                }
                queryString = String.valueOf(queryString) + rowStr;
            }
            String nameSpaceString = this.getNamespace();
            if (nameSpaceString == null || nameSpaceString.trim().length() == 0) {
                return queryString;
            }
            return String.valueOf(queryString) + "#:#" + nameSpaceString;
        }
        return null;
    }

    public boolean performCancel() {
        return true;
    }

    private void refreshColumnMappingViewer() {
        this.columnMappingTable.getViewer().setInput((Object)this.columnMappingList);
        int i = 0;
        while (i < this.columnMappingTable.getViewer().getTable().getItemCount() - 1) {
            TableItem ti = this.columnMappingTable.getViewer().getTable().getItem(i);
            Object element = ti.getData();
            String c1 = EMPTY_STRING;
            String c2 = EMPTY_STRING;
            String c3 = EMPTY_STRING;
            if (element instanceof ColumnMappingElement) {
                ColumnMappingElement colElement = (ColumnMappingElement)element;
                c1 = colElement.getColumnName() == null ? EMPTY_STRING : colElement.getColumnName();
                c2 = colElement.getXPath() == null ? EMPTY_STRING : "version@/";
                c3 = colElement.getType() == null ? EMPTY_STRING : colElement.getType();
            }
            ti.setText(0, c1);
            ti.setText(1, c2);
            ti.setText(2, c3);
            ++i;
        }
        this.columnMappingTable.getViewer().refresh();
    }

    public String getToolTip() {
        return null;
    }

    public void setSchemaFile(String fileName) {
        this.xsdFileName = fileName;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = null;
        try {
            switch (columnIndex) {
                case 0: {
                    value = ((ColumnMappingElement)element).getColumnName();
                    break;
                }
                case 1: {
                    value = TextProcessor.process((String)((ColumnMappingElement)element).getXPath(), (String)"/");
                    break;
                }
                case 2: {
                    value = ((ColumnMappingElement)element).getType();
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, ex.getMessage(), ex);
            ExceptionHandler.showException(this.getShell(), Messages.getString("error.label"), ex.getMessage(), ex);
        }
        if (value == null) {
            value = EMPTY_STRING;
        }
        return value;
    }

    private void setPageProperties() {
        boolean columnMappingExist = false;
        boolean dataFileExist = true;
        String dataSourceXmlDataFile = XMLInformationHolder.getPropertyValue("FILELIST");
        String dataSetXmlDataFile = XMLInformationHolder.getPropertyValue("XML_FILE");
        if (dataSetXmlDataFile == null || dataSetXmlDataFile.toString().length() == 0) {
            dataFileExist = false;
        }
        if (!dataFileExist && dataSourceXmlDataFile != null && dataSourceXmlDataFile.toString().trim().length() > 0) {
            dataFileExist = true;
        }
        columnMappingExist = this.columnMappingList != null && this.columnMappingList.size() > 0;
        this.enableAllTableSideButtons(columnMappingExist && this.columnMappingTable.getViewer().getTable().getSelectionCount() > 0);
        this.columnMappingTable.getRemoveMenuItem().setEnabled(columnMappingExist);
        this.columnMappingTable.getRemoveAllMenuItem().setEnabled(columnMappingExist);
        this.setPageComplete(columnMappingExist);
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        try {
            this.savePage(design);
        }
        catch (OdaException e) {
            logger.log(Level.INFO, e.getMessage(), e);
        }
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) throws OdaException {
        if (XMLInformationHolder.hasDestroyed()) {
            return;
        }
        if (dataSetDesign != null) {
            if (this.getQueryText(dataSetDesign) == null) {
                this.setQueryText(dataSetDesign, XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
            }
            if (this.getQueryText(dataSetDesign) != null && !this.getQueryText(dataSetDesign).equals(XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"))) {
                this.setQueryText(dataSetDesign, XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
                this.updateDesign(dataSetDesign);
            }
        }
    }

    private String getNamespace() {
        Map prefixMapping = null;
        boolean start = true;
        try {
            prefixMapping = this.xsdFileName != null && this.xsdFileName.trim().length() > 0 ? SchemaPopulationUtil.getPrefixMapping((String)this.xsdFileName, (String)this.xmlEncoding) : SchemaPopulationUtil.getPrefixMapping((String)this.xmlFileName, (String)this.xmlEncoding);
        }
        catch (OdaException odaException) {
            return null;
        }
        StringBuffer nameSpaceBuf = new StringBuffer();
        if (prefixMapping.size() > 0) {
            nameSpaceBuf.append(LEFT_SHARP_ANGLED_BRACKET);
            Iterator entryIter = prefixMapping.entrySet().iterator();
            while (entryIter.hasNext()) {
                Map.Entry entry = entryIter.next();
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (!start) {
                    nameSpaceBuf.append(";\"" + key + DOUBLE_QUOTE + COMMA + DOUBLE_QUOTE + value + DOUBLE_QUOTE);
                    continue;
                }
                nameSpaceBuf.append(DOUBLE_QUOTE + key + DOUBLE_QUOTE + COMMA + DOUBLE_QUOTE + value + DOUBLE_QUOTE);
                start = false;
            }
            nameSpaceBuf.append(RIGHT_SHARP_ANGLED_BRACKET);
        }
        return nameSpaceBuf.toString();
    }

    protected void updateDesign(DataSetDesign dataSetDesign) {
        DataSetDesignPopulator.populateResultSet(dataSetDesign);
    }

    protected String getQueryText(DataSetDesign dataSetDesign) {
        return dataSetDesign.getQueryText();
    }

    protected void setQueryText(DataSetDesign dataSetDesign, String queryText) {
        dataSetDesign.setQueryText(queryText);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    protected void cleanup() {
        XMLInformationHolder.destory();
    }

    private ColumnMappingElement createSingleElement(ATreeNode node, String path) {
        ColumnMappingElement columnElement = new ColumnMappingElement();
        columnElement.setColumnName(node.getValue().toString());
        columnElement.setXPath(path);
        String type = null;
        try {
            type = DataTypeUtil.getDataTypeDisplayName(DataTypes.getType((String)node.getDataType()));
        }
        catch (OdaException odaException) {
            type = DataTypeUtil.getDataTypeDisplayName(12);
        }
        columnElement.setType(type);
        return columnElement;
    }

    private void updateColumnMappingElement(ColumnMappingElement columnElement) {
        this.addNewColumnElement(columnElement);
        this.refreshColumnMappingViewer();
        this.setPageProperties();
    }

    private void addNewColumnElement(ColumnMappingElement columnElement) {
        int index = 0;
        String columnName = columnElement.getColumnName();
        while (!this.isUniqueName(columnName, columnElement)) {
            String alias = String.valueOf(columnName) + UNDERSCORE + ++index;
            if (!this.isUniqueName(alias, columnElement)) continue;
            columnElement.setColumnName(alias);
            this.columnMap.put(alias, columnElement);
            break;
        }
        if (index == 0) {
            this.columnMap.put(columnName, columnElement);
        }
        this.columnMappingList.add(columnElement);
        this.setXMLInformationHolderProps();
    }

    private void setXMLInformationHolderProps() {
        String relationInfo = XMLInformationHolder.getPropertyValue("RELATIONINFORMATION");
        if (relationInfo != null && relationInfo.trim().length() > 0) {
            String tableInfo = XMLRelationInfoUtil.getTableRelationInfo(relationInfo, this.tableName);
            if (tableInfo != null && tableInfo.trim().length() > 0) {
                XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", XMLRelationInfoUtil.replaceInfo(this.tableName, this.saveQueryString(), relationInfo));
            } else {
                XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", XMLRelationInfoUtil.concatRelationInfo(relationInfo, this.saveQueryString()));
            }
        } else {
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", this.saveQueryString());
        }
    }

    private boolean handleSelectedItem(TreeItem selectedItem, HashSet selectedNodes) {
        if (selectedItem.getData() != null && selectedItem.getData() instanceof TreeNodeData) {
            ATreeNode aTreeNode = ((TreeNodeData)selectedItem.getData()).getTreeNode();
            if (selectedNodes != null && !selectedNodes.contains(aTreeNode)) {
                this.addChildrenElements(aTreeNode, selectedNodes);
            }
            return true;
        }
        return false;
    }
}

