/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLAdvisor {
    public static final String RE_DELIMITER_OPEARTION = "\\Q$-$\\E";
    public static final String XML_DECLARATION = "<?xml version=\"1.0\"?>";
    public static final String SOAP_ENVELOPE_START = "<SOAP-ENV:Envelope";
    public static final String SOAP_ENVELOPE_END = "</SOAP-ENV:Envelope>";
    public static final String SOAP_HEADER_START = "<SOAP-ENV:Header>";
    public static final String SOAP_HEADER_END = "</SOAP-ENV:Header>";
    public static final String SOAP_BODY_START = "<SOAP-ENV:Body>";
    public static final String SOAP_BODY_END = "</SOAP-ENV:Body>";
    public static final String NS_SOAP_ENV = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String NS_SOAP_ENC = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String NS_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_KEY_SOAP_ENV = "SOAP-ENV";
    public static final String NS_KEY_SOAP_ENC = "SOAP-ENC";
    public static final String NS_KEY_XSI = "xsi";
    public static final String NS_KEY_XSD = "xsd";
    public static final String NS_KEY_DEFAULT = "m";
    public static final String NS_DEFAULT = "m:";
    public static final String EMPTY_STRING = "";
    private static Map definitionMap = new HashMap();
    private static List primitiveDataTypeList;

    public static Definition getDefinition(String wsdlURI) {
        Definition definition;
        if (definitionMap.containsKey(wsdlURI)) {
            return (Definition)definitionMap.get(wsdlURI);
        }
        try {
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", true);
            reader.setFeature("javax.wsdl.importDocuments", true);
            definition = reader.readWSDL(null, wsdlURI);
            definitionMap.put(wsdlURI, definition);
        }
        catch (WSDLException e) {
            return null;
        }
        return definition;
    }

    public static String getLocationURI(String wsdlURI, String operationTrace) {
        if (!WSDLAdvisor.checkOperationTrace(operationTrace)) {
            return null;
        }
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        if (WSUtil.isNull(definition)) {
            return null;
        }
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        Service service = definition.getService(new QName(definition.getTargetNamespace(), opSplit[0]));
        if (WSUtil.isNull(service)) {
            return null;
        }
        Port port = service.getPort(opSplit[1]);
        List extElements = port.getExtensibilityElements();
        String locationURI = EMPTY_STRING;
        if (!WSUtil.isNull(extElements)) {
            for (int i = 0; i < extElements.size(); ++i) {
                if (!(extElements.get(i) instanceof SOAPAddress)) continue;
                locationURI = ((SOAPAddress)extElements.get(i)).getLocationURI();
                break;
            }
        }
        return locationURI;
    }

    private static boolean checkOperationTrace(String operationTrace) {
        if (WSUtil.isNull(operationTrace)) {
            return false;
        }
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        return opSplit.length == 3;
    }

    public static String getSOAPActionURI(String wsdlURI, String operationTrace) {
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return null;
        }
        List extElements = bindingOperation.getExtensibilityElements();
        String soapActionURI = EMPTY_STRING;
        if (!WSUtil.isNull(extElements)) {
            for (int i = 0; i < extElements.size(); ++i) {
                if (!(extElements.get(i) instanceof SOAPOperation)) continue;
                soapActionURI = ((SOAPOperation)extElements.get(i)).getSoapActionURI();
                break;
            }
        }
        return soapActionURI;
    }

    public static String retrieveDocument(Operation operation) {
        String result = EMPTY_STRING;
        if (WSUtil.isNull(operation)) {
            return result;
        }
        Element element = operation.getDocumentationElement();
        if (!WSUtil.isNull(element)) {
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 3) continue;
                result = result + node.getNodeValue();
            }
        }
        return result;
    }

    private static BindingOperation getBindingOperation(String wsdlURI, String operationTrace) {
        if (!WSDLAdvisor.checkOperationTrace(operationTrace)) {
            return null;
        }
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        if (WSUtil.isNull(definition)) {
            return null;
        }
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        Service service = definition.getService(new QName(definition.getTargetNamespace(), opSplit[0]));
        if (WSUtil.isNull(service)) {
            return null;
        }
        Port port = service.getPort(opSplit[1]);
        BindingOperation bindingOperation = port.getBinding().getBindingOperation(opSplit[2], null, null);
        return bindingOperation;
    }

    public static String getSOAPRequestTemplate(String wsdlURI, String operationTrace) {
        String template = EMPTY_STRING;
        if (!WSDLAdvisor.checkOperationTrace(operationTrace)) {
            return template;
        }
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        if (WSUtil.isNull(definition)) {
            return template;
        }
        template = WSDLAdvisor.buildStart() + WSDLAdvisor.buildHeader(wsdlURI, operationTrace) + WSDLAdvisor.buildBody(wsdlURI, operationTrace) + WSDLAdvisor.buildEnd();
        return template;
    }

    private static String buildStart() {
        return XML_DECLARATION + WSDLAdvisor.enter() + SOAP_ENVELOPE_START + WSDLAdvisor.buildNamespaceDeclarations();
    }

    private static String buildEnd() {
        return WSDLAdvisor.enter() + WSDLAdvisor.tab(1) + SOAP_BODY_END + WSDLAdvisor.enter() + SOAP_ENVELOPE_END;
    }

    private static String enter() {
        return "\n";
    }

    private static String tab(int num) {
        String tabs = EMPTY_STRING;
        for (int i = 0; i < num; ++i) {
            tabs = tabs + "\t";
        }
        return tabs;
    }

    private static String buildNamespaceDeclarations() {
        HashMap namespaceURIs = new HashMap();
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_SOAP_ENV, NS_SOAP_ENV);
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_SOAP_ENC, NS_SOAP_ENC);
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_XSI, NS_XSI);
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_XSD, NS_XSD);
        String result = EMPTY_STRING;
        Set uris = namespaceURIs.keySet();
        Iterator iterator = uris.iterator();
        while (iterator.hasNext()) {
            String uri = (String)iterator.next();
            String prefix = (String)namespaceURIs.get(uri);
            result = result + WSDLAdvisor.enter() + "xmlns:" + prefix + "=\"" + uri + "\"";
        }
        return result + ">";
    }

    private static void checkNamespace(Map namespaceURIs, String namespace, String namespaceURI) {
        String resultNS = namespace;
        if (namespaceURI != null && (resultNS = (String)namespaceURIs.get(namespaceURI)) == null) {
            resultNS = namespace;
            while (namespaceURIs.containsValue(resultNS)) {
                resultNS = resultNS + "_" + Integer.toString(namespaceURIs.size());
            }
            namespaceURIs.put(namespaceURI, resultNS);
        }
    }

    private static String buildHeader(String wsdlURI, String operationTrace) {
        String result = EMPTY_STRING;
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return result;
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        List extElements = bindingInput.getExtensibilityElements();
        if (!WSUtil.isNull(extElements)) {
            for (int i = 0; i < extElements.size(); ++i) {
                if (!(extElements.get(i) instanceof SOAPHeader)) continue;
                SOAPHeader soapHeader = (SOAPHeader)extElements.get(i);
                String nameSpace = soapHeader.getMessage().getNamespaceURI();
                String localPart = soapHeader.getPart();
                if (WSUtil.isNull(localPart)) break;
                ArrayList paramNameList = new ArrayList();
                ArrayList paramTypeList = new ArrayList();
                WSDLAdvisor.addParamComplexType(wsdlURI, localPart, paramNameList, paramTypeList);
                result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(1) + SOAP_HEADER_START;
                result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + NS_DEFAULT + localPart + " " + WSDLAdvisor.getQNameSpace(nameSpace) + ">";
                result = result + WSDLAdvisor.buildInputParameters(wsdlURI, NS_DEFAULT, paramNameList, paramTypeList, 3);
                result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + NS_DEFAULT + localPart + ">";
                result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(1) + SOAP_HEADER_END;
                break;
            }
        }
        return result;
    }

    private static void addParamComplexType(String wsdlURI, String localPart, List paramNameList, List paramTypeList) {
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        Types types = definition.getTypes();
        List extElements = types.getExtensibilityElements();
        for (int i = 0; i < extElements.size(); ++i) {
            if (!(extElements.get(i) instanceof UnknownExtensibilityElement)) continue;
            Element element = ((UnknownExtensibilityElement)extElements.get(i)).getElement();
            List teList = WSDLAdvisor.retrieveTargetElementList(element, localPart);
            for (int j = 0; j < teList.size(); ++j) {
                Element te = (Element)teList.get(j);
                if (WSUtil.isNull(te)) continue;
                paramNameList.add(te.getAttribute("name"));
                paramTypeList.add(te.getAttribute("type"));
            }
        }
    }

    private static List retrieveTargetElementList(Element element, String localPart) {
        ArrayList teList = new ArrayList();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap nodeMap;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || WSUtil.isNull(nodeMap = node.getAttributes()) || WSUtil.isNull(nodeMap.getNamedItem("name")) || !localPart.equalsIgnoreCase(nodeMap.getNamedItem("name").getNodeValue())) continue;
            if (WSUtil.isNull(nodeMap.getNamedItem("type"))) {
                WSDLAdvisor.retrieveNamedElements(teList, node);
                continue;
            }
            WSDLAdvisor.retrieveTargetElementList(element, nodeMap.getNamedItem("type").getNodeName());
        }
        return teList;
    }

    private static void retrieveNamedElements(List teList, Node node) {
        NodeList subs = node.getChildNodes();
        for (int i = 0; i < subs.getLength(); ++i) {
            Node sub = subs.item(i);
            if (sub.getNodeType() != 1) continue;
            NamedNodeMap subMap = sub.getAttributes();
            if (WSUtil.isNull(subMap) || WSUtil.isNull(subMap.getNamedItem("name"))) {
                WSDLAdvisor.retrieveNamedElements(teList, sub);
                continue;
            }
            teList.add((Element)sub);
        }
    }

    private static String buildInputParameters(String wsdlURI, String nameSpace, List paramNames, List paramTypes, int tabCount) {
        String result = EMPTY_STRING;
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = paramNames.get(i).toString();
            String paramType = paramTypes.get(i).toString();
            if (!WSDLAdvisor.isPrimitiveDataType(paramType)) {
                ArrayList paramNameList = new ArrayList();
                ArrayList paramTypeList = new ArrayList();
                WSDLAdvisor.addParamComplexType(wsdlURI, WSDLAdvisor.getParamTypeLocalPart(paramType), paramNameList, paramTypeList);
                if (paramNameList.isEmpty() && paramTypeList.isEmpty()) {
                    result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + ">&?" + paramName + "?&</" + nameSpace + paramName + ">";
                    continue;
                }
                result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + ">";
                result = result + WSDLAdvisor.buildInputParameters(wsdlURI, nameSpace, paramNameList, paramTypeList, tabCount + 1);
                result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "</" + nameSpace + paramName + ">";
                continue;
            }
            result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + WSDLAdvisor.buildParamType(paramType) + ">&?" + paramName + "?&</" + nameSpace + paramName + ">";
        }
        return result;
    }

    private static String getParamTypeLocalPart(String paramType) {
        return paramType.substring(paramType.lastIndexOf(":") + 1);
    }

    private static String buildParamType(String paramType) {
        String result = EMPTY_STRING;
        if (WSUtil.isNull(paramType)) {
            return result;
        }
        result = result + " xsi:type=\"xsd:" + WSDLAdvisor.getParamTypeLocalPart(paramType) + "\"";
        return result;
    }

    private static String buildBody(String wsdlURI, String operationTrace) {
        String result = WSDLAdvisor.enter() + WSDLAdvisor.tab(1) + SOAP_BODY_START;
        result = WSDLAdvisor.isRPC(wsdlURI, operationTrace) ? result + WSDLAdvisor.buildBodyRPC(wsdlURI, operationTrace) : result + WSDLAdvisor.buildBodyDoc(wsdlURI, operationTrace);
        return result;
    }

    private static boolean isRPC(String wsdlURI, String operationTrace) {
        boolean isRPC = false;
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        Service service = definition.getService(new QName(definition.getTargetNamespace(), opSplit[0]));
        Port port = service.getPort(opSplit[1]);
        Binding binding = port.getBinding();
        List extElements = binding.getExtensibilityElements();
        if (!WSUtil.isNull(extElements)) {
            for (int i = 0; i < extElements.size(); ++i) {
                if (!(extElements.get(i) instanceof SOAPBinding)) continue;
                isRPC = !WSUtil.isNull(((SOAPBinding)extElements.get(i)).getStyle()) && ((SOAPBinding)extElements.get(i)).getStyle().equalsIgnoreCase("rpc");
                break;
            }
        }
        return isRPC;
    }

    private static String buildBodyRPC(String wsdlURI, String operationTrace) {
        String result = EMPTY_STRING;
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return result;
        }
        Operation operation = bindingOperation.getOperation();
        List partOrder = operation.getParameterOrdering();
        List parts = operation.getInput().getMessage().getOrderedParts(partOrder);
        if (!WSUtil.isNull(parts) && !parts.isEmpty()) {
            ArrayList<String> paramNameList = new ArrayList<String>();
            ArrayList<String> paramTypeList = new ArrayList<String>();
            for (int i = 0; i < parts.size(); ++i) {
                Part part = (Part)parts.get(i);
                QName typeName = part.getTypeName();
                paramNameList.add(part.getName());
                paramTypeList.add(WSUtil.getNonNullString(WSUtil.isNull(typeName) ? EMPTY_STRING : typeName.getLocalPart()));
            }
            result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + NS_DEFAULT + operation.getName() + " " + WSDLAdvisor.getQNameSpace(WSDLAdvisor.getNameSpaceRPC(bindingOperation)) + ">";
            result = result + WSDLAdvisor.buildInputParameters(wsdlURI, EMPTY_STRING, paramNameList, paramTypeList, 3);
            result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + NS_DEFAULT + operation.getName() + ">";
        }
        return result;
    }

    private static String getNameSpaceRPC(BindingOperation bindingOperation) {
        BindingInput bindingInput = bindingOperation.getBindingInput();
        List extElements = bindingInput.getExtensibilityElements();
        String nameSpace = EMPTY_STRING;
        if (!WSUtil.isNull(extElements)) {
            for (int i = 0; i < extElements.size(); ++i) {
                if (!(extElements.get(i) instanceof SOAPBody)) continue;
                nameSpace = ((SOAPBody)extElements.get(i)).getNamespaceURI();
                break;
            }
        }
        return nameSpace;
    }

    private static String getQNameSpace(String nameSpace) {
        if (WSUtil.isNull(nameSpace)) {
            return EMPTY_STRING;
        }
        return "xmlns:m=\"" + nameSpace + "\"";
    }

    private static String buildBodyDoc(String wsdlURI, String operationTrace) {
        String result = EMPTY_STRING;
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return result;
        }
        Operation operation = bindingOperation.getOperation();
        List partOrder = operation.getParameterOrdering();
        List parts = operation.getInput().getMessage().getOrderedParts(partOrder);
        if (!WSUtil.isNull(parts) && !parts.isEmpty()) {
            for (int i = 0; i < parts.size(); ++i) {
                Part part = (Part)parts.get(i);
                if (WSUtil.isNull(part.getElementName())) continue;
                ArrayList paramNameList = new ArrayList();
                ArrayList paramTypeList = new ArrayList();
                WSDLAdvisor.addParamComplexType(wsdlURI, part.getElementName().getLocalPart(), paramNameList, paramTypeList);
                result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + NS_DEFAULT + part.getElementName().getLocalPart() + " " + WSDLAdvisor.getQNameSpace(WSDLAdvisor.getNameSpaceDoc(wsdlURI)) + ">";
                result = result + WSDLAdvisor.buildInputParameters(wsdlURI, NS_DEFAULT, paramNameList, paramTypeList, 3);
                result = result + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + NS_DEFAULT + part.getElementName().getLocalPart() + ">";
            }
        }
        return result;
    }

    private static String getNameSpaceDoc(String wsdlURI) {
        String namespace = EMPTY_STRING;
        Definition definition = WSDLAdvisor.getDefinition(wsdlURI);
        Types types = definition.getTypes();
        List extElements = types.getExtensibilityElements();
        for (int i = 0; i < extElements.size(); ++i) {
            if (!(extElements.get(i) instanceof UnknownExtensibilityElement)) continue;
            Element element = ((UnknownExtensibilityElement)extElements.get(i)).getElement();
            namespace = element.getAttribute("targetNamespace");
            return namespace;
        }
        return namespace;
    }

    private static boolean isPrimitiveDataType(String dataType) {
        if (WSUtil.isNull(dataType)) {
            return true;
        }
        return WSDLAdvisor.getDataTypeList().contains(dataType.substring(dataType.indexOf(":") + 1).toLowerCase());
    }

    private static List getDataTypeList() {
        if (WSUtil.isNull(primitiveDataTypeList)) {
            primitiveDataTypeList = new ArrayList();
        }
        if (primitiveDataTypeList.isEmpty()) {
            WSDLAdvisor.initDataTypeList();
        }
        return primitiveDataTypeList;
    }

    private static void initDataTypeList() {
        primitiveDataTypeList.add("short");
        primitiveDataTypeList.add("int");
        primitiveDataTypeList.add("float");
        primitiveDataTypeList.add("double");
        primitiveDataTypeList.add("decimal");
        primitiveDataTypeList.add("string");
        primitiveDataTypeList.add("boolean");
        primitiveDataTypeList.add("datetime ");
        primitiveDataTypeList.add("date");
        primitiveDataTypeList.add("time");
    }
}

