/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.util;

import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.enablement.oda.ws.impl.Driver;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPParameter;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSConsole;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;

public class WSUIUtil
extends WSUtil {
    public static void checkExisted(DataSetDesign design) {
        if (design.getPublicProperties() == null) {
            try {
                design.setPublicProperties(DesignSessionUtil.createDataSetPublicProperties((String)design.getOdaExtensionDataSourceId(), (String)design.getOdaExtensionDataSetId(), (Properties)new Properties()));
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        }
        if (design.getPrivateProperties() == null) {
            try {
                design.setPrivateProperties(DesignSessionUtil.createDataSetNonPublicProperties((String)design.getOdaExtensionDataSourceId(), (String)design.getOdaExtensionDataSetId(), (Properties)WSUIUtil.getDataSetInitialPrivateProperties()));
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
        }
    }

    private static Properties getDataSetInitialPrivateProperties() {
        Properties props = new Properties();
        props.setProperty("operationTrace", "");
        props.setProperty("xmlQueryText", "");
        return props;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void savePage(DataSetDesign dataSetDesign) {
        if (!WSConsole.getInstance().isSessionOK()) {
            return;
        }
        IConnection conn = null;
        try {
            try {
                Driver driver = new Driver();
                conn = driver.getConnection(null);
                Properties connProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)dataSetDesign.getDataSourceDesign());
                conn.open(connProps);
                WSUIUtil.updateDesign(dataSetDesign, conn, dataSetDesign.getQueryText());
            }
            catch (OdaException e) {
                dataSetDesign.setResultSets(null);
                dataSetDesign.setParameters(null);
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            WSUIUtil.closeConnection(conn);
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        WSUIUtil.closeConnection(conn);
    }

    private static void updateDesign(DataSetDesign dataSetDesign, IConnection conn, String queryText) throws OdaException {
        IQuery query = conn.newQuery(null);
        query.prepare(queryText);
        SOAPParameter[] soapParameters = WSConsole.getInstance().getParameters();
        if (!WSUIUtil.isNull((Object)soapParameters)) {
            int i = 0;
            while (i < soapParameters.length) {
                if (!WSUIUtil.isNull((Object)soapParameters[i])) {
                    query.setString(soapParameters[i].getId(), soapParameters[i].getDefaultValue());
                }
                ++i;
            }
        }
        query.setProperty("xmlQueryText", dataSetDesign.getPrivateProperties().getProperty("xmlQueryText"));
        query.setProperty("operationTrace", WSConsole.getInstance().getPropertyValue("operationTrace"));
        try {
            IResultSetMetaData md = query.getMetaData();
            WSUIUtil.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException odaException) {
            dataSetDesign.setResultSets(null);
        }
        try {
            IParameterMetaData paramMd = query.getParameterMetaData();
            WSUIUtil.updateParameterDesign(paramMd, dataSetDesign);
        }
        catch (OdaException odaException) {
            dataSetDesign.setParameters(null);
        }
    }

    private static void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private static void updateParameterDesign(IParameterMetaData paramMd, DataSetDesign dataSetDesign) throws OdaException {
        DataSetParameters paramDesign = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)paramMd, (ParameterMode)DesignSessionUtil.toParameterModeDesign((int)1));
        dataSetDesign.setParameters(paramDesign);
        if (WSUIUtil.isNull((Object)paramDesign)) {
            return;
        }
        paramDesign.setDerivedMetaData(true);
        if (paramDesign.getParameterDefinitions().size() > 0) {
            WSConsole.getInstance().merge2ParameterDefinitions(paramDesign.getParameterDefinitions());
        }
    }

    private static void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }
}

