/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPParameter;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPRequest;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPResponse;
import org.eclipse.datatools.enablement.oda.ws.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.datatools.enablement.oda.ws.util.Java2SOAPManager;
import org.eclipse.datatools.enablement.oda.ws.util.RawMessageSender;
import org.eclipse.datatools.enablement.oda.ws.util.WSDLAdvisor;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLInformationHolder;
import org.eclipse.emf.common.util.EList;

public class WSConsole {
    private static String XML_TEMP_FILE = "xmlTempFile";
    private static WSConsole instance;
    private Properties props;
    private SOAPParameter[] parameters;
    private boolean isSessionOK = false;
    private static final int BACKWARD = 0;
    private static final int FORWARD = 1;
    private File templateFile;
    private File sampleXMLFile;

    public static synchronized WSConsole getInstance() {
        if (instance == null) {
            instance = new WSConsole();
        }
        return instance;
    }

    public String getPropertyValue(String key) {
        if (this.props == null) {
            return null;
        }
        return this.props.getProperty(key);
    }

    public void setPropertyValue(String key, String value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        if (value != null) {
            this.props.setProperty(key, value);
        }
    }

    public String getXMLPropertyValue(String key) {
        return XMLInformationHolder.getPropertyValue((String)key);
    }

    public void setXMLPropertyValue(String key, String value) {
        XMLInformationHolder.setPropertyValue((String)key, (String)value);
    }

    public void start(DataSetDesign dataSetDesign) {
        if (dataSetDesign == null) {
            return;
        }
        this.startWS(dataSetDesign);
        this.startXML(dataSetDesign);
        this.isSessionOK = true;
    }

    private void startWS(DataSetDesign dataSetDesign) {
        DataSetParameters params;
        String queryText = dataSetDesign.getQueryText();
        if (queryText != null && queryText.trim().length() > 0) {
            this.setPropertyValue("wsQueryText", queryText);
        }
        if ((params = dataSetDesign.getParameters()) != null) {
            this.initSOAPParameters(params);
        }
        if (dataSetDesign.getPublicProperties() != null) {
            String xmlFileURI = dataSetDesign.getPublicProperties().getProperty("xmlFileURI");
            this.setPropertyValue("xmlFileURI", xmlFileURI == null ? "" : xmlFileURI);
            String xsdFileURI = dataSetDesign.getPublicProperties().getProperty("xsdFileURI");
            this.setPropertyValue("xsdFileURI", xmlFileURI == null ? "" : xsdFileURI);
        }
        if (dataSetDesign.getPrivateProperties() != null) {
            String operationTrace = dataSetDesign.getPrivateProperties().getProperty("operationTrace");
            this.setPropertyValue("operationTrace", operationTrace == null ? "" : operationTrace);
            String xmlQueryText = dataSetDesign.getPrivateProperties().getProperty("xmlQueryText");
            this.setPropertyValue("xmlQueryText", xmlQueryText == null ? "" : xmlQueryText);
        }
        if (dataSetDesign.getDataSourceDesign() != null) {
            DataSourceDesign dataSourceDesign = dataSetDesign.getDataSourceDesign();
            Properties props = null;
            try {
                props = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)dataSourceDesign);
            }
            catch (OdaException odaException) {
                props = new Properties();
            }
            String soapEndPoint = props.getProperty("soapEndPoint", "");
            this.setPropertyValue("soapEndPoint", soapEndPoint);
            String customConnectionClass = props.getProperty("connectionClass", "");
            this.setPropertyValue("connectionClass", customConnectionClass);
            String customDriverPath = props.getProperty("driverClassPath", "");
            this.setPropertyValue("driverClassPath", customDriverPath);
            String connectionTimeOut = props.getProperty("connectionTimeOut", "0");
            this.setPropertyValue("connectionTimeOut", connectionTimeOut);
            String wsdlURI = props.getProperty("wsdlURI", "");
            this.setPropertyValue("wsdlURI", wsdlURI);
        }
    }

    private void startXML(DataSetDesign dataSetDesign) {
        String queryText;
        if (dataSetDesign.getPrivateProperties() != null && (queryText = dataSetDesign.getPrivateProperties().findProperty("xmlQueryText").getValue()) != null && queryText.trim().length() > 0) {
            this.setXMLPropertyValue("RELATIONINFORMATION", queryText);
            String tableName = XMLRelationInfoUtil.getTableName((String)queryText);
            this.setXMLPropertyValue("TABLENAME", tableName);
            String xpath = XMLRelationInfoUtil.getXPathExpression((String)queryText, (String)tableName);
            this.setXMLPropertyValue("XPATHTEXT", xpath);
        }
        if (dataSetDesign.getPublicProperties() != null) {
            String xmlFile = dataSetDesign.getPublicProperties().getProperty("xmlFileURI");
            this.setXMLPropertyValue("FILELIST", xmlFile == null ? "" : xmlFile);
            String schema = dataSetDesign.getPublicProperties().getProperty("xsdFileURI");
            this.setXMLPropertyValue("SCHEMAFILELIST", schema == null ? "" : schema);
        }
        this.setXMLPropertyValue("MAX_ROW", "-1");
    }

    public void end() {
        instance = null;
    }

    public void terminateSession() {
        this.isSessionOK = false;
        this.props = null;
        this.parameters = null;
        if (this.sampleXMLFile != null && !this.sampleXMLFile.delete()) {
            this.sampleXMLFile.deleteOnExit();
        }
        if (this.templateFile != null && !this.templateFile.delete()) {
            this.templateFile.deleteOnExit();
        }
        XMLInformationHolder.destory();
    }

    public boolean isSessionOK() {
        return this.isSessionOK;
    }

    public SOAPParameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(SOAPParameter[] soapParameters) {
        this.parameters = soapParameters;
    }

    public String getTemplate() {
        WSDLAdvisor wsdlAdvisor = new WSDLAdvisor();
        return wsdlAdvisor.getSOAPRequestTemplate(this.getPropertyValue("wsdlURI"), this.getPropertyValue("operationTrace"));
    }

    public void updateXSDFileURI() {
        String xsdFileURI = WSUIUtil.getNonNullString((String)this.getPropertyValue("xsdFileURI"));
        if (!xsdFileURI.equals(this.getXMLPropertyValue("SCHEMAFILELIST"))) {
            this.setXMLPropertyValue("SCHEMAFILELIST", xsdFileURI);
        }
    }

    public void updateXMLFileURI() throws OdaException {
        String xmlFileURI = this.getPropertyValue("xmlFileURI");
        if (!WSUIUtil.isNull((Object)xmlFileURI)) {
            if (!xmlFileURI.equals(this.getXMLPropertyValue("FILELIST"))) {
                this.setXMLPropertyValue("FILELIST", xmlFileURI);
            }
            return;
        }
        String xmlTempFileURI = this.getPropertyValue("xmlTempFileURI");
        if (WSUIUtil.isNull((Object)xmlTempFileURI)) {
            this.createXMLTempFileURI();
            xmlTempFileURI = this.getPropertyValue("xmlTempFileURI");
        }
        if (!WSUIUtil.isNull((Object)xmlTempFileURI) && !xmlTempFileURI.equals(this.getXMLPropertyValue("FILELIST"))) {
            this.setXMLPropertyValue("FILELIST", xmlTempFileURI);
        }
    }

    public void createXMLTempFileURI() throws OdaException {
        InputStream stream;
        String fileLocation;
        String string = fileLocation = this.getPropertyValue("xmlTempFileURI") == null ? null : this.getPropertyValue("xmlTempFileURI").toString();
        if (fileLocation != null && !new File(fileLocation).delete()) {
            new File(fileLocation).deleteOnExit();
        }
        if (WSUIUtil.isNull((Object)(stream = this.getInputStream(true)))) {
            return;
        }
        this.templateFile = this.generateTempXMLFile(stream);
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        if (this.templateFile != null) {
            String xmlTempFileURI = this.templateFile.getAbsolutePath();
            this.setPropertyValue("xmlTempFileURI", xmlTempFileURI);
        }
    }

    public void createSampleXMLFile() throws OdaException {
        String fileLocation;
        String string = fileLocation = this.getPropertyValue("XML_FILE") == null ? null : this.getPropertyValue("XML_FILE").toString();
        if (fileLocation != null && new File(fileLocation).delete()) {
            new File(fileLocation).deleteOnExit();
        }
        this.setXMLPropertyValue("XML_FILE", "");
        InputStream stream = this.getInputStream(false);
        if (WSUIUtil.isNull((Object)stream)) {
            return;
        }
        this.sampleXMLFile = this.generateTempXMLFile(stream);
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        if (this.sampleXMLFile != null) {
            String xmlTempFileURI = this.sampleXMLFile.getAbsolutePath();
            this.setPropertyValue("XML_FILE", xmlTempFileURI);
            this.setXMLPropertyValue("XML_FILE", xmlTempFileURI);
        }
    }

    private File generateTempXMLFile(InputStream stream) throws OdaException {
        File file;
        try {
            int abyte;
            file = File.createTempFile(XML_TEMP_FILE, null);
            file.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(file);
            BufferedInputStream bis = new BufferedInputStream(stream);
            while ((abyte = ((InputStream)bis).read()) != -1) {
                fos.write(abyte);
            }
            ((InputStream)bis).close();
            fos.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return file;
    }

    private InputStream getInputStream(boolean fromWSDL) throws OdaException {
        if (!WSUIUtil.isNull((Object)this.getPropertyValue("connectionClass"))) {
            return this.byCustom();
        }
        SOAPResponse soapResponse = this.connectNow(fromWSDL);
        if (soapResponse == null || soapResponse.getInputStream() == null) {
            throw new OdaException(Messages.getString("wsConsole.message.error.cantRetrieveSOAPResponse"));
        }
        return soapResponse.getInputStream();
    }

    private InputStream byCustom() throws OdaException {
        Java2SOAPManager j2s = new Java2SOAPManager();
        j2s.setConnectionProperties((Map)this.retrieveConnProperties());
        j2s.setQueryText(this.getPropertyValue("wsQueryText"));
        if (!WSUIUtil.isNull((Object)this.parameters)) {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            int i = 0;
            while (i < this.parameters.length) {
                parameterMap.put(this.parameters[i].getName(), this.parameters[i].getDefaultValue());
                ++i;
            }
            j2s.setParameterValues(parameterMap);
        }
        try {
            j2s.newQuery(this.getPropertyValue("connectionClass"), this.getPropertyValue("driverClassPath"));
            Object o = j2s.executeQuery();
            if (o instanceof InputStream) {
                return (InputStream)o;
            }
            if (o instanceof String) {
                return new ByteArrayInputStream(o.toString().getBytes());
            }
            return null;
        }
        catch (Exception e) {
            throw new OdaException((Throwable)e);
        }
    }

    private Properties retrieveConnProperties() {
        Properties p = new Properties();
        p.put("soapEndPoint", WSUIUtil.getNonNullString((String)this.getPropertyValue("soapEndPoint")));
        p.put("connectionClass", WSUIUtil.getNonNullString((String)this.getPropertyValue("connectionClass")));
        p.put("driverClassPath", WSUIUtil.getNonNullString((String)this.getPropertyValue("driverClassPath")));
        p.put("connectionTimeOut", WSUIUtil.getNonNullString((String)this.getPropertyValue("connectionTimeOut")));
        return p;
    }

    private SOAPResponse connectNow(boolean fromWSDL) throws OdaException {
        String spec = this.getPropertyValue("soapEndPoint");
        if (WSUIUtil.isNull((Object)spec)) {
            spec = WSDLAdvisor.getLocationURI((String)this.getPropertyValue("wsdlURI"), (String)this.getPropertyValue("operationTrace"));
        }
        String query = this.getPropertyValue("wsQueryText");
        if (WSUIUtil.isNull((Object)spec) || WSUIUtil.isNull((Object)query)) {
            return null;
        }
        SOAPRequest soapRequest = new SOAPRequest(query);
        this.populateSOAPParameterValues(soapRequest, this.parameters);
        SOAPResponse soapResponse = null;
        if (fromWSDL) {
            WSDLAdvisor wsdlAdvisor = new WSDLAdvisor();
            String temlate = wsdlAdvisor.getLocalSOAPResponseTemplate(this.getPropertyValue("wsdlURI"), this.getPropertyValue("operationTrace"));
            soapResponse = new SOAPResponse((InputStream)new ByteArrayInputStream(temlate.toString().getBytes()));
        } else {
            RawMessageSender rawMessageSender = new RawMessageSender();
            rawMessageSender.setMessage(soapRequest.toXML());
            String soapEndPoint = this.getPropertyValue("soapEndPoint");
            String wsdlURI = this.getPropertyValue("wsdlURI");
            String operationTrace = this.getPropertyValue("operationTrace");
            int connectionTimeout = Integer.parseInt(this.getPropertyValue("connectionTimeOut"));
            if (WSUtil.isNull((Object)soapEndPoint)) {
                soapEndPoint = WSDLAdvisor.getLocationURI((String)wsdlURI, (String)operationTrace);
            }
            rawMessageSender.setSpec(WSUtil.getNonNullString((String)soapEndPoint));
            rawMessageSender.setSoapAction(WSUtil.getNonNullString((String)WSDLAdvisor.getSOAPActionURI((String)wsdlURI, (String)operationTrace)));
            soapResponse = rawMessageSender.getSOAPResponse((long)connectionTimeout);
        }
        return soapResponse;
    }

    private void populateSOAPParameterValues(SOAPRequest soapRequest, SOAPParameter[] soapParameters) {
        if (WSUIUtil.isNull((Object)soapRequest) || WSUIUtil.isNull((Object)soapParameters)) {
            return;
        }
        int i = 0;
        while (i < soapParameters.length) {
            soapRequest.setParameterValue(soapParameters[i].getId(), soapParameters[i].getDefaultValue());
            ++i;
        }
    }

    public void initSOAPParameters(DataSetParameters dataSetParams) {
        EList parameterDefinitions = dataSetParams.getParameterDefinitions();
        if (WSUIUtil.isNull((Object)parameterDefinitions) || parameterDefinitions.size() == 0) {
            return;
        }
        this.parameters = new SOAPParameter[parameterDefinitions.size()];
        int i = 0;
        while (i < parameterDefinitions.size()) {
            ParameterDefinition paramDef = (ParameterDefinition)parameterDefinitions.get(i);
            this.parameters[i] = new SOAPParameter(i + 1, paramDef.getAttributes().getName(), paramDef.getDefaultScalarValue());
            ++i;
        }
    }

    public void merge2ParameterDefinitions(EList parameterDefinitions) {
        if (!this.canMerge(this.parameters, parameterDefinitions)) {
            return;
        }
        int i = 0;
        while (i < this.parameters.length) {
            if (!WSUIUtil.isNull((Object)this.parameters[i])) {
                ParameterDefinition paramDef = (ParameterDefinition)parameterDefinitions.get(i);
                paramDef.getAttributes().setName(this.parameters[i].getName());
                paramDef.setDefaultScalarValue(this.parameters[i].getDefaultValue());
            }
            ++i;
        }
    }

    private boolean canMerge(SOAPParameter[] soapParameters, EList parameterDefinitions) {
        if (soapParameters == null || parameterDefinitions == null) {
            return false;
        }
        return soapParameters.length == parameterDefinitions.size();
    }

    public String manipulateTemplate() {
        SOAPRequest soapRequest = new SOAPRequest(this.getPropertyValue("wsQueryText"));
        String[] template = soapRequest.getTemplate();
        if (WSUIUtil.isNull((Object)template) || WSUIUtil.isNull((Object)this.parameters)) {
            return this.getTemplate();
        }
        String wsQueryText = "";
        int i = 0;
        while (i < this.parameters.length) {
            wsQueryText = String.valueOf(wsQueryText) + template[i];
            wsQueryText = WSUIUtil.isNull((Object)this.parameters[i].getDefaultValue()) ? String.valueOf(wsQueryText) + this.buildParameter(this.parameters[i].getName()) : String.valueOf(wsQueryText) + this.parameters[i].getDefaultValue();
            ++i;
        }
        wsQueryText = String.valueOf(wsQueryText) + template[template.length - 1];
        StringBuffer buffer = new StringBuffer(wsQueryText);
        int i2 = 0;
        while (i2 < this.parameters.length) {
            if (!this.parameters[i2].isUsed()) {
                int offset = this.getOffset(wsQueryText, this.parameters[i2].getName());
                int start = this.getFirstIndex(wsQueryText, offset, 0, '<');
                start = this.getFirstIndex(wsQueryText, start, 0, '\n');
                int end = this.getFirstIndex(wsQueryText, offset, 1, '>');
                end = this.getFirstIndex(wsQueryText, end, 1, '\n');
                buffer.delete(start, end);
                wsQueryText = buffer.toString();
            }
            ++i2;
        }
        return wsQueryText;
    }

    private String buildParameter(String paramName) {
        return "&?" + paramName + "?&";
    }

    private int getOffset(String queryText, String paramName) {
        return queryText.indexOf(this.buildParameter(paramName));
    }

    private int getFirstIndex(String string, int index, int dir, char ch) {
        while (string.charAt(index) != ch) {
            switch (dir) {
                case 0: {
                    --index;
                    break;
                }
                case 1: {
                    ++index;
                }
            }
        }
        return index;
    }
}

