/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ecore.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.ecore.impl.Connection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectTypeRelationCondition;
import org.eclipse.emf.query.conditions.eobjects.TypeRelation;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EPackageUtil {
    private EPackageUtil() {
    }

    public static EPackage getPackageForModel(Properties dataSourceProperties) throws OdaException {
        Collection<EObject> model = Connection.getModel(dataSourceProperties);
        if (model.isEmpty()) {
            return null;
        }
        return model.iterator().next().eClass().getEPackage();
    }

    public static Set<EPackage> getPackagesForModel(Properties dataSourceProperties) throws OdaException {
        Collection<EObject> model = Connection.getModel(dataSourceProperties);
        if (model.isEmpty()) {
            return null;
        }
        EObjectTypeRelationCondition condition = new EObjectTypeRelationCondition(EcorePackage.eINSTANCE.getEObject(), TypeRelation.SAMETYPE_OR_SUBTYPE_LITERAL);
        IQueryResult classes = new SELECT(new FROM(model.iterator().next()), new WHERE((EObjectCondition)condition)).execute();
        Set objects = classes.getEObjects();
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        for (EObject eObject : objects) {
            ePackages.add(eObject.eClass().getEPackage());
        }
        return ePackages;
    }

    public static EPackage getPackageForClassifier(String eClassifier, Set<EPackage> ePackages) {
        for (EPackage ePackage : ePackages) {
            if (ePackage.getEClassifier(eClassifier) == null) continue;
            return ePackage;
        }
        return null;
    }
}

