/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ecore.impl;

import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.ecore.impl.DataSetMetaData;
import org.eclipse.datatools.enablement.oda.ecore.impl.Query;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection
implements IConnection {
    private boolean isOpen = false;
    private Collection<EObject> eObjects;
    private EClassifier classifier;

    public void open(Properties connProperties) throws OdaException {
        if (this.isOpen) {
            return;
        }
        if (connProperties == null) {
            throw new OdaException((Throwable)new IllegalArgumentException("NULL connection properties not allowed"));
        }
        this.eObjects = Connection.getModel(connProperties);
        this.isOpen = true;
    }

    public static Collection<EObject> getModel(Properties properties) throws OdaException {
        Resource resource;
        Object object = properties.get("EOBJECT_INSTANCES");
        if (object instanceof Collection) {
            Collection returnValue = (Collection)object;
            return returnValue;
        }
        URI uri = Connection.dataSourceUriFromProperties(properties);
        try {
            resource = new ResourceSetImpl().getResource(uri, true);
        }
        catch (WrappedException e) {
            throw new OdaException(e.getCause());
        }
        catch (RuntimeException e) {
            throw new OdaException((Throwable)e);
        }
        return resource.getContents();
    }

    public static URI dataSourceUriFromProperties(Properties dataSourceProperties) {
        return URI.createURI((String)dataSourceProperties.getProperty("MODEL_URI", null));
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        return this.isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        if (!this.isOpen) {
            throw new OdaException("Query cannot be created for closed connection");
        }
        return new Query(this.eObjects, this.classifier);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }

    public void setLocale(ULocale locale) throws OdaException {
    }
}

