/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.dbunit.internal.export;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizardPage;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.enablement.jdt.dbunit.Activator;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.export.ExportDBUDataSetWizard;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitMessages;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class ExportDBUDataSetObjectSelectionPage
extends BaseWizardPage {
    private Object mIncomingObject;
    private boolean mShowCatalog = false;
    private boolean mShowSchema = false;
    private IConnectionProfile mProfile = null;
    private Object[] mCheckedObjects = null;
    private String mFileName = null;
    private IPath mFilePath = null;
    private CheckboxTreeViewer mCTV = null;
    private TreeContentProvider mTCP = null;
    private TreeLabelProvider mTLP = null;
    private Text mDataSetFile;

    public ExportDBUDataSetObjectSelectionPage(String name) {
        super(name);
        this.setTitle(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_title);
        this.setDescription(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_description);
    }

    public void createControl(Composite parent) {
        ExportDBUDataSetWizard wizard = (ExportDBUDataSetWizard)this.getWizard();
        this.mIncomingObject = wizard.getIncomingObject();
        this.mProfile = this.getProfileFromIncomingObject(this.mIncomingObject);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        composite.setLayout((Layout)gl);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_TableList_title);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        nameLabel.setLayoutData((Object)gd);
        this.mCTV = new CheckboxTreeViewer(composite, 2560);
        gd = new GridData(1840);
        gd.horizontalSpan = 2;
        gd.verticalSpan = 5;
        this.mCTV.getControl().setLayoutData((Object)gd);
        this.mTCP = new TreeContentProvider();
        this.mCTV.setContentProvider((IContentProvider)this.mTCP);
        this.mTLP = new TreeLabelProvider();
        this.mCTV.setLabelProvider((IBaseLabelProvider)this.mTLP);
        this.mCTV.setInput(this.mIncomingObject);
        this.mCTV.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportDBUDataSetObjectSelectionPage.access$202(ExportDBUDataSetObjectSelectionPage.this, ExportDBUDataSetObjectSelectionPage.this.mCTV.getCheckedElements());
                ExportDBUDataSetObjectSelectionPage.this.setPageComplete(ExportDBUDataSetObjectSelectionPage.this.isValid());
            }
        });
        Button selectAll = new Button(composite, 8);
        selectAll.setText(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_SelectAll_Button_Title);
        gd = new GridData(256);
        selectAll.setLayoutData((Object)gd);
        selectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ExportDBUDataSetObjectSelectionPage.this.mCTV.setAllChecked(true);
                ExportDBUDataSetObjectSelectionPage.access$202(ExportDBUDataSetObjectSelectionPage.this, ExportDBUDataSetObjectSelectionPage.this.mCTV.getCheckedElements());
                ExportDBUDataSetObjectSelectionPage.this.setPageComplete(ExportDBUDataSetObjectSelectionPage.this.isValid());
            }
        });
        Button deselectAll = new Button(composite, 8);
        deselectAll.setText(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_DeselectAll_Button_Title);
        gd = new GridData(256);
        deselectAll.setLayoutData((Object)gd);
        deselectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ExportDBUDataSetObjectSelectionPage.this.mCTV.setAllChecked(false);
                ExportDBUDataSetObjectSelectionPage.access$202(ExportDBUDataSetObjectSelectionPage.this, ExportDBUDataSetObjectSelectionPage.this.mCTV.getCheckedElements());
                ExportDBUDataSetObjectSelectionPage.this.setPageComplete(ExportDBUDataSetObjectSelectionPage.this.isValid());
            }
        });
        Composite composite2 = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        composite2.setLayout((Layout)layout);
        GridData cGridData = new GridData(768);
        cGridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)cGridData);
        Label initialDataSetLabel = new Label(composite2, 16448);
        initialDataSetLabel.setFont(composite.getFont());
        initialDataSetLabel.setText(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_FileName_Label);
        initialDataSetLabel.setLayoutData((Object)new GridData());
        this.mDataSetFile = new Text(composite2, 2048);
        this.mDataSetFile.setFont(composite.getFont());
        this.mDataSetFile.setText(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_Initial_Filename);
        GridData idsGridData = new GridData(768);
        this.mDataSetFile.setLayoutData((Object)idsGridData);
        this.mDataSetFile.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String newLocation = ExportDBUDataSetObjectSelectionPage.this.mDataSetFile.getText();
                if (newLocation != null && !newLocation.equals(ExportDBUDataSetObjectSelectionPage.this.mFileName)) {
                    ExportDBUDataSetObjectSelectionPage.this.mFileName = newLocation;
                }
                ExportDBUDataSetObjectSelectionPage.this.setPageComplete(ExportDBUDataSetObjectSelectionPage.this.isValid());
            }
        });
        Button browseFile = new Button(composite2, 8);
        browseFile.setText(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_Browse_Button_Title);
        browseFile.setLayoutData((Object)new GridData(256));
        browseFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IPath newLocation = ExportDBUDataSetObjectSelectionPage.this.handleLocationEditButtonPressed(ExportDBUDataSetObjectSelectionPage.this.mDataSetFile.getText());
                if (newLocation != null && !newLocation.equals(ExportDBUDataSetObjectSelectionPage.this.mFilePath)) {
                    ExportDBUDataSetObjectSelectionPage.this.mDataSetFile.setText(newLocation.toPortableString());
                    ExportDBUDataSetObjectSelectionPage.this.mFilePath = newLocation;
                    ExportDBUDataSetObjectSelectionPage.this.mFileName = newLocation.toPortableString();
                }
                ExportDBUDataSetObjectSelectionPage.this.setPageComplete(ExportDBUDataSetObjectSelectionPage.this.isValid());
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    private IPath handleLocationEditButtonPressed(String editLocation) {
        SaveAsDialog rsDialog = new SaveAsDialog(this.getShell());
        rsDialog.setOriginalName(editLocation);
        rsDialog.setTitle(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_FileDialog_Title);
        rsDialog.create();
        int rtn = rsDialog.open();
        if (rtn == 0) {
            IPath selectedPath = rsDialog.getResult();
            return selectedPath;
        }
        return null;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public IPath getFilePath() {
        return this.mFilePath;
    }

    public IConnectionProfile getProfile() {
        return this.mProfile;
    }

    public Object[] getSelectedObjects() {
        return this.mCheckedObjects;
    }

    private IConnectionProfile getProfileFromIncomingObject(Object incoming) {
        Table table;
        Database db = null;
        if (incoming instanceof Database) {
            db = (Database)incoming;
        } else if (incoming instanceof Catalog) {
            db = ((Catalog)incoming).getDatabase();
        } else if (incoming instanceof Schema) {
            Schema schema = (Schema)incoming;
            if (schema.getDatabase() != null) {
                db = schema.getDatabase();
            } else if (schema.getCatalog() != null) {
                db = schema.getCatalog().getDatabase();
            }
        } else if (incoming instanceof Table && (table = (Table)incoming).getSchema() != null) {
            Schema schema = table.getSchema();
            if (schema.getDatabase() != null) {
                db = ((Table)incoming).getSchema().getDatabase();
            } else {
                Catalog catalog = schema.getCatalog();
                db = catalog.getDatabase();
            }
        }
        return DatabaseConnectionRegistry.getConnectionForDatabase((Database)db).getConnectionProfile();
    }

    public static String getQualifiedTableName(Table table, boolean showCatalog, boolean showSchema) {
        Schema schema = null;
        if (table != null) {
            schema = table.getSchema();
        }
        Catalog catalog = null;
        if (schema != null) {
            catalog = schema.getCatalog();
        }
        String text = table.getName();
        if (showCatalog && schema != null && schema.getName().length() > 0) {
            text = schema.getName() + "." + text;
        }
        if (showSchema && catalog != null && catalog.getName().length() > 0) {
            text = catalog.getName() + "." + text;
        }
        return text;
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        if (this.getProfile() != null) {
            data.add(new String[]{DbUnitMessages.ExportDBUDataSetObjectSelectionPage_Summary_Selected_Profile, this.getProfile().getName()});
        }
        if (this.getSelectedObjects() != null && this.getSelectedObjects().length > 0) {
            data.add(new String[]{DbUnitMessages.ExportDBUDataSetObjectSelectionPage_Summary_Selected_Tables, ""});
            for (int i = 0; i < this.getSelectedObjects().length; ++i) {
                data.add(new String[]{"", ExportDBUDataSetObjectSelectionPage.getQualifiedTableName((Table)this.getSelectedObjects()[i], this.mShowCatalog, this.mShowSchema)});
            }
        }
        if (this.getFileName() != null) {
            data.add(new String[]{DbUnitMessages.ExportDBUDataSetObjectSelectionPage_Summary_Selected_File, this.mFileName});
        }
        return data;
    }

    private boolean isValid() {
        boolean fileExists = false;
        if (this.getFileName() != null && this.getFileName().length() > 0) {
            IFile blah = Activator.getFile(this.getFileName());
            IContainer blahParent = Activator.getParentFolder(this.getFileName());
            if (blah != null) {
                blahParent = blah.getParent();
            }
            if (blah != null && blah.exists()) {
                fileExists = true;
            } else if (blahParent != null && blahParent.exists()) {
                fileExists = true;
            }
        }
        if (!fileExists) {
            this.setErrorMessage(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_Error_Must_Select_Valid_File);
        } else {
            this.setErrorMessage(null);
        }
        if (fileExists) {
            if (this.getSelectedObjects() == null || this.getSelectedObjects().length == 0) {
                this.setErrorMessage(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_Error_Must_Select_At_Least_One_Table);
            } else {
                this.setErrorMessage(null);
            }
        }
        if (this.getErrorMessage() != null) {
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    static /* synthetic */ Object[] access$202(ExportDBUDataSetObjectSelectionPage x0, Object[] x1) {
        x0.mCheckedObjects = x1;
        return x1;
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        private void processSchema(List list, Schema schema) {
            for (int i = 0; i < schema.getTables().size(); ++i) {
                Table table = (Table)schema.getTables().get(i);
                list.add(table);
            }
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Table> children = new ArrayList<Table>();
            if (parentElement instanceof Database) {
                ExportDBUDataSetObjectSelectionPage.this.mShowCatalog = true;
                ExportDBUDataSetObjectSelectionPage.this.mShowSchema = true;
                Database database = (Database)parentElement;
                if (database.getCatalogs().size() > 0) {
                    Object[] catalogs = database.getCatalogs().toArray();
                    for (int i = 0; i < catalogs.length; ++i) {
                        Object[] schemas = ((Catalog)catalogs[0]).getSchemas().toArray();
                        for (int j = 0; j < schemas.length; ++j) {
                            Schema schema = (Schema)schemas[j];
                            this.processSchema(children, schema);
                        }
                    }
                } else {
                    Object[] schemas = database.getSchemas().toArray();
                    for (int j = 0; j < schemas.length; ++j) {
                        Schema schema = (Schema)schemas[j];
                        this.processSchema(children, schema);
                    }
                }
            } else if (parentElement instanceof Catalog) {
                ExportDBUDataSetObjectSelectionPage.this.mShowCatalog = true;
                ExportDBUDataSetObjectSelectionPage.this.mShowSchema = true;
                Catalog catalog = (Catalog)parentElement;
                Object[] schemas = catalog.getSchemas().toArray();
                for (int i = 0; i < schemas.length; ++i) {
                    Schema schema = (Schema)schemas[i];
                    this.processSchema(children, schema);
                }
            } else if (parentElement instanceof Schema) {
                ExportDBUDataSetObjectSelectionPage.this.mShowSchema = true;
                Schema schema = (Schema)parentElement;
                this.processSchema(children, schema);
            } else if (parentElement instanceof Table) {
                ExportDBUDataSetObjectSelectionPage.this.mShowSchema = false;
                Table table = (Table)parentElement;
                children.add(table);
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof Table) {
                return ((Table)element).getSchema();
            }
            if (element instanceof Schema) {
                return ((Schema)element).getCatalog();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TreeLabelProvider
    implements ILabelProvider {
        private TreeLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Table) {
                Table table = (Table)element;
                return ExportDBUDataSetObjectSelectionPage.getQualifiedTableName(table, ExportDBUDataSetObjectSelectionPage.this.mShowCatalog, ExportDBUDataSetObjectSelectionPage.this.mShowSchema);
            }
            if (element instanceof SQLObject) {
                return ((SQLObject)element).getName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

