/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.datatools.enablement.ibm.IBMPluginActivator;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogLoadUtil;
import org.eclipse.datatools.enablement.ibm.catalog.util.ICatalogQuery;
import org.eclipse.datatools.enablement.ibm.util.PRSDatabaseLoader;
import org.eclipse.datatools.enablement.ibm.util.PRSDebug;
import org.eclipse.datatools.enablement.ibm.util.PRSMetadata;
import org.eclipse.datatools.enablement.ibm.util.PRSPersistenceUtility;
import org.eclipse.datatools.enablement.ibm.util.PRSSliceInfo;
import org.eclipse.datatools.enablement.ibm.util.PersistentQueryCache;
import org.eclipse.datatools.enablement.ibm.util.SliceKey;
import org.eclipse.datatools.enablement.ibm.util.StringCache;

public class PRSQueryInfo {
    private final PersistentQueryCache cache;
    private int id;
    private String idstring;
    private long createTime;
    private ICatalogQuery query;
    private String upfrontQueryText;
    private boolean hasUpfrontQueryExecuted;
    private PRSDatabaseLoader upfrontLoader;
    private boolean isComplete;
    private boolean isError = false;
    private SQLException exception = null;
    private int[] filterColNumbers;
    private PRSMetadata metadata;
    private int nextRowNumber = 0;
    private final List<PRSSliceInfo> loadingSlices = new ArrayList<PRSSliceInfo>();
    private final Map<SliceKey, PRSSliceInfo> sliceMap = new HashMap<SliceKey, PRSSliceInfo>();

    public PRSQueryInfo(PersistentQueryCache cache, int id, ICatalogQuery query) {
        this.cache = cache;
        this.id = id;
        this.idstring = String.format("%03d", this.id);
        this.reset(query);
    }

    private PRSQueryInfo(PersistentQueryCache cache) {
        this.cache = cache;
        this.id = -1;
        this.query = null;
        this.upfrontQueryText = null;
        this.createTime = 0L;
        this.idstring = null;
    }

    public void setException(SQLException exception) {
        this.exception = exception;
    }

    public SQLException getException() {
        return this.exception;
    }

    public synchronized void reset(ICatalogQuery q) {
        File qdata = this.getDataFile();
        File qslices = this.getSlicesFile();
        File qmeta = this.getMetadataFile();
        if (qdata != null && qdata.exists()) {
            qdata.delete();
        }
        if (qslices != null && qslices.exists()) {
            qslices.delete();
        }
        if (qmeta != null && qmeta.exists()) {
            qmeta.delete();
        }
        this.createTime = System.currentTimeMillis();
        this.isComplete = false;
        this.nextRowNumber = 1;
        this.metadata = null;
        this.query = q;
        this.upfrontQueryText = this.query.generateUpFrontQuery(this.cache.getDatabase());
        this.hasUpfrontQueryExecuted = false;
        this.upfrontLoader = null;
        this.sliceMap.clear();
        this.loadingSlices.clear();
    }

    public static PRSQueryInfo loadSavedQuery(PersistentQueryCache cache, String line) {
        if (PRSDebug.noFileCache) {
            return null;
        }
        PRSQueryInfo qinfo = new PRSQueryInfo(cache);
        try {
            if (!qinfo.fromPrintString(line)) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        qinfo.loadSlices();
        qinfo.loadMetadata();
        cache.registerQueryInfo(qinfo);
        return qinfo;
    }

    public int getId() {
        return this.id;
    }

    public ICatalogQuery getQuery() {
        return this.query;
    }

    public PersistentQueryCache getQueryCache() {
        return this.cache;
    }

    public String getUpfrontQueryText() {
        return this.upfrontQueryText;
    }

    public void setMetadata(PRSMetadata metadata) {
        this.metadata = metadata;
        this.metadata.save(this.getMetadataFile());
    }

    public PRSMetadata getMetadata() {
        return this.metadata;
    }

    public boolean canFilter() {
        if (this.filterColNumbers != null) {
            return this.filterColNumbers.length > 0;
        }
        return this.query != null && this.query.getFilterColumnCount() > 0;
    }

    public void setComplete() {
        this.isComplete = true;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean hasUpfrontQueryExecuted() {
        return this.hasUpfrontQueryExecuted;
    }

    public String toPrintString() {
        StringBuilder sb = new StringBuilder();
        PRSPersistenceUtility.append(sb, this.id);
        PRSPersistenceUtility.append(sb, this.idstring);
        PRSPersistenceUtility.append(sb, this.createTime);
        PRSPersistenceUtility.append(sb, this.upfrontQueryText);
        PRSPersistenceUtility.append(sb, this.hasUpfrontQueryExecuted);
        PRSPersistenceUtility.append(sb, this.isComplete);
        this.determineFilterColumnNumbers();
        PRSPersistenceUtility.append(sb, this.filterColNumbers != null ? this.filterColNumbers.length : 0);
        if (this.filterColNumbers != null) {
            int[] nArray = this.filterColNumbers;
            int n = this.filterColNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                int colnum = nArray[n2];
                PRSPersistenceUtility.append(sb, colnum);
                ++n2;
            }
        }
        return sb.toString();
    }

    private boolean fromPrintString(String s) {
        StringTokenizer toker = new StringTokenizer(s, "|");
        this.id = PRSPersistenceUtility.getIntToken(toker);
        this.idstring = PRSPersistenceUtility.getStringToken(toker);
        this.createTime = PRSPersistenceUtility.getLongToken(toker);
        this.upfrontQueryText = PRSPersistenceUtility.getStringToken(toker);
        this.hasUpfrontQueryExecuted = PRSPersistenceUtility.getBooleanToken(toker);
        this.isComplete = PRSPersistenceUtility.getBooleanToken(toker);
        int numFilterCols = PRSPersistenceUtility.getIntToken(toker);
        this.filterColNumbers = new int[numFilterCols];
        int ii = 0;
        while (ii < numFilterCols) {
            this.filterColNumbers[ii] = PRSPersistenceUtility.getIntToken(toker);
            ++ii;
        }
        return true;
    }

    public void quitOnError(PRSDatabaseLoader dbloader) {
        this.isError = true;
        this.finishLoad(dbloader);
    }

    public void loadFinished(PRSDatabaseLoader dbloader) {
        this.finishLoad(dbloader);
    }

    private synchronized void finishLoad(PRSDatabaseLoader dbloader) {
        Iterator<PRSSliceInfo> iter = this.loadingSlices.iterator();
        while (iter.hasNext()) {
            PRSSliceInfo slice = iter.next();
            if (slice.getLoader() != dbloader) continue;
            slice.finish();
            iter.remove();
        }
        if (this.isError || this.hasUpfrontQueryExecuted && this.loadingSlices.isEmpty()) {
            this.isComplete = true;
            this.saveSlices();
        }
        if (this.upfrontLoader == dbloader) {
            this.upfrontLoader = null;
        }
    }

    private void saveSlices() {
        if (this.sliceMap.isEmpty() || PRSDebug.noFileCache || !PRSDebug.enableFileCache) {
            return;
        }
        PrintWriter pw = this.getSliceFileWriter();
        if (pw == null) {
            return;
        }
        PRSSliceInfo[] pRSSliceInfoArray = this.getSlices();
        int n = pRSSliceInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            PRSSliceInfo slice = pRSSliceInfoArray[n2];
            slice.finish();
            slice.save(pw);
            ++n2;
        }
        CatalogLoadUtil.safeClose(pw);
    }

    /*
     * Unable to fully structure code
     */
    private boolean loadSlices() {
        block8: {
            if (PRSDebug.noFileCache) {
                return false;
            }
            lnr = null;
            sfile = this.getSlicesFile();
            if (sfile != null && sfile.isFile() && sfile.canRead()) break block8;
            while (true) {
                CatalogLoadUtil.safeClose(lnr);
                return false;
            }
        }
        try {
            try {
                if ((lnr = PRSPersistenceUtility.openFileForRead(sfile)) == null) ** continue;
                while ((line = lnr.readLine()) != null) {
                    slice = PRSSliceInfo.loadSavedSlice(this, line);
                    this.sliceMap.put(slice.getSliceKey(), slice);
                    slice.setComplete();
                }
            }
            catch (IOException v0) {
                CatalogLoadUtil.safeClose(lnr);
                return false;
            }
        }
        catch (Throwable var5_5) {
            CatalogLoadUtil.safeClose(lnr);
            throw var5_5;
        }
        CatalogLoadUtil.safeClose(lnr);
        return true;
    }

    public void loadMetadata() {
        block7: {
            if (PRSDebug.noFileCache) {
                return;
            }
            File mdfile = this.getMetadataFile();
            if (mdfile == null || !mdfile.exists() || !mdfile.canRead()) {
                return;
            }
            LineNumberReader lr = null;
            try {
                try {
                    lr = new LineNumberReader(new FileReader(mdfile));
                    this.metadata = PRSMetadata.loadSavedMetadata(lr);
                }
                catch (Exception e) {
                    IBMPluginActivator.log(e);
                    CatalogLoadUtil.safeClose(lr);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                CatalogLoadUtil.safeClose(lr);
                throw throwable;
            }
            CatalogLoadUtil.safeClose(lr);
        }
    }

    public PRSSliceInfo[] getSlices() {
        PRSSliceInfo[] slices = this.sliceMap.values().toArray(new PRSSliceInfo[this.sliceMap.size()]);
        Arrays.sort(slices, new Comparator<PRSSliceInfo>(){

            @Override
            public int compare(PRSSliceInfo s1, PRSSliceInfo s2) {
                return s1.getSerialNumber() > s2.getSerialNumber() ? 1 : -1;
            }
        });
        return slices;
    }

    public PrintWriter getSliceFileWriter() {
        return PRSPersistenceUtility.openFileForCreate(this.getSlicesFile());
    }

    public File getMetadataFile() {
        File cacheFolder = this.cache.getCacheFolder();
        if (cacheFolder == null) {
            return null;
        }
        String name = "q" + this.idstring + "_metadata.txt";
        return new File(cacheFolder, name);
    }

    public File getDataFile() {
        File cacheFolder = this.cache.getCacheFolder();
        if (cacheFolder == null) {
            return null;
        }
        String name = "q" + this.idstring + "_data.txt";
        return new File(cacheFolder, name);
    }

    public long getDataFileByteOffset() {
        File dataFile = this.getDataFile();
        return dataFile != null && dataFile.isFile() ? dataFile.length() : -1L;
    }

    public int getNextDataFileRowOffset() {
        return this.nextRowNumber + 1;
    }

    public int nextDataFileRowOffset() {
        return ++this.nextRowNumber;
    }

    public File getSlicesFile() {
        File cacheFolder = this.cache.getCacheFolder();
        if (cacheFolder == null) {
            return null;
        }
        String name = "q" + this.idstring + "_slices.txt";
        return new File(cacheFolder, name);
    }

    private synchronized void determineFilterColumnNumbers() {
        if (this.metadata == null || !this.canFilter()) {
            return;
        }
        if (this.filterColNumbers == null) {
            this.filterColNumbers = this.getMetadata().convertColumnNames(this.query.getFilterColumns());
        }
    }

    public PRSSliceInfo getSlice(ICatalogQuery q, Connection conn) {
        SliceKey slicekey = new SliceKey(q.getFilterValues());
        PRSSliceInfo slice = this.sliceMap.get(slicekey);
        if (slice != null) {
            return slice;
        }
        slice = this.getSlice(slicekey);
        if (this.isComplete()) {
            slice.finish();
            return slice;
        }
        this.addSliceBeingLoaded(slice);
        if (q.useOnDemandQuery() && q.canBeOnDemand()) {
            PRSDatabaseLoader dbloader = this.createLoader(q);
            slice.setLoader(dbloader);
            dbloader.initiateQuery(conn);
        } else if (!this.isError && this.exception == null && !this.hasUpfrontQueryExecuted) {
            this.upfrontLoader = this.createLoader(q);
            if (slice.getLoader() == null) {
                slice.setLoader(this.upfrontLoader);
            }
            this.upfrontLoader.initiateQuery(conn);
            this.hasUpfrontQueryExecuted = true;
        }
        if (this.isError || this.exception != null) {
            slice.finish();
        } else if (slice.getLoader() == null) {
            slice.setLoader(this.upfrontLoader);
        }
        return slice;
    }

    private PRSDatabaseLoader createLoader(ICatalogQuery q) {
        return new PRSDatabaseLoader(this, q);
    }

    public synchronized void addSlice(PRSSliceInfo slice) {
        this.sliceMap.put(slice.getSliceKey(), slice);
    }

    public synchronized PRSSliceInfo getSlice(SliceKey slicekey) {
        PRSSliceInfo slice = this.sliceMap.get(slicekey);
        if (slice == null) {
            slice = new PRSSliceInfo(this, slicekey);
            this.addSlice(slice);
        }
        return slice;
    }

    public void addRow(Object[] row, PRSDatabaseLoader dbloader) {
        PRSSliceInfo slice;
        SliceKey slicekey = this.getSliceKey(row);
        if (PRSDebug.enableTracing) {
            PRSDebug.trace("PRSQuery: row key=" + slicekey);
        }
        if ((slice = this.sliceMap.get(slicekey)) == null) {
            this.doneLoadingPreviousSlices(dbloader);
            slice = this.getSlice(slicekey);
            this.addSliceBeingLoaded(slice);
            slice.setLoader(dbloader);
            this.startSlice(slice);
        }
        if (slice.getLoader() == dbloader) {
            slice.addRow(row);
        }
    }

    private synchronized void addSliceBeingLoaded(PRSSliceInfo slice) {
        this.loadingSlices.add(slice);
    }

    private synchronized void doneLoadingPreviousSlices(PRSDatabaseLoader dbloader) {
        Iterator<PRSSliceInfo> iter = this.loadingSlices.iterator();
        while (iter.hasNext()) {
            PRSSliceInfo slice = iter.next();
            if (slice.isEmpty() || slice.getLoader() != dbloader) continue;
            slice.setComplete();
            iter.remove();
        }
    }

    public SliceKey getSliceKey(Object[] row) {
        return this.canFilter() ? new SliceKey(this.getFilterValues(row)) : SliceKey.EMPTY;
    }

    private String[] getFilterValues(Object[] row) {
        this.determineFilterColumnNumbers();
        int count = this.query.getFilterColumnCount();
        String[] filterValues = new String[count];
        int ii = 0;
        while (ii < count) {
            int rowidx = this.filterColNumbers[ii] - 1;
            Object obj = row[rowidx];
            String value = obj instanceof String ? (String)obj : (obj != null ? obj.toString() : StringCache.EMPTY);
            filterValues[ii] = value.trim();
            ++ii;
        }
        return filterValues;
    }

    private void startSlice(PRSSliceInfo slice) {
        if (PRSDebug.noFileCache) {
            return;
        }
    }

    public boolean hasAlreadyCached(SliceKey slicekey) {
        if (this.hasUpfrontQueryExecuted) {
            return true;
        }
        return !slicekey.isEmpty() && this.sliceMap.containsKey(slicekey);
    }

    public boolean hasFilteredContent() {
        return !this.hasUpfrontQueryExecuted && !this.sliceMap.isEmpty();
    }

    public SliceKey[] getCachedFilters() {
        return this.sliceMap.keySet().toArray(new SliceKey[0]);
    }
}

