/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IProfileListener1;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.internal.CategoryProvider;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileMgmt;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.UUID;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class InternalProfileManager {
    public static String PROFILE_PATH_SEPARATOR = "::";
    private static InternalProfileManager mManager = null;
    private IConnectionProfile[] mProfiles = null;
    private Set mRepositories = new HashSet();
    private boolean mIsDirty = false;
    private ListenerList mProfileListeners = new ListenerList();
    private static final String PLUGIN_STATE_LOCATION = "Plugin_State_Location";
    private boolean loadLocal = true;
    private IPropertySetListener mPropertySetListener = new IPropertySetListener(){

        public void propertySetChanged(IPropertySetChangeEvent event) {
            InternalProfileManager.this.setDirty(true);
            InternalProfileManager.this.saveChanges();
            InternalProfileManager.this.fireProfileChanged(event.getConnectionProfile(), null, null, null);
        }
    };
    private IProfileListener1 mProfileChangeListener = new IProfileListener1(){

        public void profileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect) {
            InternalProfileManager.this.removeOldFailureMarkers(oldName);
        }

        public void profileAdded(IConnectionProfile profile) {
        }

        public void profileChanged(IConnectionProfile profile) {
            InternalProfileManager.this.removeOldFailureMarkers(profile.getName());
        }

        public void profileDeleted(IConnectionProfile profile) {
            InternalProfileManager.this.removeOldFailureMarkers(profile.getName());
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private InternalProfileManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InternalProfileManager getInstance() {
        if (mManager != null) return mManager;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.internal.InternalProfileManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (mManager != null) return mManager;
            mManager = new InternalProfileManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mManager;
        }
    }

    public IConnectionProfile[] getProfiles(boolean searchRepositories) {
        ArrayList<IConnectionProfile> cps = new ArrayList<IConnectionProfile>();
        if (this.mProfiles == null) {
            this.loadProfiles();
        }
        cps.addAll(Arrays.asList(this.mProfiles));
        if (searchRepositories) {
            Iterator it = this.mRepositories.iterator();
            while (it.hasNext()) {
                cps.addAll(Arrays.asList(((IConnectionProfileRepository)it.next()).getProfiles()));
            }
        }
        return cps.toArray(new IConnectionProfile[0]);
    }

    public ICategory getCategory(String catID) {
        ConnectionProfileManager cpm = ConnectionProfileManager.getInstance();
        CategoryProvider cp = cpm.getCategory(catID);
        return cp == null ? null : cp.createCategory(null);
    }

    public ICategory[] getRootCategories() {
        Collection col = ConnectionProfileManager.getInstance().getCategories().values();
        ArrayList<ICategory> cats = new ArrayList<ICategory>(col.size());
        Iterator itr = col.iterator();
        while (itr.hasNext()) {
            CategoryProvider cp = (CategoryProvider)itr.next();
            if (cp.getParent() != null) continue;
            cats.add(cp.createCategory(null));
        }
        return cats.toArray(new ICategory[cats.size()]);
    }

    public IConnectionProfile[] getProfilesByCategory(String catID, boolean searchRepositories) {
        ArrayList<IConnectionProfile> cps = new ArrayList<IConnectionProfile>();
        IConnectionProfile[] profiles = this.getProfiles(false);
        if (catID == null) {
            return profiles;
        }
        int i = 0;
        while (i < profiles.length) {
            if (profiles[i].getProvider().getCategory() != null && profiles[i].getProvider().getCategory().getId().equals(catID)) {
                cps.add(profiles[i]);
            }
            ++i;
        }
        if (searchRepositories) {
            Iterator it = this.mRepositories.iterator();
            while (it.hasNext()) {
                cps.addAll(Arrays.asList(((IConnectionProfileRepository)it.next()).getProfilesByCategory(catID)));
            }
        }
        return cps.toArray(new IConnectionProfile[0]);
    }

    public IConnectionProfile getProfileByName(String name, boolean checkRepositories) {
        IConnectionProfile[] cps = this.getProfiles(false);
        IConnectionProfile cp = null;
        int i = 0;
        while (i < cps.length) {
            if (cps[i].getName().equals(name)) {
                cp = cps[i];
                break;
            }
            ++i;
        }
        if (checkRepositories) {
            Iterator it = this.mRepositories.iterator();
            while (cp == null && it.hasNext()) {
                cp = ((IConnectionProfileRepository)it.next()).getProfileByName(name);
            }
        }
        return cp;
    }

    public IConnectionProfile getProfileByPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        int separator = path.indexOf(PROFILE_PATH_SEPARATOR);
        if (separator < 0) {
            return this.getProfileByName(path, false);
        }
        return this.getProfileByPath(this.getProfileByName(path.substring(0, separator), false), path.substring(separator + PROFILE_PATH_SEPARATOR.length()));
    }

    public IConnectionProfile getProfileByFullPath(String path) {
        String[] tokens;
        if (path != null && (tokens = this.tokenize(path, PROFILE_PATH_SEPARATOR)) != null && tokens.length > 0) {
            IConnectionProfile foundProfile;
            String testForProfile = tokens[0];
            boolean hasRepository = false;
            IConnectionProfile testRepo = this.getProfileByName(testForProfile, false);
            if (testRepo != null && this.mRepositories.contains(this.getRepositoryByProfile(testRepo))) {
                hasRepository = true;
            }
            if (testRepo != null && this.mRepositories.contains(testRepo)) {
                hasRepository = true;
            }
            String shortPath = tokens[tokens.length - 1];
            if (hasRepository) {
                shortPath = String.valueOf(this.getProfileByName(testForProfile, false).getName()) + PROFILE_PATH_SEPARATOR + shortPath;
            }
            if ((foundProfile = this.getProfileByPath(shortPath)) != null) {
                return foundProfile;
            }
        }
        return null;
    }

    private IConnectionProfileRepository getRepositoryByProfile(IConnectionProfile profile) {
        if (profile != null) {
            IManagedConnection imc;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((imc = profile.getManagedConnection(clazz.getName())) != null && imc.getConnection() != null) {
                return (IConnectionProfileRepository)imc.getConnection().getRawConnection();
            }
        }
        return null;
    }

    public String unTokenize(String[] tokens) {
        StringBuffer buffer = new StringBuffer();
        if (tokens != null && tokens.length > 0) {
            int i = 0;
            while (i < tokens.length) {
                buffer.append(tokens[i]);
                if (i < tokens.length - 1) {
                    buffer.append(PROFILE_PATH_SEPARATOR);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    public String[] tokenize(String input, String delim) {
        char[] chars = input.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        String temp = "";
        boolean skip = false;
        int i = 0;
        while (i < chars.length) {
            String testStr;
            char test = chars[i];
            char test2 = ' ';
            if (i < chars.length - 1) {
                test2 = chars[i + 1];
            }
            if ((testStr = "" + test + test2).equals(delim)) {
                list.add(temp.trim());
                temp = "";
                skip = true;
            } else if (!skip) {
                temp = String.valueOf(temp) + test;
            } else {
                skip = false;
            }
            if (i == chars.length - 1) {
                list.add(temp.trim());
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public String getProfileFullPath(IConnectionProfile profile) {
        String path = null;
        if (profile != null) {
            path = profile.getName();
            if (profile.getCategory() != null) {
                ICategory category = profile.getCategory();
                while (category != null) {
                    path = String.valueOf(category.getId()) + PROFILE_PATH_SEPARATOR + path;
                    category = category.getParent();
                }
                IConnectionProfileRepository repository = this.getRepositoryForProfile(profile);
                if (repository != null) {
                    path = String.valueOf(repository.getRepositoryProfile().getName()) + PROFILE_PATH_SEPARATOR + path;
                }
            }
        }
        return path;
    }

    private IConnectionProfile getProfileByPath(IConnectionProfile parent, String path) {
        IManagedConnection imc;
        block14: {
            block13: {
                if (parent == null) break block13;
                IConnectionProfileProvider iConnectionProfileProvider = parent.getProvider();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (iConnectionProfileProvider.getConnectionFactory(clazz.getName()) != null && path != null && path.length() != 0) break block14;
            }
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((imc = parent.getManagedConnection(clazz.getName())) == null || !imc.isConnected() || imc.getConnection() == null) {
            return null;
        }
        IConnectionProfileRepository repo = (IConnectionProfileRepository)imc.getConnection().getRawConnection();
        int separator = path.indexOf(PROFILE_PATH_SEPARATOR);
        if (separator < 0) {
            return repo.getProfileByName(path);
        }
        return this.getProfileByPath(repo.getProfileByName(path.substring(0, separator)), path.substring(separator + PROFILE_PATH_SEPARATOR.length()));
    }

    public IConnectionProfile getProfileByInstanceID(String id) {
        IConnectionProfile[] cps = this.getProfiles(false);
        IConnectionProfile cp = null;
        int i = 0;
        while (i < cps.length) {
            if (cps[i].getInstanceID().equals(id)) {
                cp = cps[i];
                break;
            }
            ++i;
        }
        Iterator it = this.mRepositories.iterator();
        while (cp == null && it.hasNext()) {
            cp = ((IConnectionProfileRepository)it.next()).getProfileByInstanceID(id);
        }
        return cp;
    }

    public IConnectionProfile[] getProfileByProviderID(String ID, boolean searchRepositories) {
        IConnectionProfile[] cps = this.getProfiles(false);
        ArrayList<IConnectionProfile> cpset = new ArrayList<IConnectionProfile>();
        int i = 0;
        while (i < cps.length) {
            if (cps[i].getProviderId().equals(ID)) {
                cpset.add(cps[i]);
            }
            ++i;
        }
        if (searchRepositories) {
            Iterator it = this.mRepositories.iterator();
            while (it.hasNext()) {
                cpset.addAll(Arrays.asList(((IConnectionProfileRepository)it.next()).getProfileByProviderID(ID)));
            }
        }
        return cpset.toArray(new IConnectionProfile[0]);
    }

    public IConnectionProfile createProfile(String name, String description, String providerID, Properties baseProperties) throws ConnectionProfileException {
        return this.createProfile(name, description, providerID, baseProperties, "", false);
    }

    public IConnectionProfile createProfile(String name, String description, String providerID, Properties baseProperties, String parentProfile) throws ConnectionProfileException {
        return this.createProfile(name, description, providerID, baseProperties, parentProfile, false);
    }

    public IConnectionProfile createProfile(String name, String description, String providerID, Properties baseProperties, String parentProfile, boolean autoConnect) throws ConnectionProfileException {
        ConnectionProfile profile = new ConnectionProfile(name, description, providerID, parentProfile, autoConnect, UUID.createUUID().toString());
        profile.setBaseProperties(baseProperties);
        IConnectionProfileRepository repo = this.getRepositoryForProfile(profile);
        if (repo == null) {
            this.addProfile(profile);
        } else {
            repo.addProfile(profile);
        }
        profile.setCreated();
        return profile;
    }

    public String duplicateProfile(IConnectionProfile profile) throws ConnectionProfileException {
        String profileName;
        ConnectionProfile cp = (ConnectionProfile)profile;
        int i = 0;
        do {
            profileName = ConnectivityPlugin.getDefault().getResourceString("duplicate.profile.name", new Object[]{cp.getName(), new Integer(i)});
            ++i;
        } while (this.getProfileByName(profileName, false) != null);
        IConnectionProfile newProfile = this.copyProfile(profile, profile.getParentProfile(), profileName);
        return newProfile.getName();
    }

    public IConnectionProfile copyProfile(IConnectionProfile source, IConnectionProfile repo, String newName) throws ConnectionProfileException {
        Properties props = (Properties)source.getBaseProperties().clone();
        IConnectionProfile newProfile = this.createProfile(newName, source.getDescription(), source.getProviderId(), props, repo == null ? new String() : repo.getInstanceID(), source.isAutoConnect());
        Set extensionIDs = ((ConnectionProfile)source).getPropertiesMap().keySet();
        Iterator iter = extensionIDs.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Properties oldProps = source.getProperties(key);
            Properties newProps = (Properties)oldProps.clone();
            newProfile.setProperties(key, newProps);
        }
        return newProfile;
    }

    public IConnectionProfile cloneProfile(IConnectionProfile source, IConnectionProfile repo, String newName) {
        Properties props = (Properties)source.getBaseProperties().clone();
        ConnectionProfile newProfile = new ConnectionProfile(newName, source.getDescription(), source.getProviderId(), repo == null ? new String() : repo.getInstanceID(), source.isAutoConnect(), UUID.createUUID().toString());
        newProfile.setBaseProperties(props);
        Set extensionIDs = ((ConnectionProfile)source).getPropertiesMap().keySet();
        Iterator iter = extensionIDs.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Properties oldProps = source.getProperties(key);
            Properties newProps = (Properties)oldProps.clone();
            newProfile.setProperties(key, newProps);
        }
        return newProfile;
    }

    public void addProfile(IConnectionProfile profile) throws ConnectionProfileException {
        this.addProfile(profile, false);
    }

    public void addProfile(IConnectionProfile profile, boolean replaceExisting) throws ConnectionProfileException {
        IConnectionProfile[] cps = this.getProfiles(false);
        int i = 0;
        while (i < cps.length) {
            if (cps[i].getName().equals(profile.getName())) {
                if (!replaceExisting) {
                    throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.duplicate", new Object[]{profile.getName()}));
                }
                if (cps[i] != profile) {
                    this.modifyProfile(profile);
                }
                return;
            }
            ++i;
        }
        ((ConnectionProfile)profile).setRepository(null);
        this.mProfiles = new IConnectionProfile[cps.length + 1];
        if (cps.length != 0) {
            System.arraycopy(cps, 0, this.mProfiles, 0, cps.length);
        }
        this.mProfiles[cps.length] = profile;
        profile.addPropertySetListener(this.mPropertySetListener);
        this.mIsDirty = true;
        this.fireProfileAdded(profile);
        this.saveChanges();
        if (profile.isAutoConnect()) {
            profile.connect(null);
        }
    }

    public void removeProfile(IConnectionProfile profile) throws ConnectionProfileException {
        if (profile.getParentProfile() != null) {
            return;
        }
        IConnectionProfile[] oldProfiles = this.mProfiles;
        this.mProfiles = new IConnectionProfile[oldProfiles.length - 1];
        int oldIndex = 0;
        int oldCount = oldProfiles.length;
        int newIndex = 0;
        int newCount = oldCount - 1;
        while (oldIndex < oldCount && newIndex < newCount) {
            if (oldProfiles[oldIndex].equals(profile)) {
                --newIndex;
            } else {
                this.mProfiles[newIndex] = oldProfiles[oldIndex];
            }
            ++oldIndex;
            ++newIndex;
        }
        if (oldIndex != oldProfiles.length && !oldProfiles[oldProfiles.length - 1].equals(profile)) {
            this.mProfiles = oldProfiles;
            return;
        }
        this.mIsDirty = true;
        this.fireProfileDeleted(profile);
        this.saveChanges();
    }

    public void deleteProfile(IConnectionProfile profile) throws ConnectionProfileException {
        IStatus status = profile.disconnect();
        if (status == Status.CANCEL_STATUS) {
            return;
        }
        IConnectionProfileRepository repo = this.getRepositoryForProfile(profile);
        if (repo != null) {
            repo.deleteProfile(profile);
            return;
        }
        IConnectionProfile[] cps = this.getProfiles(false);
        ArrayList<IConnectionProfile> cpList = new ArrayList<IConnectionProfile>();
        boolean found = false;
        int index = -1;
        int i = 0;
        while (i < cps.length) {
            cpList.add(cps[i]);
            if (cps[i].getName().equals(profile.getName())) {
                found = true;
                index = i;
            }
            ++i;
        }
        if (!found || cps.length == 0) {
            throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.notexist", new Object[]{profile.getName()}));
        }
        if (index >= 0) {
            cpList.remove(index);
        }
        this.mProfiles = cpList.toArray(new IConnectionProfile[0]);
        this.mIsDirty = true;
        this.fireProfileDeleted(profile);
        this.saveChanges();
    }

    private void removeOldFailureMarkers(String oldProfileName) {
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IMarker[] markers = resource.findMarkers("org.eclipse.datatools.connectivity.ui.profileFailure", true, 2);
            int i = 0;
            while (i < markers.length) {
                if (markers[i].getAttribute("location", new String()).equals(oldProfileName)) {
                    markers[i].delete();
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public void modifyProfile(IConnectionProfile profile) throws ConnectionProfileException {
        IConnectionProfileRepository repo = this.getRepositoryForProfile(profile);
        if (repo == null) {
            this.modifyProfile(profile, null, null, null);
        } else {
            repo.modifyProfile(profile, null, null, null);
        }
    }

    public void modifyProfile(IConnectionProfile profile, String newName, String newDesc) throws ConnectionProfileException {
        IConnectionProfileRepository repo = this.getRepositoryForProfile(profile);
        if (repo == null) {
            this.modifyProfile(profile, newName, newDesc, null);
        } else {
            repo.modifyProfile(profile, newName, newDesc, null);
        }
    }

    public void modifyProfile(IConnectionProfile profile, String newName, String newDesc, Boolean autoConnect) throws ConnectionProfileException {
        IConnectionProfileRepository repo = this.getRepositoryForProfile(profile);
        if (repo != null) {
            repo.modifyProfile(profile, newName, newDesc, autoConnect);
            return;
        }
        IConnectionProfile[] cps = this.getProfiles(false);
        boolean found = false;
        boolean foundnew = false;
        int index = 0;
        int i = 0;
        while (i < cps.length) {
            if (cps[i].getName().equals(profile.getName())) {
                found = true;
                index = i;
            }
            if (cps[i].getName().equals(newName)) {
                foundnew = true;
            }
            ++i;
        }
        if (!found) {
            throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.notexist", new Object[]{profile.getName()}));
        }
        if (foundnew && !profile.getName().equals(newName)) {
            throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.duplicate", new Object[]{newName}));
        }
        ConnectionProfile internalProfile = (ConnectionProfile)profile;
        String oldName = profile.getName();
        String oldDesc = profile.getDescription();
        Boolean oldAutoConnect = new Boolean(profile.isAutoConnect());
        if (newName != null && !newName.equals(oldName)) {
            internalProfile.setName(newName);
        }
        if (newDesc != null && !newDesc.equals(oldDesc)) {
            internalProfile.setDescription(newDesc);
        }
        if (autoConnect != null && !autoConnect.equals(oldAutoConnect)) {
            internalProfile.setAutoConnect(autoConnect);
            if (autoConnect.booleanValue() && internalProfile.getConnectionState() == 0) {
                internalProfile.connect(null);
            }
        }
        cps[index] = profile;
        this.mIsDirty = true;
        this.fireProfileChanged(profile, oldName, oldDesc, oldAutoConnect);
        this.saveChanges();
    }

    public void saveChanges() {
        if (this.mIsDirty) {
            try {
                ConnectionProfileMgmt.saveCPs(this.getProfiles(false));
                this.backupProfilesData(null);
                this.setDirty(false);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
    }

    public void addProfileListener(IProfileListener listener) {
        this.mProfileListeners.add((Object)listener);
    }

    public void removeProfileListener(IProfileListener listener) {
        this.mProfileListeners.remove((Object)listener);
    }

    private synchronized void loadProfiles() {
        IConnectionProfile[] dcps;
        IConnectionProfile[] scps;
        if (this.mProfiles != null) {
            return;
        }
        File serverFile = ConnectivityPlugin.getDefault().getStateLocation().append("ServerProfiles.dat").toFile();
        File defaultFile = null;
        try {
            URL url = ConnectivityPlugin.getDefault().getBundle().getEntry("WorkSpaceServerConnectionProfiles.xml");
            if (url != null) {
                defaultFile = new File(FileLocator.toFileURL((URL)url).getFile());
            }
        }
        catch (IOException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
        if (this.loadLocal) {
            this.loadLocal = false;
            this.loadLocalRegisteredDatabases();
        }
        if (serverFile.exists() || this.backupFileExists()) {
            try {
                if (!serverFile.exists() && this.backupFileExists()) {
                    this.restoreFromBackupProfilesData();
                }
                this.backupProfilesData(serverFile);
                scps = ConnectionProfileMgmt.loadCPs(serverFile);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
                scps = new IConnectionProfile[]{};
            }
        } else {
            scps = new IConnectionProfile[]{};
        }
        if (defaultFile != null && defaultFile.exists() && defaultFile.lastModified() > serverFile.lastModified()) {
            try {
                dcps = ConnectionProfileMgmt.loadCPs(defaultFile);
                this.saveChanges();
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
                dcps = new IConnectionProfile[]{};
            }
        } else {
            dcps = new IConnectionProfile[]{};
        }
        HashMap<String, IConnectionProfile> nameToProfileMap = new HashMap<String, IConnectionProfile>(scps.length + dcps.length);
        int i = 0;
        while (i < dcps.length) {
            if (dcps[i].getName() != null) {
                nameToProfileMap.put(dcps[i].getName(), dcps[i]);
            }
            ++i;
        }
        i = 0;
        while (i < scps.length) {
            if (scps[i].getName() != null) {
                nameToProfileMap.put(scps[i].getName(), scps[i]);
            }
            ++i;
        }
        Iterator it = nameToProfileMap.values().iterator();
        while (it.hasNext()) {
            ConnectionProfile profile = (ConnectionProfile)it.next();
            profile.migrate();
            profile.addPropertySetListener(this.mPropertySetListener);
        }
        this.mProfiles = nameToProfileMap.values().toArray(new IConnectionProfile[nameToProfileMap.size()]);
        this.autoConnectProfiles();
        this.addProfileListener(this.mProfileChangeListener);
    }

    private void backupProfilesData(File ioFile) {
        if (ioFile != null && ioFile.exists()) {
            File backupFile = ConnectivityPlugin.getDefault().getStateLocation().append("ServerProfiles.bak").toFile();
            try {
                this.copy(ioFile, backupFile);
            }
            catch (IOException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        } else {
            File serverFile = ConnectivityPlugin.getDefault().getStateLocation().append("ServerProfiles.dat").toFile();
            this.backupProfilesData(serverFile);
        }
    }

    private void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private void restoreFromBackupProfilesData() {
        File serverFile = ConnectivityPlugin.getDefault().getStateLocation().append("ServerProfiles.dat").toFile();
        if (!serverFile.exists()) {
            File backupFile = ConnectivityPlugin.getDefault().getStateLocation().append("ServerProfiles.bak").toFile();
            try {
                this.copy(backupFile, serverFile);
            }
            catch (IOException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
    }

    private boolean backupFileExists() {
        File backupFile = ConnectivityPlugin.getDefault().getStateLocation().append("ServerProfiles.bak").toFile();
        return backupFile.exists();
    }

    public void fireProfileAdded(IConnectionProfile profile) {
        Object[] ls = this.mProfileListeners.getListeners();
        int i = 0;
        while (i < ls.length) {
            ((IProfileListener)ls[i]).profileAdded(profile);
            ++i;
        }
    }

    public void fireProfileDeleted(IConnectionProfile profile) {
        Object[] ls = this.mProfileListeners.getListeners();
        int i = 0;
        while (i < ls.length) {
            ((IProfileListener)ls[i]).profileDeleted(profile);
            ++i;
        }
    }

    public void fireProfileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect) {
        Object[] ls = this.mProfileListeners.getListeners();
        int i = 0;
        while (i < ls.length) {
            if (ls[i] instanceof IProfileListener1) {
                ((IProfileListener1)ls[i]).profileChanged(profile, oldName, oldDesc, oldAutoConnect);
            } else {
                ((IProfileListener)ls[i]).profileChanged(profile);
            }
            ++i;
        }
    }

    private void autoConnectProfiles() {
        int index = 0;
        int count = this.mProfiles.length;
        while (index < count) {
            if (this.mProfiles[index].isAutoConnect()) {
                this.mProfiles[index].connect(null);
            }
            ++index;
        }
    }

    void dispose() {
        if (this.mProfiles == null) {
            return;
        }
        this.mProfileListeners.clear();
        this.saveChanges();
        int index = 0;
        int count = this.mProfiles.length;
        while (index < count) {
            ((ConnectionProfile)this.mProfiles[index]).dispose();
            ++index;
        }
        mManager = null;
    }

    public void setDirty(boolean isDirty) {
        this.mIsDirty = isDirty;
    }

    public void addRepository(IConnectionProfileRepository repository) {
        this.checkDuplicatedRepository(repository);
        this.mRepositories.add(repository);
    }

    private void checkDuplicatedRepository(IConnectionProfileRepository repository) {
        HashSet cachedRepositoryList = new HashSet();
        cachedRepositoryList.addAll(this.mRepositories);
        Iterator itr = cachedRepositoryList.iterator();
        while (itr.hasNext()) {
            IConnectionProfileRepository eRepository = (IConnectionProfileRepository)itr.next();
            if (!eRepository.equals(repository)) continue;
            this.mRepositories.remove(eRepository);
        }
    }

    public void removeRepository(IConnectionProfileRepository repository) {
        this.mRepositories.remove(repository);
    }

    public IConnectionProfileRepository getRepositoryForProfile(IConnectionProfile profile) {
        IConnectionProfile parentProfile = profile.getParentProfile();
        if (parentProfile != null) {
            IManagedConnection imc;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((imc = parentProfile.getManagedConnection(clazz.getName())) != null && imc.getConnection() != null) {
                return (IConnectionProfileRepository)imc.getConnection().getRawConnection();
            }
        }
        return null;
    }

    public void loadLocalRegisteredDatabases() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.ProfileManagerInitializationProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("connection")) {
                    String jarList = configElements[j].getAttribute("jarList");
                    String connectionProfileName = configElements[j].getAttribute("connectionProfileName");
                    String connectionProfileID = configElements[j].getAttribute("connectionProfileID");
                    String driverDefinitionName = configElements[j].getAttribute("driverDefinitionName");
                    String driverTemplateID = configElements[j].getAttribute("driverTemplateID");
                    String initializationClass = configElements[j].getAttribute("connectionInitializer");
                    if (initializationClass != null) {
                        this.initializeLocalDatabase(configElements[j], initializationClass);
                    }
                    if (this.checkForValidValues(connectionProfileName, connectionProfileID, driverDefinitionName, driverTemplateID)) {
                        this.enableLocalDatabase(configElements[j].getChildren("property"), jarList, connectionProfileName, connectionProfileID, driverDefinitionName, driverTemplateID);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void initializeLocalDatabase(IConfigurationElement config, String initializationClass) {
        try {
            config.createExecutableExtension("connectionInitializer");
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
    }

    private void enableLocalDatabase(IConfigurationElement[] configElements, String jarList, String connProfileName, String connProfileID, String driverDefName, String driverTemplateID) {
        DriverInstance driverInstance;
        if ((configElements.length == 0 || this.isBundleActivated(configElements[0])) && (driverInstance = this.getDriverInstance(driverDefName, driverTemplateID, jarList)) != null) {
            Properties connectionProfileProperties = driverInstance.getPropertySet().getBaseProperties();
            connectionProfileProperties.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", driverInstance.getId());
            ArrayList<String> propList = new ArrayList<String>();
            int i = 0;
            int n = configElements.length;
            while (i < n) {
                String propertyID = configElements[i].getAttribute("id");
                propList.add(propertyID);
                String propertyValue = configElements[i].getAttribute("value");
                propertyValue = this.substituteLocationDirectory(propertyValue, configElements[i]);
                connectionProfileProperties.setProperty(propertyID, propertyValue);
                ++i;
            }
            this.getProfileInstance(connProfileName, connProfileID, connectionProfileProperties, propList);
        }
    }

    private boolean isBundleActivated(IConfigurationElement element) {
        try {
            Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
            if (bundle.getState() == 4) {
                bundle.start();
            }
            return bundle.getState() == 32;
        }
        catch (BundleException e) {
            ConnectivityPlugin.getDefault().log(e);
            return false;
        }
    }

    private String substituteLocationDirectory(String logicalPath, IConfigurationElement element) {
        String stateLocation = Platform.getStateLocation((Bundle)Platform.getBundle((String)element.getDeclaringExtension().getNamespace())).toOSString();
        int index = logicalPath.indexOf(PLUGIN_STATE_LOCATION);
        if (index != -1) {
            logicalPath = String.valueOf(logicalPath.substring(0, index)) + stateLocation + logicalPath.substring(index + PLUGIN_STATE_LOCATION.length());
        }
        return logicalPath;
    }

    private DriverInstance getDriverInstance(String inName, String driverTemplateID, String jarList) {
        String defName = inName;
        DriverInstance[] dilist = DriverManager.getInstance().getDriverInstancesByTemplate(driverTemplateID);
        if (dilist != null && dilist.length > 0) {
            int i = 0;
            while (i < dilist.length) {
                DriverValidator validator;
                DriverInstance driverInstance = dilist[i];
                if (driverInstance != null && (jarList == null || driverInstance.getJarList().equals(jarList)) && (validator = new DriverValidator(driverInstance)).isValid() && driverInstance.getName().equals(inName)) {
                    return driverInstance;
                }
                ++i;
            }
            if (DriverManager.getInstance().getDriverInstanceByName(defName) != null) {
                defName = this.determineUniqueDriverName(defName);
            }
        }
        return DriverManager.getInstance().createNewDriverInstance(driverTemplateID, defName, jarList);
    }

    private String determineUniqueDriverName(String inName) {
        int index = 1;
        String testName = String.valueOf(inName) + String.valueOf(index);
        while (DriverManager.getInstance().getDriverInstanceByName(testName) != null) {
            testName = String.valueOf(inName) + String.valueOf(++index);
        }
        return testName;
    }

    private void getProfileInstance(String profileName, String profileID, Properties connProperties, List propList) {
        String profName = profileName;
        IConnectionProfile connProfile = ProfileManager.getInstance().getProfileByName(profileName);
        if (connProfile != null) {
            Properties props = connProfile.getBaseProperties();
            if (connProfile.getProviderId().equals(profileID)) {
                boolean match = true;
                int i = 0;
                while (i < propList.size()) {
                    String propName = (String)propList.get(i);
                    if (!connProperties.get(propName).equals(props.get(propName))) {
                        match = false;
                    }
                    ++i;
                }
                if (match) {
                    return;
                }
            } else {
                profName = this.determineUniqueProfileName(profName);
            }
        }
        try {
            ProfileManager.getInstance().createProfile(profName, "", profileID, connProperties, "", false);
        }
        catch (ConnectionProfileException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
    }

    private String determineUniqueProfileName(String inName) {
        int index = 1;
        String testName = String.valueOf(inName) + String.valueOf(index);
        while (ProfileManager.getInstance().getProfileByName(testName) != null) {
            testName = String.valueOf(inName) + String.valueOf(++index);
        }
        return testName;
    }

    private boolean checkForValidValues(String inProfileName, String inProfileID, String inDriverDefName, String inDriverTemplateID) {
        boolean validValue = true;
        if (inProfileName == null || inProfileName.equals("")) {
            validValue = false;
        } else if (inProfileID == null || inProfileID.equals("")) {
            validValue = false;
        } else if (inDriverDefName == null || inDriverDefName.equals("")) {
            validValue = false;
        } else if (inDriverTemplateID == null || inDriverTemplateID.equals("")) {
            validValue = false;
        }
        return validValue;
    }
}

