/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.internal.CategoryProvider;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;

public abstract class ConnectionProfileRepositoryBase
implements IConnectionProfileRepository {
    private Map mProfiles = null;
    private IConnectionProfile mProfile;
    private IPropertySetListener mPropertySetListener = new IPropertySetListener(){

        public void propertySetChanged(IPropertySetChangeEvent event) {
            ConnectionProfileRepositoryBase.this.save();
            ConnectionProfileRepositoryBase.this.fireProfileChanged(event.getConnectionProfile(), null, null, null);
        }
    };

    protected ConnectionProfileRepositoryBase(IConnectionProfile profile) {
        this.mProfile = profile;
        InternalProfileManager.getInstance().addRepository(this);
    }

    public IConnectionProfile getRepositoryProfile() {
        return this.mProfile;
    }

    public IConnectionProfile[] getProfiles() {
        return this.internalGetProfiles().values().toArray(new IConnectionProfile[this.mProfiles.size()]);
    }

    protected Map internalGetProfiles() {
        if (this.mProfiles == null) {
            try {
                this.load();
            }
            catch (CoreException e) {
                e.printStackTrace();
                return new HashMap();
            }
        }
        return this.mProfiles;
    }

    public IConnectionProfile[] getProfilesByCategory(String catID) {
        if (catID == null) {
            return this.getProfiles();
        }
        Collection profiles = this.internalGetProfiles().values();
        ArrayList<IConnectionProfile> cps = new ArrayList<IConnectionProfile>();
        Iterator it = profiles.iterator();
        while (it.hasNext()) {
            IConnectionProfile profile = (IConnectionProfile)it.next();
            if (profile.getProvider().getCategory() == null || !profile.getProvider().getCategory().getId().equals(catID)) continue;
            cps.add(profile);
        }
        return cps.toArray(new IConnectionProfile[0]);
    }

    public IConnectionProfile getProfileByName(String name) {
        Map profiles = this.internalGetProfiles();
        if (profiles.containsKey(name)) {
            return (IConnectionProfile)profiles.get(name);
        }
        return null;
    }

    public IConnectionProfile getProfileByInstanceID(String id) {
        IConnectionProfile cp = null;
        Collection profiles = this.internalGetProfiles().values();
        Iterator it = profiles.iterator();
        while (it.hasNext()) {
            IConnectionProfile profile = (IConnectionProfile)it.next();
            if (!profile.getInstanceID().equals(id)) continue;
            cp = profile;
            break;
        }
        return cp;
    }

    public IConnectionProfile[] getProfileByProviderID(String ID) {
        Collection profiles = this.internalGetProfiles().values();
        ArrayList<IConnectionProfile> cps = new ArrayList<IConnectionProfile>();
        Iterator it = profiles.iterator();
        while (it.hasNext()) {
            IConnectionProfile profile = (IConnectionProfile)it.next();
            if (!profile.getProviderId().equals(ID)) continue;
            cps.add(profile);
        }
        return cps.toArray(new IConnectionProfile[cps.size()]);
    }

    public void addProfile(IConnectionProfile profile) throws ConnectionProfileException {
        this.addProfile(profile, false);
    }

    public void addProfile(IConnectionProfile profile, boolean replaceExisting) throws ConnectionProfileException {
        IConnectionProfile existingProfile = this.getProfileByName(profile.getName());
        if (existingProfile != null) {
            if (!replaceExisting) {
                throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.duplicate", new Object[]{profile.getName()}));
            }
            if (existingProfile != profile) {
                this.modifyProfile(profile);
            }
            return;
        }
        this.internalGetProfiles().put(profile.getName(), profile);
        ((ConnectionProfile)profile).setRepository(this);
        profile.addPropertySetListener(this.mPropertySetListener);
        this.fireProfileAdded(profile);
        this.save();
        if (profile.isAutoConnect()) {
            profile.connect(null);
        }
    }

    public void removeProfile(IConnectionProfile profile) throws ConnectionProfileException {
        if (!this.getRepositoryProfile().equals(profile.getParentProfile())) {
            return;
        }
        if (this.getProfileByName(profile.getName()) != null) {
            this.mProfiles.remove(profile.getName());
            this.fireProfileDeleted(profile);
            this.save();
        }
    }

    public void deleteProfile(IConnectionProfile profile) throws ConnectionProfileException {
        Map profiles = this.internalGetProfiles();
        if (!profiles.containsKey(profile.getName())) {
            throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.notexist", new Object[]{profile.getName()}));
        }
        profiles.remove(profile.getName());
        profile.disconnect();
        this.fireProfileDeleted(profile);
        this.save();
    }

    public void modifyProfile(IConnectionProfile profile) throws ConnectionProfileException {
        this.modifyProfile(profile, null, null, null);
    }

    public void modifyProfile(IConnectionProfile profile, String newName, String newDesc) throws ConnectionProfileException {
        this.modifyProfile(profile, newName, newDesc, null);
    }

    public void modifyProfile(IConnectionProfile profile, String newName, String newDesc, Boolean autoConnect) throws ConnectionProfileException {
        IConnectionProfile currentProfile = this.getProfileByName(profile.getName());
        IConnectionProfile existingProfile = this.getProfileByName(newName);
        if (currentProfile == null) {
            throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.notexist", new Object[]{profile.getName()}));
        }
        if (existingProfile != null && !profile.getName().equals(newName)) {
            throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.duplicate", new Object[]{newName}));
        }
        ConnectionProfile internalProfile = (ConnectionProfile)profile;
        String oldName = profile.getName();
        String oldDesc = profile.getDescription();
        Boolean oldAutoConnect = new Boolean(profile.isAutoConnect());
        if (newName != null && !newName.equals(oldName)) {
            internalProfile.setName(newName);
        }
        if (newDesc != null && !newDesc.equals(oldDesc)) {
            internalProfile.setDescription(newDesc);
        }
        if (autoConnect != null && !autoConnect.equals(oldAutoConnect)) {
            internalProfile.setAutoConnect(autoConnect);
            if (autoConnect.booleanValue() && internalProfile.getConnectionState() == 0) {
                internalProfile.connect(null);
            }
        }
        this.internalGetProfiles().put(profile.getName(), profile);
        this.fireProfileChanged(profile, oldName, oldDesc, oldAutoConnect);
        this.save();
    }

    public abstract void save();

    public void load() throws CoreException {
        Collection profiles = this.loadProfiles();
        if (profiles == null) {
            this.mProfiles = new HashMap();
        } else {
            this.mProfiles = new HashMap(profiles.size());
            Iterator it = profiles.iterator();
            while (it.hasNext()) {
                ConnectionProfile profile = (ConnectionProfile)it.next();
                profile.setRepository(this);
                this.mProfiles.put(profile.getName(), profile);
                profile.migrate();
                profile.addPropertySetListener(this.mPropertySetListener);
            }
        }
        this.autoConnectProfiles();
    }

    protected abstract Collection loadProfiles() throws CoreException;

    protected final void fireProfileAdded(IConnectionProfile profile) {
        InternalProfileManager.getInstance().fireProfileAdded(profile);
    }

    protected final void fireProfileDeleted(IConnectionProfile profile) {
        InternalProfileManager.getInstance().fireProfileDeleted(profile);
    }

    protected final void fireProfileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect) {
        InternalProfileManager.getInstance().fireProfileChanged(profile, oldName, oldDesc, oldAutoConnect);
    }

    private void autoConnectProfiles() {
        Iterator it = this.internalGetProfiles().values().iterator();
        while (it.hasNext()) {
            IConnectionProfile profile = (IConnectionProfile)it.next();
            if (!profile.isAutoConnect()) continue;
            profile.connect(null);
        }
    }

    public void dispose() {
        if (this.mProfiles == null) {
            return;
        }
        this.save();
        Iterator it = this.internalGetProfiles().values().iterator();
        while (it.hasNext()) {
            try {
                ((ConnectionProfile)it.next()).dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mProfiles.clear();
        this.mProfiles = null;
        InternalProfileManager.getInstance().removeRepository(this);
    }

    public ICategory getCategory(String catID) {
        if (this.supportsCategory(catID)) {
            CategoryProvider cp = ConnectionProfileManager.getInstance().getCategory(catID);
            return cp == null ? null : cp.createCategory(this);
        }
        return null;
    }

    public ICategory[] getRootCategories() {
        Collection allRootCategories = ConnectionProfileManager.getInstance().getCategories().values();
        ArrayList<ICategory> rootCategories = new ArrayList<ICategory>(allRootCategories.size());
        Iterator it = allRootCategories.iterator();
        while (it.hasNext()) {
            CategoryProvider cp = (CategoryProvider)it.next();
            if (cp.getParent() != null || "org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory".equals(cp.getId()) || !this.supportsCategory(cp.getId())) continue;
            rootCategories.add(cp.createCategory(this));
        }
        return rootCategories.toArray(new ICategory[rootCategories.size()]);
    }
}

