/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.SharedImages;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileCreateChange;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISkippable;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource;
import org.eclipse.datatools.connectivity.internal.ui.wizards.SummaryWizardPage;
import org.eclipse.datatools.connectivity.ui.wizards.ICPWizard;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizardPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class NewConnectionProfileWizard
extends BaseWizard
implements INewWizard,
ICPWizard,
IContextProvider {
    protected NewConnectionProfileWizardPage mProfilePage;
    protected SummaryWizardPage mSummaryPage;
    protected String mProviderID;
    protected IConnectionProfile mParentProfile;
    private boolean mSkipProfileNamePage = false;
    private String mProfileName;
    private String mProfileDesc;
    private IFinishTask mFinishTask;
    private boolean mIsFinished = false;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NewConnectionProfileWizard() {
        this.setWindowTitle(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizard.title"));
        this.setDefaultPageImageDescriptor(SharedImages.DESC_WIZBAN);
    }

    public boolean performFinish() {
        if (this.mIsFinished) {
            return true;
        }
        if (this.mFinishTask != null) {
            this.mIsFinished = this.mFinishTask.performFinish(this);
            return this.mIsFinished;
        }
        try {
            this.doFinish();
        }
        catch (CoreException e) {
            ExceptionHandler.showException(this.getShell(), ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizard.create.failure"), e.getLocalizedMessage(), e);
            this.mIsFinished = false;
            return false;
        }
        this.mIsFinished = true;
        return true;
    }

    public boolean isFinished() {
        return this.mIsFinished;
    }

    private void doFinish() throws CoreException {
        IConnectionProfile repo = this.mProfilePage.getRepository();
        PerformChangeOperation refOperation = new PerformChangeOperation((Change)new ConnectionProfileCreateChange(this.mProfilePage.getProfileName(), this.mProfilePage.getProfileDescription(), this.mProviderID, this.getProfileProperties(), repo == null ? null : repo.getInstanceID(), this.mProfilePage.getAutoConnect(), this.getShell(), this.mProfilePage.getAutoConnectOnFinish()));
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refOperation, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new OperationCanceledException();
        }
        catch (CoreException ce) {
            throw ce;
        }
        IViewPart part = null;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.datatools.connectivity.DataSourceExplorerNavigator");
        }
        if (part != null) {
            IConnectionProfile profile = null;
            if (repo != null) {
                IManagedConnection imc;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((imc = repo.getManagedConnection(clazz.getName())) != null) {
                    IConnectionProfileRepository repository = (IConnectionProfileRepository)imc.getConnection().getRawConnection();
                    profile = repository.getProfileByName(this.getProfileName());
                }
            } else {
                profile = ProfileManager.getInstance().getProfileByName(this.getProfileName());
            }
            if (profile == null) {
                return;
            }
            StructuredSelection targetSelection = new StructuredSelection((Object)profile);
            ISetSelectionTarget target = null;
            if (part instanceof ISetSelectionTarget) {
                target = (ISetSelectionTarget)part;
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                target = (ISetSelectionTarget)part.getAdapter((Class)clazz);
            }
            if (target != null) {
                final ISetSelectionTarget finalTarget = target;
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        finalTarget.selectReveal(this.val$targetSelection);
                    }
                });
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void initProviderID(String providerID) {
        this.mProviderID = providerID;
    }

    public abstract void addCustomPages();

    public void setProfileNameAndDescription() {
        if (this.mProfileName != null) {
            this.mProfilePage.setProfileName(this.mProfileName);
        }
        if (this.mProfileDesc != null) {
            this.mProfilePage.setProfileDescription(this.mProfileDesc);
        }
    }

    public List getSummaryData() {
        ArrayList data = new ArrayList();
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            ISkippable page;
            if (pages[i] instanceof ISummaryDataSource && (!(pages[i] instanceof ISkippable) || (page = (ISkippable)pages[i]) instanceof NewConnectionProfileWizardPage || !page.getSkippable())) {
                data.addAll(((ISummaryDataSource)pages[i]).getSummaryData());
            }
            ++i;
        }
        return data;
    }

    public String getProfileProviderID() {
        return this.mProviderID;
    }

    public String getProfileName() {
        return this.mProfilePage.getProfileName();
    }

    public void setProfileName(String name) {
        this.mProfileName = name;
        if (this.mProfilePage != null) {
            this.mProfilePage.setProfileName(this.mProfileName);
        }
    }

    public void setProfileDescription(String desc) {
        this.mProfileDesc = desc;
        if (this.mProfilePage != null) {
            this.mProfilePage.setProfileDescription(this.mProfileDesc);
        }
    }

    public String getProfileDescription() {
        return this.mProfilePage.getProfileDescription();
    }

    public boolean getProfileIsAutoConnect() {
        return this.mProfilePage.getAutoConnect();
    }

    public abstract Properties getProfileProperties();

    public String getParentProfile() {
        return this.mParentProfile == null ? new String() : this.mParentProfile.getName();
    }

    public void setParentProfile(IConnectionProfile profile) {
        this.mParentProfile = profile;
    }

    public void addPages() {
        super.addPages();
        this.mProfilePage = new NewConnectionProfileWizardPage();
        this.addPage((IWizardPage)this.mProfilePage);
        if (this.mProfileName != null) {
            this.mProfilePage.setProfileName(this.mProfileName);
        }
        if (this.mSkipProfileNamePage) {
            this.doSkipProfileNamePage(true);
        }
        this.addCustomPages();
        this.setProfileNameAndDescription();
        this.mSummaryPage = new SummaryWizardPage(this);
        this.addPage(this.mSummaryPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_NEW_CONNECTION_PROFILE_WIZARD", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    public void setSkipProfileNamePage(boolean skippable) {
        this.mSkipProfileNamePage = skippable;
        this.doSkipProfileNamePage(skippable);
    }

    protected void doSkipProfileNamePage(boolean skippable) {
        if (this.mProfilePage == null) {
            return;
        }
        this.mProfilePage.setSkippable(skippable);
    }

    public boolean isProfileNamePageSkippable() {
        if (this.mProfilePage != null) {
            return this.mProfilePage.getSkippable();
        }
        return this.mSkipProfileNamePage;
    }

    public void delegatesTask(IFinishTask task) {
        this.mFinishTask = task;
    }

    public NewConnectionProfileWizardPage getProfilePage() {
        return this.mProfilePage;
    }

    public static interface IFinishTask {
        public boolean performFinish(NewConnectionProfileWizard var1);
    }
}

