/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.IContentExtension;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;

public abstract class CommonContentProviderBase
implements ICommonContentProvider {
    private Map mProfileToExtensionNode = new HashMap();
    private Map mConnectionToExtensionNode = new HashMap();
    private ITreeContentProvider mDelegate;
    private IExtensionStateModel mStateModel;
    private Viewer mViewer;
    private IProfileListener mProfileListener = new IProfileListener(){

        public void profileAdded(IConnectionProfile profile) {
            CommonContentProviderBase.this.handleProfileAdded(profile);
        }

        public void profileChanged(IConnectionProfile profile) {
            CommonContentProviderBase.this.handleProfileChanged(profile);
        }

        public void profileDeleted(IConnectionProfile profile) {
            CommonContentProviderBase.this.handleProfileDeleted(profile);
        }
    };

    protected CommonContentProviderBase(ITreeContentProvider contentProvider) {
        this.mDelegate = contentProvider;
    }

    protected abstract IContentExtension createContentExtension(IConnectionProfile var1);

    public void dispose() {
        this.mDelegate.dispose();
        ProfileManager.getInstance().removeProfileListener(this.mProfileListener);
        Iterator it = this.mProfileToExtensionNode.values().iterator();
        while (it.hasNext()) {
            ((IContentExtension)it.next()).dispose();
        }
        this.mProfileToExtensionNode.clear();
        this.mStateModel = null;
    }

    public void init(IExtensionStateModel aStateModel, IMemento aMemento) {
        this.mStateModel = aStateModel;
    }

    public void init(ICommonContentExtensionSite aConfig) {
        this.mStateModel = aConfig.getExtensionStateModel();
        ProfileManager.getInstance().addProfileListener(this.mProfileListener);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    protected ITreeContentProvider getDelegate() {
        return this.mDelegate;
    }

    protected IExtensionStateModel getStateModel() {
        return this.mStateModel;
    }

    public IContentExtension getContentExtension(IConnectionProfile profile) {
        if (profile.getConnectionState() == 0) {
            return null;
        }
        IContentExtension extension = (IContentExtension)this.mProfileToExtensionNode.get(profile);
        if (extension == null) {
            extension = this.createContentExtension(profile);
            this.mProfileToExtensionNode.put(profile, extension);
            if (profile.getConnectionState() == 1) {
                try {
                    extension.openConnection();
                }
                catch (ExceptionInInitializerError e) {
                    ConnectivityUIPlugin.getDefault().log(e);
                    extension.closeConnection();
                }
                catch (Throwable e2) {
                    ConnectivityUIPlugin.getDefault().log(e2);
                    extension.closeConnection();
                }
            }
        }
        return extension;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (parentElement instanceof IConnectionProfile) {
            IContentExtension extension = this.getContentExtension((IConnectionProfile)parentElement);
            if (extension == null || extension.getConnection() == null || extension.getConnection().getConnectException() != null) {
                children = new Object[]{};
            } else {
                Object[] objectArray;
                if (this.extensionVisible(extension)) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = extension;
                } else {
                    objectArray = this.getChildren(extension);
                }
                children = objectArray;
            }
        } else if (parentElement instanceof IContentExtension) {
            IConnection ic = ((IContentExtension)parentElement).getConnection();
            Object connection = ic.getRawConnection();
            children = this.mDelegate.getChildren(connection);
            this.mConnectionToExtensionNode.put(connection, parentElement);
        } else {
            children = this.mDelegate.getChildren(parentElement);
        }
        return children;
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (!(element instanceof IConnectionProfile)) {
            if (element instanceof IContentExtension) {
                parent = ((IContentExtension)element).getConnectionProfile();
            } else {
                parent = this.mDelegate.getParent(element);
                if (this.mConnectionToExtensionNode.containsKey(parent) && (parent = this.mConnectionToExtensionNode.get(parent)) != null && !this.extensionVisible((IContentExtension)parent)) {
                    parent = this.getParent(parent);
                }
            }
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IConnectionProfile) {
            IContentExtension extension = this.getContentExtension((IConnectionProfile)element);
            if (extension == null || extension.getConnection() == null || extension.getConnection().getConnectException() != null) {
                return false;
            }
            return this.extensionVisible(extension) ? true : this.hasChildren(extension);
        }
        if (element instanceof IContentExtension) {
            IConnection ic = ((IContentExtension)element).getConnection();
            return this.mDelegate.hasChildren(ic.getRawConnection());
        }
        return this.mDelegate.hasChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.mDelegate.inputChanged(viewer, oldInput, newInput);
        this.mViewer = viewer;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommonContentProviderBase) {
            return ((CommonContentProviderBase)obj).mDelegate.equals(this.mDelegate);
        }
        return false;
    }

    public int hashCode() {
        return this.mDelegate.hashCode();
    }

    private boolean extensionVisible(IContentExtension extension) {
        if (!(this.mViewer instanceof CommonViewer)) {
            return true;
        }
        CommonViewer viewer = (CommonViewer)this.mViewer;
        INavigatorContentService contentService = viewer.getNavigatorContentService();
        Set contentExtensions = contentService.findRootContentExtensions((Object)extension.getConnectionProfile());
        return extension.isVisible() || contentExtensions != null && contentExtensions.size() > 2;
    }

    protected void handleProfileAdded(IConnectionProfile profile) {
    }

    protected void handleProfileChanged(IConnectionProfile profile) {
    }

    protected void handleProfileDeleted(IConnectionProfile profile) {
        IContentExtension contentExtension;
        if (this.mProfileToExtensionNode.containsKey(profile) && (contentExtension = (IContentExtension)this.mProfileToExtensionNode.remove(profile)) != null) {
            contentExtension.dispose();
        }
    }
}

