/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.XMLFileManager;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.DriversProvider;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DriverTreeContentProvider
implements ITreeContentProvider {
    private List psetsList;
    private String modified;
    private boolean mShowDriverTemplates = false;

    public DriverTreeContentProvider() {
    }

    public DriverTreeContentProvider(boolean showDriverTemplates) {
        this();
        this.mShowDriverTemplates = showDriverTemplates;
    }

    public List getDriverInstances() {
        return this.psetsList;
    }

    public void dispose() {
        if (this.psetsList != null) {
            this.psetsList.clear();
        }
    }

    public Object[] getChildren(Object element) {
        List<Object> children = new ArrayList();
        if (element instanceof DriversProvider) {
            children = Arrays.asList(CategoryDescriptor.getRootCategories());
        }
        if (element instanceof CategoryDescriptor) {
            CategoryDescriptor descriptor = (CategoryDescriptor)element;
            children = descriptor.getChildCategories();
            if (descriptor.getAssociatedDriverTypes().size() > 0) {
                if (this.mShowDriverTemplates) {
                    children.addAll(descriptor.getAssociatedDriverTypes());
                } else {
                    List driverTypes = descriptor.getAssociatedDriverTypes();
                    Iterator iter = driverTypes.iterator();
                    while (iter.hasNext()) {
                        TemplateDescriptor template = (TemplateDescriptor)iter.next();
                        children.addAll(Arrays.asList(this.getDriverDefn(template.getId())));
                    }
                }
            }
        } else if (element instanceof TemplateDescriptor && !this.mShowDriverTemplates) {
            TemplateDescriptor descriptor = (TemplateDescriptor)element;
            children = Arrays.asList(this.getDriverDefn(descriptor.getId()));
        }
        return children.toArray();
    }

    public Object[] getElements(Object element) {
        List<Object> children = new ArrayList();
        if (element instanceof DriversProvider) {
            children = Arrays.asList(CategoryDescriptor.getRootCategories());
        } else if (element instanceof CategoryDescriptor) {
            CategoryDescriptor descriptor = (CategoryDescriptor)element;
            children = descriptor.getChildCategories();
            children.addAll(descriptor.getAssociatedDriverTypes());
            Iterator iter = descriptor.getAssociatedDriverTypes().iterator();
            while (iter.hasNext()) {
                TemplateDescriptor template = (TemplateDescriptor)iter.next();
                children.addAll(Arrays.asList(this.getDriverDefn(template.getId())));
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof DriversProvider) {
            return null;
        }
        if (element instanceof CategoryDescriptor) {
            CategoryDescriptor descriptor = (CategoryDescriptor)element;
            return descriptor.getParent();
        }
        if (element instanceof TemplateDescriptor) {
            TemplateDescriptor descriptor = (TemplateDescriptor)element;
            return descriptor.getParent();
        }
        if (element instanceof IPropertySet) {
            IPropertySet propset = (IPropertySet)element;
            DriverInstance di = DriverManager.getInstance().getDriverInstanceByID(propset.getID());
            if (di != null) {
                return di.getTemplate();
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.psetsList = null;
    }

    private Object[] getDriverDefn(String categoryID) {
        XMLFileManager.setFileName((String)"driverStorage.xml");
        String newModified = XMLFileManager.getFileDateTimeStamp();
        if (this.psetsList == null || this.modified == null && newModified != null || this.modified != null && !this.modified.equals(newModified)) {
            DriverManager.getInstance().resetDefaultInstances();
            this.modified = XMLFileManager.getFileDateTimeStamp();
            try {
                this.psetsList = new ArrayList();
                IPropertySet[] psets = XMLFileManager.loadPropertySets();
                if (psets.length > 0) {
                    List<IPropertySet> tempList = Arrays.asList(psets);
                    this.psetsList.addAll(tempList);
                }
            }
            catch (CoreException e) {
                ConnectivityUIPlugin.getDefault().log(e);
                return new Object[0];
            }
        }
        ArrayList<IPropertySet> children = new ArrayList<IPropertySet>();
        if (this.psetsList.size() > 0) {
            int i = 0;
            while (i < this.psetsList.size()) {
                IPropertySet pset = (IPropertySet)this.psetsList.get(i);
                Properties props = pset.getBaseProperties();
                String category = props.getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
                if (category.equals(categoryID)) {
                    children.add(pset);
                }
                ++i;
            }
        }
        return children.toArray();
    }
}

